(****************************************************************************
 *
 * File: error.ml
 *
 * Purpose: display error messages in a uniform format
 *
 *)


let report msg =
  prerr_endline ("error: " ^ msg)


(*
 * Display an error message and return the stmt error state
 *)
let stmt_error msg =
  prerr_endline ("error: " ^ msg)
  (*[Bytecode.Halt]*)

(*
 * Display an error message and return the expr error state
 *)
let expr_error msg =
  prerr_endline ("error: " ^ msg)
  (*([Bytecode.Halt], Ast.Void)*)

(* 
 * Something happened that should never happen, exit and start debugging...
 *)
let internal_error msg =
  prerr_endline ("internal error: " ^ msg);
  ignore (exit 999)
