%{ open Ast 
let parse_error r = 
  print_endline r;
  flush stdout
%}

%token SEMI END OPEN CLOSE LBRACE RBRACE COMMA
%token PLUS MINUS TIMES DIVIDE ASSIGN
%token EQ NEQ LT LEQ GT GEQ 
%token SEND IF THEN OTHERWISE REPEAT CONSTRAINT SATISFY 
%token STATE COMPONENT
%token <int> LITERAL
%token <string> ID
%token EOF

%nonassoc NOOTHERWISE
%nonassoc OTHERWISE
%right ASSIGN
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS
%left TIMES DIVIDE

%start program
%type <Ast.program> program

%%

program:
   /* nothing */ { [], [] }
 | program vdecl { ($2 :: fst $1), snd $1 }
 | program fdecl { fst $1, ($2 :: snd $1) }

fdecl:
   COMPONENT ID OPEN formals_opt CLOSE LBRACE vdecl_list stmt_list RBRACE
     { { fname = $2;
	 formals = $4;
	 locals = List.rev $7;
	 body = List.rev $8 } }

formals_opt:
    /* nothing */ { [] }
  | formal_list   { List.rev $1 }

formal_list:
    ID                   { [$1] }
  | formal_list COMMA ID { $3 :: $1 }

vdecl_list:
    /* nothing */    { [] }
  | vdecl_list vdecl { $2 :: $1 }

vdecl:
   STATE ID { $2 }

stmt_list:
    /* nothing */  { [] }
  | stmt_list stmt { $2 :: $1 }

stmt:
    expr SEMI { Expr($1) }
  | SEND expr END { Send($2) }
  | LBRACE stmt_list RBRACE { Block(List.rev $2) }
  | IF expr THEN stmt %prec NOOTHERWISE { If($2, $4, Block([])) }
  | IF expr THEN stmt OTHERWISE stmt    { If($2, $4, $6) }
  | REPEAT OPEN expr_opt SEMI expr_opt SEMI expr_opt CLOSE stmt
     { Repeat($3, $5, $7, $9) }
  | CONSTRAINT expr SATISFY stmt { Constraint($2, $4) }

expr_opt:
    /* nothing */ { Noexpr }
  | expr          { $1 }

expr:
    LITERAL          { Literal($1) }
  | ID               { Id($1) }
  | expr PLUS   expr { Binop($1, Add,   $3) }
  | expr MINUS  expr { Binop($1, Sub,   $3) }
  | expr TIMES  expr { Binop($1, Mult,  $3) }
  | expr DIVIDE expr { Binop($1, Div,   $3) }
  | expr EQ     expr { Binop($1, Equal, $3) }
  | expr NEQ    expr { Binop($1, Neq,   $3) }
  | expr LT     expr { Binop($1, Less,  $3) }
  | expr LEQ    expr { Binop($1, Leq,   $3) }
  | expr GT     expr { Binop($1, Greater,  $3) }
  | expr GEQ    expr { Binop($1, Geq,   $3) }
  | ID ASSIGN expr   { Assign($1, $3) }
  | ID OPEN actuals_opt CLOSE { Call($1, $3) }
  | OPEN expr CLOSE { $2 }

actuals_opt:
    /* nothing */ { [] }
  | actuals_list  { List.rev $1 }

actuals_list:
    expr                    { [$1] }
  | actuals_list COMMA expr { $3 :: $1 }
