{ open Parser }

rule token = parse
  [' ' '\t' '\r' '\n'] { token lexbuf } (* Whitespace *)
| "::"     { comment lexbuf }           (* Comments *)
| "<<"          { OPEN }
| ">>"          { CLOSE }
| '['           { LBRACE }
| ']'           { RBRACE }
| ';'           { SEMI }
| ','           { COMMA }
| '+'           { PLUS }
| '-'           { MINUS }
| '*'           { TIMES }
| '/'           { DIVIDE }
| "<-"          { ASSIGN }  
| "=="          { EQ }
| "!="          { NEQ }
| '<'           { LT }
| "<="          { LEQ }
| ">"           { GT }
| ">="          { GEQ }
| "$"           { END }
| "if"          { IF }
| "then"        { THEN }
| "otherwise"   { OTHERWISE }
| "repeat"         { REPEAT }
| "constraint"  { CONSTRAINT }
| "satisfy"     { SATISFY }
| "send"        { SEND }
| "state"       { STATE }
| "component"   { COMPONENT }
| ['0'-'9']+ as lxm { LITERAL(int_of_string lxm) }
| ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm { ID(lxm) }
| eof { EOF }
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
  "::" { token lexbuf }
| _    { comment lexbuf }
