\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{gateway}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[12pt]{article}

\RequirePackage[T1]{fontenc}
\RequirePackage{times}       % Use the Times-Roman Font
\RequirePackage[scaled=0.88]{luximono} % A nice monospaced font for listings
\RequirePackage{hyperref}    % URLs, etc.
\RequirePackage{graphicx}    % System for including images

\RequirePackage{listings}    % Nicely formatted C listings

\lstset{
  language=C,
  basicstyle={\ttfamily}
}

\setlength\pdfpageheight{\paperheight}
\setlength\pdfpagewidth{\paperwidth}

\def\figref#1{Figure~\ref{fig:#1}}
\def\tabref#1{Table~\ref{tab:#1}}
\def\secref#1{Section~\ref{sec:#1}}

% Nicer looking section and subsection headers

\renewcommand\section{\@startsection {section}{1}{\z@}%
  {-0.8ex \@plus -0.8ex \@minus -.3ex}%
  {0.8ex \@plus .2ex}%
  {\normalfont\bfseries}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
  {-0.8ex \@plus -0.8ex \@minus -.3ex}%
  {0.8ex \@plus .2ex}%
  {\normalfont\itshape}}

\bibliographystyle{plain}

