#ifndef level1_H_
#define level1_H_


#include "global.h"
#include <math.h>


int tank_meet_flag[MAXTANK];
int sides_meet_flag;

unsigned int NotMoveover(unsigned int sprite);
//                   Y   X
unsigned int level1[15][18]=
{  //32*32 for each block     map does not have greybackground--need to add offset when giving coordinate:x-64 y-32     //8 for greybackground
  //  0    1    2    3    4    5   6     7    8     9   10  11   12   13   14   15    16   17    18  19   20   21   22   23   24   25   26   27   28   29   30   31   32
    {0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8},//0

    {0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf1,0x00,0x00,0xf1,0x00,0x00,0xf8},//1

    {0xf8,0x00,0xf1,0xf4,0xf4,0x00,0xf2,0x00,0xf1,0x00,0x00,0xf1,0x00,0x00,0x00,0x00,0x00,0xf8},//2

    {0xf8,0x00,0x00,0xf4,0xf4,0xf1,0xf3,0xf3,0xf3,0xf4,0xf4,0x00,0xf2,0x00,0x00,0x00,0xf2,0xf8},//3

    {0xf8,0x00,0x00,0x00,0x00,0x00,0xf3,0xf3,0xf3,0xf4,0xf4,0xf1,0x00,0x00,0x00,0x00,0xf1,0xf8},//4

    {0xf8,0x00,0xf2,0x00,0x00,0xf4,0xf4,0x00,0xf3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8},//5

    {0xf8,0xf3,0xf3,0xf1,0x00,0xf4,0xf4,0xf2,0x00,0x00,0x00,0x00,0xa1,0x00,0x00,0x00,0x00,0xf8},//6
    
    {0xf8,0xf3,0xf3,0xf3,0x00,0x00,0x00,0x00,0x00,0x00,0xf2,0x00,0x00,0xf2,0x00,0xf4,0xf4,0xf8},//7
    
    {0xf8,0x00,0xf1,0xf4,0xf4,0x00,0xf1,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf4,0xf4,0xf8},//8
    
    {0xf8,0xf2,0x00,0xf4,0xf4,0xf3,0xf3,0xf4,0xf4,0xf3,0xf3,0x00,0xf1,0x00,0x00,0x00,0x00,0xf8},//9
    
    {0xf8,0x00,0x00,0x00,0x00,0xf3,0x00,0xf4,0xf4,0xf3,0xf3,0xf4,0xf4,0x00,0x00,0x00,0x00,0xf8},//10
    
    {0xf8,0x00,0x00,0x00,0xf2,0xf3,0x00,0x00,0x00,0xf3,0xf3,0xf4,0xf4,0x00,0x00,0x00,0x00,0xf8},//11
    
    {0xf8,0x00,0x00,0xf1,0x00,0xf1,0x00,0x11,0x31,0x21,0x00,0x00,0x00,0x00,0xf3,0xf3,0xf3,0xf8},//12
   
    {0xf8,0xf1,0x00,0x00,0x00,0x00,0x00,0x51,0xf5,0xa1,0x00,0xf1,0xf2,0x00,0xf3,0xf3,0xf3,0xf8},//13  

    {0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8} //14 
  
};

unsigned int TYPES (unsigned int block)
      {
         return block & 0x0f;
      }

unsigned int BLOCKS (unsigned int block)
      {
         return ((block) & (0xf0))>>4;
      }





//check each tank to determine whether tanks can move or not
void TankCheck(unsigned int x_coord, unsigned int y_coord,unsigned int dir, unsigned int tank_num)

{
  int TankCheck_i;
  int tank_meet_count=0;

  for(TankCheck_i=0;TankCheck_i<MAXTANK;TankCheck_i++)
  {

      if(TankCheck_i != tank_num && tank_flag[TankCheck_i]==Tank_exist)
      {
        if(dir == Tank_up)   //check tank collision when moving up
        { 
           tank_meet_count += ((x_coord>=tank_x[TankCheck_i]) && (x_coord<=tank_x[TankCheck_i]+63) &&(y_coord>=tank_y[TankCheck_i]) && (y_coord<=(tank_y[TankCheck_i]+31))) || (((x_coord+61)>=tank_x[TankCheck_i]) && ((x_coord+61)<=tank_x[TankCheck_i]+63) &&(y_coord>=tank_y[TankCheck_i]) && (y_coord<=(tank_y[TankCheck_i]+31))) ;

        }
        if(dir == Tank_down)  //check tank collision when moving down
        {
           tank_meet_count += ((x_coord>=tank_x[TankCheck_i]) && (x_coord<=tank_x[TankCheck_i]+63) &&((y_coord+31)>=tank_y[TankCheck_i]) && ((y_coord+31)<=(tank_y[TankCheck_i]+31))) || (((x_coord+61)>=tank_x[TankCheck_i]) && ((x_coord+61)<=tank_x[TankCheck_i]+63) &&((y_coord+31)>=tank_y[TankCheck_i]) && ((y_coord+31)<=(tank_y[TankCheck_i]+31)) );
        }
        if(dir == Tank_left) //check tank collision when moving left
        {
           tank_meet_count += ((x_coord>=tank_x[TankCheck_i]) && (x_coord<=tank_x[TankCheck_i]+63) &&(y_coord>=tank_y[TankCheck_i]) && (y_coord<=(tank_y[TankCheck_i]+31))) || ((x_coord>=tank_x[TankCheck_i]) && (x_coord<=tank_x[TankCheck_i]+63) &&((y_coord+31)>=tank_y[TankCheck_i]) && ((y_coord+31)<=(tank_y[TankCheck_i]+31)));
        }
        if(dir == Tank_right) //check tank collision when moving right
        {
           tank_meet_count += (((x_coord+61)>=tank_x[TankCheck_i]) && ((x_coord+61)<=tank_x[TankCheck_i]+63) &&(y_coord>=tank_y[TankCheck_i]) && (y_coord<=(tank_y[TankCheck_i]+31))) || (((x_coord+61)>=tank_x[TankCheck_i]) && ((x_coord+61)<=tank_x[TankCheck_i]+63) &&((y_coord+31)>=tank_y[TankCheck_i]) && ((y_coord+31)<=(tank_y[TankCheck_i]+31)));
        }
      }
  }
    
    if(tank_meet_count != 0)
       tank_meet_flag[tank_num]=1;
}




//updates map after bullet make brick disappear
void setBrickMap(unsigned int bullet_x_coord, unsigned int bullet_y_coord)
{  
  int bullet_x_block=bullet_x_coord/64;
  int bullet_y_block=bullet_y_coord/32;
  int bullet_x_remainder=bullet_x_coord%64;
  int bullet_y_remainder=bullet_y_coord%32;

  if(TYPES(level1[bullet_y_block][bullet_x_block]) == 0x01)   //determine whether current block is brick or not  
    {  //enter=1;                                                      

         if((bullet_x_remainder>=0 && bullet_x_remainder<=31) && (bullet_y_remainder>=0 && bullet_y_remainder<=15))   //  brick at top left corner disappear
          level1[bullet_y_block][bullet_x_block]=level1[bullet_y_block][bullet_x_block] & 0x71;
         if((bullet_x_remainder>=0 && bullet_x_remainder<=31) && (bullet_y_remainder>=16 && bullet_y_remainder<=31))   //  brick at bottom left corner disappear
          level1[bullet_y_block][bullet_x_block]=level1[bullet_y_block][bullet_x_block] & 0xd1;
         if(((bullet_x_remainder>=32 && bullet_x_remainder<=63)) && (bullet_y_remainder>=0 && bullet_y_remainder<=15))   //  brick at top right corner disappear
          level1[bullet_y_block][bullet_x_block]=level1[bullet_y_block][bullet_x_block] & 0xb1;
         if(((bullet_x_remainder>=32 && bullet_x_remainder<=63)) && (bullet_y_remainder>=16 && bullet_y_remainder<=31))   //  brick at bottom right corner disappear
          level1[bullet_y_block][bullet_x_block]=level1[bullet_y_block][bullet_x_block] & 0xe1;

   }
}



//tank can not move over these things
unsigned int NotMoveover(unsigned int sprite)
{
    if(sprite==Brick || sprite==Steel || sprite==Water || sprite==Homebase || sprite==Sprite_Player1 || sprite==Sprite_Player2 || sprite==Greybackground)

    	return 1;
    else
    	return 0;
}



//check whether there is an obstacle in certain position
unsigned int TankObstacleCheck(unsigned int x_coord, unsigned int y_coord)
{  
   int x_block = x_coord/64;
   int y_block = y_coord/32;

  if (TYPES(level1[y_block][x_block]) == 0x0)    // no obstacle appears
	    return 0;

 else if(TYPES(level1[y_block][x_block]) == 0x1)  //the obstacle is brick and check its appearance
{    
        if ((BLOCKS(level1[y_block][x_block]) == 0x1)&& NotMoveover(TYPES(level1[y_block][x_block])))
        { 
            if ((x_coord)>=(x_block*64+32) && (x_coord)<=(x_block*64+63) && (y_coord>=(y_block*32+15)) && (y_coord<=(y_block*32+31)))
               return 1; 
            else
               return 0;
        }
        if ((BLOCKS(level1[y_block][x_block]) == 0x2) && NotMoveover(TYPES(level1[y_block][x_block])))   
         {  
            if ((x_coord)>=(x_block*64) && ((x_coord)<=(x_block*64+31)) && (y_coord>=(y_block*32+15)) && (y_coord<=(y_block*32+31)))
              return 1;
            else
              return 0;
         }
        if ((BLOCKS(level1[y_block][x_block]) == 0x3) && NotMoveover(TYPES(level1[y_block][x_block]))) 
        {    // enter=1; 
            if ((y_coord>=(y_block*32+15)) && (y_coord<=(y_block*32+31)))
             return 1; 
            else
             return 0;
         }
        if ((BLOCKS(level1[y_block][x_block]) == 0x4) && NotMoveover(TYPES(level1[y_block][x_block])))
        {      
          if((x_coord)>=(x_block*64+32) && ((x_coord)<=(x_block*64+63)) && (y_coord>=y_block*32) && (y_coord<=(y_block*32+14)))
            return 1;
          else
            return 0;
        }
        if ((BLOCKS(level1[y_block][x_block]) == 0x5) && NotMoveover(TYPES(level1[y_block][x_block]))) 
        {     
          if((x_coord)>=(x_block*64+32) && ((x_coord)<=(x_block*64+63)) && (y_coord>=y_block*32) && (y_coord<=(y_block*32+31)))
            return 1;
        else
            return 0;
        }
        if ((BLOCKS(level1[y_block][x_block]) == 0x6) && NotMoveover(TYPES(level1[y_block][x_block])))
        {   
           if(((x_coord)>=(x_block*64+32) && ((x_coord)<=(x_block*64+63)) && (y_coord>=y_block*32) && (y_coord<=(y_block*32+14)))     //0x04
            ||((x_coord)>=(x_block*64) && ((x_coord)<=(x_block*64+31)) && (y_coord>=(y_block*32+15)) && (y_coord<=(y_block*32+31))))  //0x02
            return 1;
           else
            return 0;
        }
        if ((BLOCKS(level1[y_block][x_block]) == 0x7) && NotMoveover(TYPES(level1[y_block][x_block])))
        {    
          if((x_coord)>=(x_block*64) && ((x_coord)<=(x_block*64+31)) && (y_coord>=y_block*32) && (y_coord<=(y_block*32+14)))  //this part does not have brick
            return 0;
          else
            return 1;
        }
        if ((BLOCKS(level1[y_block][x_block]) == 0x8) && NotMoveover(TYPES(level1[y_block][x_block]))) 
          {  
           if((x_coord)>=(x_block*64) && ((x_coord)<=(x_block*64+31)) && (y_coord>=y_block*32) && (y_coord<=(y_block*32+14)))   
            return 1;
           else
            return 0;
           }
        if ((BLOCKS(level1[y_block][x_block]) == 0x9) && NotMoveover(TYPES(level1[y_block][x_block]))) 
        {  
           if(((x_coord)>=(x_block*64) && ((x_coord)<=(x_block*64+31)) && (y_coord>=y_block*32) && (y_coord<=(y_block*32+14))) //0x8
             ||((x_coord)>=(x_block*64+32) && (x_coord)<=(x_block*64+63) && (y_coord>=(y_block*32+15)) && (y_coord<=(y_block*32+31)))) //0x1  
            return 1;
           else
            return 0;
        }
        if ((BLOCKS(level1[y_block][x_block]) == 0xa) && NotMoveover(TYPES(level1[y_block][x_block]))) 
        { 
          if((x_coord)>=(x_block*64+32) && ((x_coord)<=(x_block*64+63)) && (y_coord>=y_block*32) && (y_coord<=(y_block*32+31)))    //without brick
            return 0;
          else
            return 1;
        }
        if ((BLOCKS(level1[y_block][x_block]) == 0xb) && NotMoveover(TYPES(level1[y_block][x_block])))
        {    
          if((x_coord)>=(x_block*64+32) && ((x_coord)<=(x_block*64+63)) && (y_coord>=y_block*32) && (y_coord<=(y_block*32+14)))  //without brick
            return 0;
          else
            return 1;
        }
        if ((BLOCKS(level1[y_block][x_block]) == 0xc) && NotMoveover(TYPES(level1[y_block][x_block])))
        { 
          if ((y_coord>=(y_block*32+15)) && (y_coord<=(y_block*32+31)))        //without brick
            return 0;
          else
            return 1;
        }
        if ((BLOCKS(level1[y_block][x_block]) == 0xd) && NotMoveover(TYPES(level1[y_block][x_block])))
        { 
          if((x_coord)>=(x_block*64) && ((x_coord)<=(x_block*64+31)) && (y_coord>=(y_block*32+15)) && (y_coord<=(y_block*32+31)))    //without brick     
            return 0;
          else
            return 1;
        }
        if ((BLOCKS(level1[y_block][x_block]) == 0xe) && NotMoveover(TYPES(level1[y_block][x_block]))) 
        {   
          if((x_coord)>=(x_block*64+32) && (x_coord)<=(x_block*64+63) && (y_coord>=(y_block*32+15)) && (y_coord<=(y_block*32+31)))  //without brick
            return 0;
           else
            return 1;
        }
        if ((BLOCKS(level1[y_block][x_block]) == 0xf) && NotMoveover(TYPES(level1[y_block][x_block])))      
            return 1;
        else
            return 0;
}

  
   else if (TYPES(level1[y_block][x_block]) ==0x2 || TYPES(level1[y_block][x_block]) ==4 || TYPES(level1[y_block][x_block]) ==5 || TYPES(level1[y_block][x_block]) ==6)
       {   
           return 1;
       }
       else 
      {return 0;}
}

//check whether the tank can move up or not
unsigned int cannotMoveup(unsigned int x_coord, unsigned int y_coord)
{
    return TankObstacleCheck(x_coord,y_coord) || TankObstacleCheck(x_coord+16,y_coord) || TankObstacleCheck(x_coord+32,y_coord) || TankObstacleCheck(x_coord+48,y_coord) || TankObstacleCheck(x_coord+62,y_coord);
}

//check whether the tank can move down or not
unsigned int cannotMovedown(unsigned int x_coord, unsigned int y_coord)
{
    return TankObstacleCheck(x_coord,y_coord+31) || TankObstacleCheck(x_coord+16,y_coord+31) || TankObstacleCheck(x_coord+32,y_coord+31) || TankObstacleCheck(x_coord+48,y_coord) || TankObstacleCheck(x_coord+62,y_coord+31);

}

//check whether the tank can move left or not
unsigned int cannotMoveleft(unsigned int x_coord, unsigned int y_coord)
{
    return TankObstacleCheck(x_coord,y_coord) || TankObstacleCheck(x_coord,y_coord+8) || TankObstacleCheck(x_coord,y_coord+16) || TankObstacleCheck(x_coord,y_coord+24) || TankObstacleCheck(x_coord,y_coord+31);
}

//check whether the tank can move right or not
unsigned int cannotMoveright(unsigned int x_coord, unsigned int y_coord)
{
    return TankObstacleCheck(x_coord+62,y_coord) || TankObstacleCheck(x_coord+62,y_coord+8) || TankObstacleCheck(x_coord+62,y_coord+16) || TankObstacleCheck(x_coord+62,y_coord+24) || TankObstacleCheck(x_coord+62,y_coord+31)
;
}

//check whether tank can move over backgrounds or not:up down left right    call function above
void cannotTankMove (unsigned int x_coord, unsigned int y_coord, unsigned int dir)
{   
                                       // sides_meet_flag = 1 means tank cannot move over
 if(dir==Tank_up)
     sides_meet_flag= cannotMoveup(x_coord, y_coord);
 if(dir==Tank_down)
     sides_meet_flag= cannotMovedown(x_coord, y_coord);
 if(dir==Tank_left)
     sides_meet_flag= cannotMoveleft(x_coord, y_coord);
 if(dir==Tank_right)
     sides_meet_flag= cannotMoveright(x_coord, y_coord);
 //if((x_coord==62 && dir==3) || (x_coord==1026 && dir==4) || (y_coord==31 && dir==1)|| (y_coord==417 && dir==2))//check next position
   if(x_coord<=62 || x_coord>=1026 || y_coord<=31 || y_coord>=417)
     sides_meet_flag= 1;

}


//////////////////////////////////////////////generate stop flag for each tank/////////////////////////
void generate_flag(unsigned int tank_num)
{
	tank_meet_flag[tank_num] = 0;
        tank_stop_flag[tank_num] = 0;
        sides_meet_flag = 0 ;   
        
        setBrickMap(bullet_x[tank_num], bullet_y[tank_num]); 
    
        cannotTankMove (tank_x_temp[tank_num],tank_y_temp[tank_num],tank_direction[tank_num]);

	TankCheck(tank_x_temp[tank_num],tank_y_temp[tank_num],tank_direction[tank_num], tank_num);

        tank_stop_flag[tank_num] = sides_meet_flag || tank_meet_flag[tank_num];

}




////////////////////////////////////////////////////////////////////////////////////////////


#endif





