module qtysingle(	input logic clk,
		input logic reset,
		input logic[15:0] msgtype,
		input logic[7:0] idindex,
		input logic[7:0] symbolindex,
		input logic iderror,
		input logic symbolerror,
		input logic idvalid,
		input logic symbolvalid,
		input logic[7:0] side,
		input logic[31:0] qty,
		output logic flag,
		output logic valid);		//flag == 1, through; flag == 0, drop

	parameter idnum = 4;
	parameter symbolnum = 4;
	parameter depth = idnum*symbolnum;

	logic[0:depth-1][31:0] buylimit;
	logic[0:depth-1][31:0] selllimit;
	
	assign buylimit[0] = 32'd0;
	assign buylimit[1] = 32'd10;
	assign buylimit[2] = 32'd10;
	assign buylimit[3] = 32'd100;
	assign buylimit[4] = 32'd100;
	assign buylimit[5] = 32'd1000;
	assign buylimit[6] = 32'd1000;
	assign buylimit[7] = 32'd10000;
	assign buylimit[8] = 32'd10000;
	assign buylimit[9] = 32'd100000;
	assign buylimit[10] = 32'd100000;
	assign buylimit[11] = 32'd1000000;
	assign buylimit[12] = 32'd1000000;
	assign buylimit[13] = 32'd100000;
	assign buylimit[14] = 32'd10000;
	assign buylimit[15] = 32'd1000;

	assign selllimit[0] = 32'd0;
	assign selllimit[1] = 32'd10;
	assign selllimit[2] = 32'd10;
	assign selllimit[3] = 32'd100;
	assign selllimit[4] = 32'd100;
	assign selllimit[5] = 32'd1000;
	assign selllimit[6] = 32'd1000;
	assign selllimit[7] = 32'd10000;
	assign selllimit[8] = 32'd10000;
	assign selllimit[9] = 32'd100000;
	assign selllimit[10] = 32'd100000;
	assign selllimit[11] = 32'd1000000;
	assign selllimit[12] = 32'd1000000;
	assign selllimit[13] = 32'd100000;
	assign selllimit[14] = 32'd10000;
	assign selllimit[15] = 32'd1000;

	initial begin
	flag = 1;
	valid = 0;
	end

	always_ff@(posedge clk) begin
		if(reset) begin
			flag <= 1;
			valid <= 0;
		end
		else if(msgtype==16'd0 && side==8'h00 && qty==32'd0) begin 
			flag <= 1;
			valid <= 0;
		end
		else if(idvalid && symbolvalid && iderror==0 && symbolerror==0 && msgtype==16'h4400 && side!=8'd0 && qty!=32'd0 && valid == 0) begin
			if(side==8'h31) begin
				if(qty <= buylimit[idindex*symbolnum+symbolindex]) begin
					flag <= 1;
					valid <= 1;
				end
				else begin
					flag <= 0;
					valid <= 1;
				end
			end
			
			if(side==8'h32) begin
				if(qty <= selllimit[idindex*symbolnum+symbolindex]) begin
					flag <= 1;
					valid <= 1;
				end
				else begin
					flag <= 0;
					valid <= 1;
				end
			end
			
		end
	end
endmodule
