module pktnum(	input logic clk,
		input logic reset,
		input logic[15:0] msgtype,
		output logic flag,
		output logic valid);   //flag == 1, through; flag == 0, drop

	parameter numlimit = 1000000;

	logic[31:0] numcounter;
	logic[31:0] scounter;

	initial begin
	flag = 1;
	valid = 0;
	numcounter = 32'd0;
	scounter = 32'd0;
	end

	always_ff@(posedge clk) begin
		if(reset)begin
			flag <= 1;
			valid <= 0;
			numcounter <= 32'd0;
			scounter <= 32'd0;
		end
		else if(scounter == 32'd200000000) begin
			numcounter <= 32'd0;
			scounter <= 32'd0;
		end
		else if(msgtype==16'h4400 && valid == 0) begin
			if(numcounter == numlimit) begin
				scounter <= scounter + 1;
				flag <= 0;
				valid <= 1;
			end
			else begin
				scounter <= scounter + 1;
				numcounter <= numcounter +1;
				flag <= 1;
				valid <= 1;
			end
		end
		else if(msgtype==16'h0000) begin
			flag <= 1;
			valid <= 0;
			scounter <= scounter + 1;
		end
		else scounter <= scounter + 1;
	end




endmodule
