module parser_down(input logic clk,reset,
		input logic validreg,readypreproc,startofpacket,endofpacket,validcontroller,
		input logic[7:0] mesg,
		output logic readypar,validpar,
		output logic [31:0] tag,
		output logic [167:0] value);					

	logic [31:0] tag0;
	logic [167:0] value0;
	logic flag;

	int i,j;


	typedef enum logic[3:0]{IDLE, READTAG, READVALUE, DONE} state_t;
	state_t state;

	initial begin
		state = IDLE;
		readypar = 1;
		validpar = 0;
		tag[31:0] = 32'd0;
		value[167:0] = 168'd0;
		tag0[31:0] = 32'd0;
		value0[167:0] = 168'd0;
		i=31;
		j=167;
	end
	
	always_ff@(posedge clk) begin
		if(reset) begin
			state <= IDLE;
			readypar = 1;
			validpar = 0;
			tag0[31:0] = 32'd0;
			value0[167:0] = 168'd0;
			tag[31:0] = 32'd0;
			value[167:0] = 168'd0;
			i=31;
			j=167;
		end

		else if(validcontroller) begin
			state <= IDLE;
			readypar = 1;
			validpar = 0;
			tag0[31:0] = 32'd0;
			value0[167:0] = 168'd0;
			tag[31:0] = 32'd0;
			value[167:0] = 168'd0;
			i=31;
			j=167;
		end
		
		else case(state)
			IDLE:	begin
				if(validreg == 0) ;
				else if(startofpacket==1)begin
					if(i == 31)begin 
						tag0[31:24] <= mesg[7:0];
						i <= i-8;
						state <= READTAG;
					end
				end
				end

			READTAG:begin
				if(validreg == 0) ;
				else if(mesg!=8'h3D) begin
					if(i == 31) tag0[31:24] <= mesg[7:0];
					else if(i == 23) tag0[23:16] <= mesg[7:0];
					else if(i == 15) tag0[15:8] <= mesg[7:0];
					else if(i == 7) tag0[7:0] <= mesg[7:0];
					//state <= READTAG;
					i <= i-8;
				end				
				else begin
					if(tag0 == 32'h31300000) flag <= 1;
					state <= READVALUE;
				end
				end
					
			READVALUE:begin
					if(validreg == 0) ;
					else if(mesg!=8'h7C) begin
						if(j==7) value0[7:0] <= mesg[7:0];
						else if(j==15) value0[15:8] <= mesg[7:0];
						else if(j==23) value0[23:16] <= mesg[7:0];
						else if(j==31) value0[31:24] <= mesg[7:0];
						else if(j==39) value0[39:32] <= mesg[7:0];
						else if(j==47) value0[47:40] <= mesg[7:0];
						else if(j==55) value0[55:48] <= mesg[7:0];
						else if(j==63) value0[63:56] <= mesg[7:0];
						else if(j==71) value0[71:64] <= mesg[7:0];
						else if(j==79) value0[79:72] <= mesg[7:0];
						else if(j==87) value0[87:80] <= mesg[7:0];
						else if(j==95) value0[95:88] <= mesg[7:0];
						else if(j==103) value0[103:96] <= mesg[7:0];
						else if(j==111) value0[111:104] <= mesg[7:0];
						else if(j==119) value0[119:112] <= mesg[7:0];
						else if(j==127) value0[127:120] <= mesg[7:0];
						else if(j==135) value0[135:128] <= mesg[7:0];
						else if(j==143) value0[143:136] <= mesg[7:0];
						else if(j==151) value0[151:144] <= mesg[7:0];
						else if(j==159) value0[159:152] <= mesg[7:0];
						else if(j==167) value0[167:160] <= mesg[7:0];
						//state <= READVALUE;
						j <= j-8;
						end
					   else begin
			   			tag[31:0] <= tag0[31:0];
						value[167:0] <= value0[167:0];						
						state <= DONE;	
						validpar <= 1;				
						readypar <= 0;
						if(endofpacket == 1) flag <= 1;
						else flag <= 0;	
											
						end
				end
								
			DONE: begin
				if(readypreproc == 0) ;
				else begin
					i <= 31;
					j <= 167;
					tag0[31:0] <= 32'd0;
					value0[167:0] <= 168'd0;
					tag[31:0] <= 32'd0;
					value[167:0] <= 168'd0;
					readypar <= 1;	
					validpar <= 0;			
					if(flag == 1)begin
						state <= IDLE;
						flag <= 0;
					end					
					else state <= READTAG;	
				end
				end	
   		endcase
	end
				
endmodule
