module packetizer_down( input logic clk, reset,
		input logic readybackend, readypar, validpkt,startofpkt,endofpkt,validswitch,
		input logic [2:0] empty,
		input logic [63:0] pkt,
		output logic validtopar,validtobackend, readypktz,startofpacket,endofpacket,sop,eop,
		output logic [7:0] datatopar,
		output logic [2:0] o_empty,
		output logic [63:0] data

);
	logic flag,flag2,flag3,flag4;
	logic [7:0] FIFO [0:255];
	logic [2:0] Empty;
	integer counter0=0, counter1=66, counter2=0,i;

	initial begin
		for(i=0;i<256;i++)begin
			FIFO[i]=8'd0;
		end
		Empty=3'd0;
		o_empty=3'd0;
		readypktz=1;
		validtopar=0;
		validtobackend=0;
		startofpacket=0;
		endofpacket=0;
		sop=0;
		eop=0;
		datatopar=8'd0;
		data=64'd0;
		flag=0;
		flag2=0;
		flag3=0;
		flag4=0;
		
	end
	always_ff@(posedge clk) begin
	    if(reset)begin
		
		for(i=0;i<256;i++)begin
			FIFO[i]=8'd0;
		end	
		Empty<=3'd0;
		o_empty<=3'd0;	
		flag<=0;
		flag2<=0;
		flag3<=0;
		flag4<=0;
		readypktz<=1;
		validtopar<=0;
		validtobackend<=0;
		startofpacket<=0;
		endofpacket<=0;
		sop<=0;
		eop<=0;
		datatopar<=8'd0;
		data<=64'd0;
		counter0<=0;
		counter1<=66;
		counter2<=0;
		
	    end

	    else begin
		if(validpkt) begin
		  if(startofpkt && counter0==0)begin
		
			FIFO[counter0]<=pkt[63:56];
			FIFO[counter0+1]<=pkt[55:48];
			FIFO[counter0+2]<=pkt[47:40];
			FIFO[counter0+3]<=pkt[39:32];
           		FIFO[counter0+4]<=pkt[31:24];
			FIFO[counter0+5]<=pkt[23:16];
			FIFO[counter0+6]<=pkt[15:8];
			FIFO[counter0+7]<=pkt[7:0];
			counter0<=counter0+8;
			flag<=1;
		  end	
		  if(flag) begin
			
			if(empty==3'd0)begin
				FIFO[counter0]<=pkt[63:56];
				FIFO[counter0+1]<=pkt[55:48];
				FIFO[counter0+2]<=pkt[47:40];
				FIFO[counter0+3]<=pkt[39:32];
		       		FIFO[counter0+4]<=pkt[31:24];
				FIFO[counter0+5]<=pkt[23:16];
				FIFO[counter0+6]<=pkt[15:8];
				FIFO[counter0+7]<=pkt[7:0];
			end
			else if(empty==3'd1) begin
				FIFO[counter0]<=pkt[63:56];
				FIFO[counter0+1]<=pkt[55:48];
				FIFO[counter0+2]<=pkt[47:40];
				FIFO[counter0+3]<=pkt[39:32];
		       		FIFO[counter0+4]<=pkt[31:24];
				FIFO[counter0+5]<=pkt[23:16];
				FIFO[counter0+6]<=pkt[15:8];
			end
			else if(empty==3'd2) begin
				FIFO[counter0]<=pkt[63:56];
				FIFO[counter0+1]<=pkt[55:48];
				FIFO[counter0+2]<=pkt[47:40];
				FIFO[counter0+3]<=pkt[39:32];
		       		FIFO[counter0+4]<=pkt[31:24];
				FIFO[counter0+5]<=pkt[23:16];
			end
			else if(empty==3'd3) begin
			        FIFO[counter0]<=pkt[63:56];
				FIFO[counter0+1]<=pkt[55:48];
				FIFO[counter0+2]<=pkt[47:40];
				FIFO[counter0+3]<=pkt[39:32];
		       		FIFO[counter0+4]<=pkt[31:24];
			end
			else if(empty==3'd4) begin
				FIFO[counter0]<=pkt[63:56];
				FIFO[counter0+1]<=pkt[55:48];
				FIFO[counter0+2]<=pkt[47:40];
				FIFO[counter0+3]<=pkt[39:32];
			end
			else if(empty==3'd5) begin
				FIFO[counter0]<=pkt[63:56];
				FIFO[counter0+1]<=pkt[55:48];
				FIFO[counter0+2]<=pkt[47:40];
			end
			else if(empty==3'd6) begin
				FIFO[counter0]<=pkt[63:56];
				FIFO[counter0+1]<=pkt[55:48];
			end
			else    FIFO[counter0]<=pkt[63:56];
			counter0<=counter0+8;
				
		  end
		  if(endofpkt) begin
			if(counter0<66) flag4<=1;
			else if(FIFO[66]!=8'h38 || FIFO[67]!=8'h3d || FIFO[68]!=8'h46 || FIFO[69]!=8'h49 || FIFO[70]!=8'h58)
				flag4<=1;

			else begin
				
           			flag2<=1;
			end
			flag<=0;
			readypktz<=0;
		  end
		end
		
		if(flag2 && readypar) begin /*original:counter0>64*/
			if(counter1>65 && counter1<counter0) begin

				if(counter1==66) begin //start
					startofpacket<=1;	
				end
				else if(counter1==counter0-1) begin //end
					endofpacket<=1;
				end
				else begin
					startofpacket<=0;
					endofpacket<=0;
				end
				validtopar<=1;
				datatopar<=FIFO[counter1];
				counter1<=counter1+1;
			end
			
			else begin
				endofpacket<=0;
				startofpacket<=0;
				validtopar<=0;
				datatopar<=8'd0;
			end
		end
		if(validswitch) begin
			flag3<=1;
		end
		if((flag2 && readybackend && flag3) || flag4) begin /*original:counter0>64*/
			if(counter2<counter0) begin

				if(counter2==0) begin //start
					sop<=1;
				end
				else if(counter2==counter0-8) begin //end
					o_empty<=Empty;
					eop<=1;
				end
				else begin
					sop<=0;
					eop<=0;
				end
				validtobackend<=1;
				/*datatoswitch<={FIFO[counter2],FIFO[counter2+1],FIFO[counter2+1],FIFO[counter2+3],FIFO[counter2+4],FIFO[counter2+5],FIFO[counter2+6],FIFO[counter2+7]}*/
				data[63:56]<=FIFO[counter2];
				data[55:48]<=FIFO[counter2+1];
				data[47:40]<=FIFO[counter2+2];
				data[39:32]<=FIFO[counter2+3];
				data[31:24]<=FIFO[counter2+4];
				data[23:16]<=FIFO[counter2+5];
				data[15:8]<=FIFO[counter2+6];
				data[7:0]<=FIFO[counter2+7];

				counter2<=counter2+8;
			end
			
			else begin
				Empty<=3'd0;
				o_empty<=3'd0;
				flag4<=0;
				flag3<=0;
               		        flag2<=0;
				readypktz<=1;
				sop<=0;
				eop<=0;
				validtobackend<=0;
				data<=64'd0;
				for(i=0;i<256;i++)begin
				FIFO[i]=8'd0;
				end
				counter0<=0;
				counter1<=66;
				counter2<=0;
			
			end
		end

	    end
	end


endmodule
