module controller_down(  	input logic clk,reset,
			input logic validD,
			input logic[15:0] msgtype,
			output logic valid
        );



	typedef enum logic[2:0]{IDLE, JUDGE, OUTPUT} state_t;
	state_t state;

    	initial begin
	valid = 0;
	state = IDLE;
    	end
    

    	always_ff@(posedge clk) begin
		if(reset) begin
            		valid <= 0;
			state <= IDLE;
        end
        
        else case(state)
		IDLE: begin
			if(msgtype==16'h0000) state <= JUDGE;
		end
		JUDGE: begin
			if(msgtype!=16'h0000 && msgtype!=16'h3800) begin
				valid <= 1;
				state <= OUTPUT;
			end
			else if(msgtype==16'h3800 && validD==1)begin
				valid <= 1;
				state <= OUTPUT;
			end

		
		end

		OUTPUT: begin
			valid <= 0;
			state <= IDLE;
		end

	endcase
	end

endmodule
