module controller(  	input logic clk,reset,
			input logic validID,validSymbol,validQty,validQty2,errID,errSymbol,errQty,errQty2,validnum,errnum,
			input logic[15:0] msgtype,
			output logic valid,drop
        );



	typedef enum logic[2:0]{IDLE, JUDGE, OUTPUT} state_t;
	state_t state;

    	initial begin
	valid = 0;
	drop = 0;
	state = IDLE;
    	end
    

    	always_ff@(posedge clk) begin
		if(reset) begin
            		valid <= 0;
			drop <= 0;
			state <= IDLE;
        end
        
        else case(state)
		IDLE: begin
			if(msgtype==16'h0000) state <= JUDGE;
		end
		JUDGE: begin
			if(msgtype!=16'h0000 && msgtype!=16'h4400 && validID==1 && errID==0) begin
				drop <= 0;
				valid <= 1;
				state <= OUTPUT;
			end
			else if(msgtype!=16'h0000 && msgtype!=16'h4400 && validID==1 && errID==1) begin
				drop <= 1;
				valid <= 1;
				state <= OUTPUT;
			end
			else if(msgtype==16'h4400 && validID==1 && errID==0 && validSymbol==1 && errSymbol==0 && validQty==1 && errQty==0 && validQty2==1 && errQty2==0 && validnum==1 &&errnum==0)begin
				drop <= 0;
				valid <= 1;
				state <= OUTPUT;
			end
			else if(msgtype==16'h4400 && validID==1 && validSymbol==1 && validQty==1 && validQty2==1 && validnum==1)begin
				drop <= 1;
				valid <= 1;
				state <= OUTPUT;
			end
		
		end

		OUTPUT: begin
			drop <= 0;
			valid <= 0;
			state <= IDLE;
		end

	endcase
	end

endmodule
