module IDcam_down(  	input logic clk,reset,
		input logic [63:0] senderid,targid,
		output logic validcam,error,
		output logic [7:0] addr);

    	parameter namewidth = 2;
    	parameter depth =1 << namewidth;  //4 combinations of ID
    
    	logic [127:0] lutable [0:depth-1];
	logic flag;
    	integer i;

	assign lutable[0] = {32'h44415644,32'd0,32'h434D4500,32'd0};  		//DAVD,CME
	assign lutable[1] = {48'h514955534849,16'd0,32'h434D4500,32'd0};  	//QIUSHI,CME
	assign lutable[2] = {32'h4D4F4449,32'd0,32'h434D4500,32'd0};  		//MODI,CME
	assign lutable[3] = {40'h4B61746879,24'd0,32'h434D4500,32'd0};  	//Kathy,CME

   	initial begin
        error=1;
        validcam=0;
        addr=8'd0;
	flag=0;
    	end
    

	always_ff@(posedge clk) begin
		if(reset) begin
            	addr<=8'd0;
            	error<=1;
            	validcam<=0;
		flag<=0;
       		end
        
        	else begin
		   	if(senderid==64'd0 && targid==64'd0)begin
				validcam<=0;
		        	error<=1;
		        	addr<=8'd0;
				flag<=0;
			end

			else if (senderid!=64'd0 && targid!=64'd0) begin
				validcam <= 1;
				for(i=0; i<depth; i++) begin
					if({senderid,targid}==lutable[i][127:0] && flag==0)begin
						flag <= 1;
						error <= 0;
						addr <= (8'd1)*i;
					end

				end
			end
		end
	end
			
endmodule
