module FIX_processor
(

input	logic		i_clk,
input	logic		i_rst,
input	logic		i_valid_pkt,
input 	logic[2:0]	i_empty,
input	logic		i_startofpkt,
input	logic		i_endofpkt,
input	logic[63:0]	i_pkt,
input	logic		i_ready_backend,
input	logic		i_valid_pkt_down,
input 	logic[2:0]	i_empty_down,
input	logic		i_startofpkt_down,
input	logic		i_endofpkt_down,
input	logic[63:0]	i_pkt_down,
input	logic		i_ready_backend_down,

output	logic		o_ready_pktz,
output	logic		o_valid_pktz,
output	logic[2:0]	o_empty,
output	logic		o_startofpkt,
output	logic		o_endofpkt,
output	logic[63:0]	o_data,
output	logic		o_ready_pktz_down,
output	logic		o_valid_pktz_down,
output	logic[2:0]	o_empty_down,
output	logic		o_startofpkt_down,
output	logic		o_endofpkt_down,
output	logic[63:0]	o_data_down

);

wire		startofpkt_parser;
wire		endofpkt_parser;
wire		startofpkt_parser_down;
wire		endofpkt_parser_down;

wire            valid_reg; 
wire[7:0]	mesg;          
wire		ready_parser;
wire 		valid_parser;
wire [31:0]	tag_parsertopreproc;
wire [167:0]	value_parsertopreproc;
wire            valid_reg_down; 
wire[7:0]	mesg_down;          
wire		ready_parser_down;
wire 		valid_parser_down;
wire [31:0]	tag_parsertopreproc_down;
wire [167:0]	value_parsertopreproc_down;

wire		ready_preproc;
wire 		valid_preproc;
wire [15:0] 	msgtype_preproc;
wire [31:0] 	seqnum_preproc;
wire [31:0] 	ordqty_preproc;
wire [31:0]     price_preproc;
wire [63:0] 	sendid_preproc;
wire [63:0] 	targid_preproc;
wire [63:0] 	symbol_preproc;
wire [95:0]     sendtime1_preproc;
wire [31:0]     sendtime2_preproc;
wire [95:0] 	transtime1_preproc;
wire [31:0] 	transtime2_preproc;
wire [7:0] 	side_preproc;
wire [7:0] 	ordtype_preproc;
wire		ready_preproc_down;
wire 		valid_preproc_down;
wire [15:0] 	msgtype_preproc_down;
wire [31:0] 	lastqty_preproc_down;
wire [63:0] 	sendid_preproc_down;
wire [63:0] 	targid_preproc_down;
wire [63:0] 	symbol_preproc_down;
wire [7:0] 	side_preproc_down;

wire            valid_idcam;
wire		error_idcam;
wire [7:0] 	addr_idcam;
wire            valid_idcam_down;
wire		error_idcam_down;
wire [7:0] 	addr_idcam_down;

wire            valid_symbolcam;
wire		error_symbolcam;
wire [7:0] 	addr_symbolcam;
wire            valid_symbolcam_down;
wire		error_symbolcam_down;
wire [7:0] 	addr_symbolcam_down;

wire		error_qtysingle;
wire		valid_qtysingle;

wire		error_floatram;
wire		valid_floatram;
wire		valid_floatram_down;

wire		error_pktnum;
wire		valid_pktnum;

wire		error_controller;
wire		valid_controller;
wire		valid_controller_down;

//================================
//  packetizer
//================================
packetizer u_packetizer(
	.clk		(i_clk),
	.reset		(i_rst),
	.readybackend	(i_ready_backend), 
	.readypar	(ready_parser), 
	.validpkt	(i_valid_pkt),
	.startofpkt	(i_startofpkt),
	.endofpkt	(i_endofpkt),
	.validswitch	(valid_controller),
	.empty		(i_empty),
	.drop		(error_controller),
	.pkt		(i_pkt),
	.validtopar	(valid_reg),
	.o_empty	(o_empty),
	.validtobackend	(o_valid_pktz), 
	.readypktz	(o_ready_pktz),
	.startofpacket	(startofpkt_parser),
	.endofpacket	(endofpkt_parser),
	.sop		(o_startofpkt),
	.eop		(o_endofpkt),
	.datatopar	(mesg),
	.data		(o_data)
);
//================================
//  packetizer_down
//================================
packetizer_down u_packetizer_down(
	.clk		(i_clk),
	.reset		(i_rst),
	.readybackend	(i_ready_backend_down), 
	.readypar	(ready_parser_down), 
	.validpkt	(i_valid_pkt_down),
	.startofpkt	(i_startofpkt_down),
	.endofpkt	(i_endofpkt_down),
	.validswitch	(valid_controller_down),
	.empty		(i_empty_down),
	.pkt		(i_pkt_down),
	.validtopar	(valid_reg_down),
	.o_empty	(o_empty_down),
	.validtobackend	(o_valid_pktz_down), 
	.readypktz	(o_ready_pktz_down),
	.startofpacket	(startofpkt_parser_down),
	.endofpacket	(endofpkt_parser_down),
	.sop		(o_startofpkt_down),
	.eop		(o_endofpkt_down),
	.datatopar	(mesg_down),
	.data		(o_data_down)
);

//================================
//  Parser
//================================
parser u_parser(
	.clk		(i_clk),
	.reset		(i_rst),
	.validreg	(valid_reg),
	.mesg		(mesg),
	.readypreproc	(ready_preproc),
	.validcontroller(valid_controller),
	.startofpacket	(startofpkt_parser),
	.endofpacket	(endofpkt_parser),

	.validpar	(valid_parser),
	.tag		(tag_parsertopreproc),
	.value		(value_parsertopreproc),
	.readypar	(ready_parser)

);
//================================
//  Parser_down
//================================
parser_down u_parser_down(
	.clk		(i_clk),
	.reset		(i_rst),
	.validreg	(valid_reg_down),
	.mesg		(mesg_down),
	.readypreproc	(ready_preproc_down),
	.validcontroller(valid_controller_down),
	.startofpacket	(startofpkt_parser_down),
	.endofpacket	(endofpkt_parser_down),

	.validpar	(valid_parser_down),
	.tag		(tag_parsertopreproc_down),
	.value		(value_parsertopreproc_down),
	.readypar	(ready_parser_down)

);



//================================
//  Preprocessor
//================================
preprocessor u_preprocessor(
	.clk		(i_clk),
	.reset		(i_rst),
	.validpar	(valid_parser),
	.tag		(tag_parsertopreproc),
	.value		(value_parsertopreproc),
	
	.validpreproc	(valid_preproc),
	.readypreproc	(ready_preproc),
	.vmsgtype	(msgtype_preproc),
	.vseqnum	(seqnum_preproc),
	.vordqty	(ordqty_preproc),
	.vprice		(price_preproc),
	.vsendid	(sendid_preproc),
	.vtargid	(targid_preproc),
	.vsymbol	(symbol_preproc),
	.vsendtime1	(sendtime1_preproc),
	.vsendtime2	(sendtime2_preproc),
	.vtranstime1	(transtime1_preproc),
	.vtranstime2	(transtime2_preproc),
	.vside		(side_preproc),
	.vordtype	(ordtype_preproc)

);
//================================
//  Preprocessor_down
//================================
preprocessor_down u_preprocessor_down(
	.clk		(i_clk),
	.reset		(i_rst),
	.validpar	(valid_parser_down),
	.tag		(tag_parsertopreproc_down),
	.value		(value_parsertopreproc_down),
	
	.validpreproc	(valid_preproc_down),
	.readypreproc	(ready_preproc_down),
	.vmsgtype	(msgtype_preproc_down),
	.vlastqty	(lastqty_preproc_down),
	.vsendid	(sendid_preproc_down),
	.vtargid	(targid_preproc_down),
	.vsymbol	(symbol_preproc_down),
	.vside		(side_preproc_down)

);

//================================
//  IDcam
//================================
IDcam u_IDcam(
	.clk		(i_clk),
	.reset		(i_rst),
	.senderid	(sendid_preproc),
	.targid		(targid_preproc),

	.validcam	(valid_idcam),
	.error		(error_idcam),
	.addr		(addr_idcam)

);
//================================
//  IDcam_down
//================================
IDcam_down u_IDcam_down(
	.clk		(i_clk),
	.reset		(i_rst),
	.senderid	(sendid_preproc_down),
	.targid		(targid_preproc_down),

	.validcam	(valid_idcam_down),
	.error		(error_idcam_down),
	.addr		(addr_idcam_down)

);

//================================
//  symbolcam
//================================
symbolcam u_symbolcam(
	.clk		(i_clk),
	.reset		(i_rst),
	.symbol		(symbol_preproc),

	.validcam	(valid_symbolcam),
	.error		(error_symbolcam),
	.addr		(addr_symbolcam)

);
//================================
//  symbolcam_down
//================================
symbolcam_down u_symbolcam_down(
	.clk		(i_clk),
	.reset		(i_rst),
	.symbol		(symbol_preproc_down),

	.validcam	(valid_symbolcam_down),
	.error		(error_symbolcam_down),
	.addr		(addr_symbolcam_down)

);

//================================
//  qtysingle
//================================
qtysingle u_qtysingle(
	.clk		(i_clk),
	.reset		(i_rst),
	.msgtype	(msgtype_preproc),
	.idindex	(addr_idcam),
	.symbolindex	(addr_symbolcam),
	.iderror	(error_idcam),
	.symbolerror	(error_symbolcam),
	.idvalid	(valid_idcam),
	.symbolvalid	(valid_symbolcam),
	.side		(side_preproc),
	.qty		(ordqty_preproc),
	.flag		(error_qtysingle),
	.valid		(valid_qtysingle)

);

//================================
//  floatram
//================================
floatram u_floatram(
	.clk		(i_clk),
	.reset		(i_rst),
	.msgtype	(msgtype_preproc),
	.idindex	(addr_idcam),
	.symbolindex	(addr_symbolcam),
	.iderror	(error_idcam),
	.symbolerror	(error_symbolcam),
	.idvalid	(valid_idcam),
	.symbolvalid	(valid_symbolcam),
	.side		(side_preproc),
	.qty		(ordqty_preproc),
	.msgtypeD	(msgtype_preproc_down),
	.idindexD	(addr_idcam_down),
	.symbolindexD	(addr_symbolcam_down),
	.iderrorD	(error_idcam_down),
	.symbolerrorD	(error_symbolcam_down),
	.idvalidD	(valid_idcam_down),
	.symbolvalidD	(valid_symbolcam_down),
	.sideD		(side_preproc_down),
	.qtyD		(lastqty_preproc_down),

	.flag		(error_floatram),
	.valid		(valid_floatram),
	.validD		(valid_floatram_down)

);

//================================
//  pktnum
//================================
pktnum u_pktnum(
	.clk		(i_clk),
	.reset		(i_rst),
	.msgtype	(msgtype_preproc),
	.flag		(error_pktnum),
	.valid		(valid_pktnum)
);

//================================
//  controller
//================================
controller u_controller(
	.clk		(i_clk),
	.reset		(i_rst),
	.validID	(valid_idcam),
	.validSymbol	(valid_symbolcam),
	.validQty	(valid_qtysingle),
	.validQty2	(valid_floatram),
	.errID		(error_idcam),
	.errSymbol	(error_symbolcam),
	.errQty		(!error_qtysingle),
	.errQty2	(!error_floatram),
	.validnum	(valid_pktnum),
	.errnum		(!error_pktnum),
	.msgtype	(msgtype_preproc),
	.valid		(valid_controller),
	.drop		(error_controller)
);
//================================
//  controller_down
//================================
controller_down u_controller_down(
	.clk		(i_clk),
	.reset		(i_rst),
	.validD		(valid_floatram_down),
	.msgtype	(msgtype_preproc_down),
	.valid		(valid_controller_down)
);

endmodule
