open Ast

module VarMap = Map.Make(struct
    type t = string
    let compare x y = Pervasives.compare x y
end)

type xexpr =
| Xint_Lit of string
| Xbin_Lit of string
| Xhex_Lit of string
| Xbit_Binary_Lit of string * int
| Xbit_Hex_Lit of string * int
| Xstring_Lit of string
| Xvector_Lit of xexpr list
| Xid of string * c_type
| Xidd of string * xexpr list * c_type
| Xvec_Dimension of int
| Xlet of xlet_arg list * xexpr
| Xlambda of id_with_type list * xexpr * int
| Xmake_Vector of c_type * xexpr
| Xfuncall of string * xexpr list * c_type * xexpr

and xlet_arg = id_with_type * xexpr

type xdefvar = {
    xvname : id_with_type; 
    xvbody : xexpr;
}

type xdefun = {
    xfname : id_with_type;
    xfargu : id_with_type list;
    xfbody : xexpr;
}

type xclip =
| Xexpr of xexpr * bool
| Xdefvar of xdefvar
| Xdefun of xdefun

type xprogram = xclip list