#include <iostream>
#include <cstdlib>
#include <gmp.h>
#include <cstdarg>
#include <vector>
#include <bitset>
#include "builtin.cc"
using namespace std;



vector< bitset<40> > map_1(bitset<40> (*f)(vector<bitset<8> >), vector< vector< bitset<8> > > b) {
    vector< bitset<40> > result;
    result.resize(b.size());
    for (int i = 0; i < b.size(); i++) {
        result[i] = f(b[i]);
    }
    return result;
}

bitset<40> merge_1(vector< bitset<8> > vb) {
    string s = "";
    for (int i = 0; i < vb.size(); i++) {
        s = s + vb[i].to_string();
    }
    return bitset <40>(s);
}

int main(int argc, char *argv[]){
    vector< vector< bitset<8> > > block;
    block.resize(5);
    cout << "block:\n";
    for (int i = 0; i < 5; i++)
        block[i].resize(5);
    for (int i = 0; i < 5; i++)
        for (int j = 0; j < 5; j++)
            block[i][j] = 5*i+j;
    for (int i = 0; i < 5; i++) {
        for (int j = 0; j < 5; j++)
            cout << block[i][j] << ", ";
        cout << "\n";
    }

    cout << "\nAfter map the merge function to block:\n";

    bitset<40> (*f)(vector< bitset<8> > vb) = &merge_1;
    vector< bitset<40> > out = map_1(f, block);
    for (int i = 0; i < out.size(); i++)
        cout << out[i] << endl;

    return 0;
}
