type fun_case =
| Indef
| Fix
| Len_Flex

type c_type =
| Wild_Card of int
| Int
| Bits of int
| String
| Vector of c_type * int list
| Fun of fun_case * c_type * c_type list
| Special of string

type id_with_type = {
    id: string;
    t: c_type;
}

type expr =
| Int_Lit of string
| Bin_Lit of string
| Hex_Lit of string
| Bit_Binary_Lit of string
| Bit_Hex_Lit of string
| String_Lit of string
| Vector_Lit of expr list
| Id of string
| Idd of string * expr list
| Vec_Dimension of int
| Let of let_arg list * expr
| Lambda of id_with_type list * expr
| Make_Vector of c_type * expr
| Funcall of expr * expr list

and let_arg = id_with_type * expr

type defvar = {
    vname : id_with_type; 
    vbody : expr;
}

type defun = {
    fname : id_with_type;
    fargu : id_with_type list;
    fbody : expr;
}

type clip =
| Expr of expr * bool
| Defvar of defvar
| Defun of defun

type program = clip list