#include <stdio.h>
#include <stdlib.h>
#include "SDL/SDL.h"

#define SOUTHWEST 0
#define WEST 1
#define NORTHWEST 2
#define SOUTH 3
#define CENTER 4
#define NORTH 5
#define SOUTHEAST 6
#define EAST 7
#define NORTHEAST 8

#define MAX_X 200
#define MAX_Y 200
#define STEP_TIME 50
#define CELL_SIZE 3

typedef int direction;
typedef char actor_type; 

#define LIVE_ACTORTYPE 0
#define DEAD_ACTORTYPE 1


typedef struct actor{
		union actor_types{struct Live_actortype{
     } Live_actor;
struct Dead_actortype{
     } Dead_actor;

;
		} actors;
		char type;
	} ACTOR;

void init(char type, ACTOR* actor){
	(*actor).type = type;
	switch(type){		case LIVE_ACTORTYPE:
			break;
		case DEAD_ACTORTYPE:
			break;
	}
}


void grid_size(int w, int h){
	
}

void set_actor(int x, int y){
	
}

void set_chronon(int millis){
	
}

void set_grid_pattern(int pattern_type, char atype_1, char atype_2){
	switch(pattern_type){
		//CHECKERBOARD
		case 0:

			break;
		//ROWS
		case 1:
			break;
		//COLUMNS
		case 2:
			break;
		//DIAGONAL
		case 3:
			break;
		//FILL
		case 4:
			break;
	}
}

void set_grid_random(){
	
}

void read_grid(char* file_path){

}

char cellat(int direction, ACTOR** grid, int xpos, int ypos){
	int xstart, ystart;
	if(xpos <= 0){
		xstart = MAX_X - 1;
	}
	else{
		xstart = xpos - 1;
	}
	if(ypos <= 0){
		ystart = MAX_Y - 1;
	}
	else{
		ystart = ypos - 1;
	}
	switch(direction){
		case SOUTHWEST:
			return grid[xstart%MAX_X][(ystart%MAX_Y)].type;
		case WEST:
			return grid[xstart%MAX_X][((ystart+1)%MAX_Y)].type;
		case NORTHWEST:
			return grid[xstart%MAX_X][((ystart+2)%MAX_Y)].type;
		case SOUTH:
			return grid[(xstart+1)%MAX_X][(ystart%MAX_Y)].type;
		case CENTER:
			return grid[(xstart+1)%MAX_X][((ystart+1)%MAX_Y)].type;
		case NORTH:
			return grid[(xstart+1)%MAX_X][((ystart+2)%MAX_Y)].type;
		case SOUTHEAST:
			return grid[(xstart+2)%MAX_X][(ystart%MAX_Y)].type;
		case EAST:
			return grid[(xstart+2)%MAX_X][((ystart+1)%MAX_Y)].type;
		case NORTHEAST:
			return grid[(xstart+2)%MAX_X][((ystart+2)%MAX_Y)].type;
		default:
			return grid[(xstart+1)%MAX_X][((ystart+1)%MAX_Y)].type;
	}
}

void assign_type(int direction, char type, ACTOR** grid, int xpos, int ypos){
	int xstart, ystart;
	if(xpos <= 0){
		xstart = MAX_X - 1;
	}
	else{
		xstart = xpos - 1;
	}
	if(ypos <= 0){
		ystart = MAX_Y - 1;
	}
	else{
		ystart = ypos - 1;
	}
	switch(direction){
		case SOUTHWEST:
			init(type, &(grid[xstart%MAX_X][(ystart%MAX_Y)]));
			break;
		case WEST:
			init(type, &(grid[xstart%MAX_X][((ystart+1)%MAX_Y)]));
			break;
		case NORTHWEST:
			init(type, &(grid[xstart%MAX_X][((ystart+2)%MAX_Y)]));
			break;
		case SOUTH:
			init(type, &(grid[(xstart+1)%MAX_X][(ystart%MAX_Y)]));
			break;
		case CENTER:
			init(type, &(grid[(xstart+1)%MAX_X][((ystart+1)%MAX_Y)]));
			break;
		case NORTH:
			init(type, &(grid[(xstart+1)%MAX_X][((ystart+2)%MAX_Y)]));
			break;
		case SOUTHEAST:
			init(type, &(grid[(xstart+2)%MAX_X][(ystart%MAX_Y)]));
			break;
		case EAST:
			init(type, &(grid[(xstart+2)%MAX_X][((ystart+1)%MAX_Y)]));
			break;
		case NORTHEAST:
			init(type, &(grid[(xstart+2)%MAX_X][((ystart+2)%MAX_Y)]));
			break;
		default:
			init(type, &(grid[(xstart+1)%MAX_X][((ystart+1)%MAX_Y)]));
	}
}

void move(int direction, char replace_type, ACTOR** read_grid, ACTOR** write_grid, int xpos, int ypos){

	char og_type = read_grid[xpos][ypos].type;


	//assign_type(direction, og_type, grid, xpos, ypos);

	int xstart, ystart;

	if(xpos <= 0){
		xstart = MAX_X - 1;
	}
	else{
		xstart = xpos - 1;
	}
	if(ypos <= 0){
		ystart = MAX_Y - 1;
	}
	else{
		ystart = ypos - 1;
	}

	switch(direction){
		case SOUTHWEST:
			write_grid[xstart%MAX_X][(ystart%MAX_Y)] = write_grid[xpos][ypos];
			break;
		case WEST:
			write_grid[xstart%MAX_X][((ystart+1)%MAX_Y)] = write_grid[xpos][ypos];
			break;
		case NORTHWEST:
			write_grid[xstart%MAX_X][((ystart+2)%MAX_Y)] = write_grid[xpos][ypos];
			break;
		case SOUTH:
			write_grid[(xstart+1)%MAX_X][(ystart%MAX_Y)] = write_grid[xpos][ypos];
			break;
		case CENTER:
			write_grid[(xstart+1)%MAX_X][((ystart+1)%MAX_Y)] = write_grid[xpos][ypos];
			break;
		case NORTH:
			write_grid[(xstart+1)%MAX_X][((ystart+2)%MAX_Y)] = write_grid[xpos][ypos];
			break;
		case SOUTHEAST:
			write_grid[(xstart+2)%MAX_X][(ystart%MAX_Y)] = write_grid[xpos][ypos];
			break;
		case EAST:
			write_grid[(xstart+2)%MAX_X][((ystart+1)%MAX_Y)] = write_grid[xpos][ypos];
			break;
		case NORTHEAST:
			write_grid[(xstart+2)%MAX_X][((ystart+2)%MAX_Y)] = write_grid[xpos][ypos];
			break;
		default:
			write_grid[(xstart+1)%MAX_X][((ystart+1)%MAX_Y)] = write_grid[xpos][ypos];
	}
	init(replace_type, &(write_grid[xpos][ypos]));

}

int neighborhood(char type, ACTOR** grid, int xpos, int ypos){
	int neighbor_count = 0;

	int i,j;
	int xstart, ystart;
	int curr_x, curr_y;
	int current_direction = 0;

	if(xpos <= 0){
		xstart = MAX_X - 1;
	}
	else{
		xstart = xpos - 1;
	}
	if(ypos <= 0){
		ystart = MAX_Y - 1;
	}
	else{
		ystart = ypos - 1;
	}

	for(i = 0; i < 3; i++){
		for(j = 0; j < 3; j++){
			curr_x = (xstart+i)%MAX_X;
			curr_y = (ystart+j)%MAX_Y;
			if(current_direction == 4){
				continue;
			}
			if(grid[curr_x][curr_y].type == type){
				neighbor_count++;
			}
		}
	}

	return neighbor_count;
}

int randomof(char type, ACTOR** grid, int xpos, int ypos){
	int neighborhood[8];
	int neighbor_count = 0;
	int current_direction = 0;

	int i,j;
	int xstart, ystart;
	int curr_x, curr_y;
	if(xpos <= 0){
		xstart = MAX_X - 1;
	}
	else{
		xstart = xpos - 1;
	}
	if(ypos <= 0){
		ystart = MAX_Y - 1;
	}
	else{
		ystart = ypos - 1;
	}

	for(i = 0; i < 3; i++){
		for(j = 0; j < 3; j++){
			curr_x = (xstart+i)%MAX_X;
			curr_y = (ystart+j)%MAX_Y;
			if(current_direction == 4){
				current_direction++;
				continue;
			}
			if(grid[curr_x][curr_y].type == type){
				neighborhood[neighbor_count] = current_direction;
				neighbor_count++;
			}
			current_direction++;
		}
	}

	if(neighbor_count > 0){
		return neighborhood[rand() % neighbor_count];
	}
	else{
		return -1;
	}

}


void update(ACTOR** read_grid, ACTOR** write_grid, int width, int height){
	int i,j;
	char new_type;
	for(i = 0; i < width; i++){
		for(j = 0; j < height; j++){
			write_grid[i][j] = read_grid[i][j];
		}
	}
	for(i = 0; i < width; i++){
		for(j = 0; j < height; j++){
			switch(read_grid[i][j].type){				case LIVE_ACTORTYPE:
					if(neighborhood(LIVE_ACTORTYPE, read_grid, i, j) > 3){
						assign_type(CENTER, DEAD_ACTORTYPE, write_grid, i, j);
					}
					else if(neighborhood(LIVE_ACTORTYPE, read_grid, i, j) == 2 || neighborhood(LIVE_ACTORTYPE, read_grid, i, j) == 3){
						assign_type(CENTER, LIVE_ACTORTYPE, write_grid, i, j);
					}
					else if(neighborhood(LIVE_ACTORTYPE, read_grid, i, j) < 2){
						assign_type(CENTER, DEAD_ACTORTYPE, write_grid, i, j);
					}
					else {
					}
					break;
				case DEAD_ACTORTYPE:
					if(neighborhood(LIVE_ACTORTYPE, read_grid, i, j) == 3){
						assign_type(CENTER, LIVE_ACTORTYPE, write_grid, i, j);
					}
					else {
					}
					break;

			}
		}
	}
}

void colorblock(SDL_Rect rect, SDL_Rect offset, SDL_Surface* screen, SDL_Surface* surface, int xpos, int ypos, int width, int height, Uint32 color){
	
    rect.x = 0;
    rect.y = 0;
    rect.w = width;
    rect.h = height;

    offset.x = xpos;
    offset.y = ypos;
    offset.w = width;
    offset.h = height;

    SDL_FillRect(surface, &rect, color);
    SDL_BlitSurface(surface, NULL, screen, &offset);
}
void setup() {
int x = 2;
int y = 3;
x == y;
grid_size(200, 200);
set_chronon(200);
set_grid_random();
}


int main(int argc, char* args[]){
	ACTOR** grid1 = malloc(sizeof(ACTOR*) * MAX_X);
	ACTOR** grid2 = malloc(sizeof(ACTOR*) * MAX_X);

	int grid_switch = 1;

	 //Setup sdl screen stuff
    SDL_Surface* screen = NULL;
    SDL_Surface* surface = NULL;
    SDL_Rect rect;
    SDL_Rect offset;
    //Start SDL
    SDL_Init( SDL_INIT_EVERYTHING );
    surface = SDL_CreateRGBSurface(0, CELL_SIZE, CELL_SIZE, 32, 0, 0, 0, 0);
    
    screen = SDL_SetVideoMode( CELL_SIZE * MAX_X, CELL_SIZE * MAX_Y, 32, SDL_SWSURFACE );
    SDL_WM_SetCaption("test_case2", NULL);  

	int i,j,k;
	for(i = 0; i < MAX_X; i++){
		grid1[i] = malloc(sizeof(ACTOR) * MAX_Y);
		grid2[i] = malloc(sizeof(ACTOR) * MAX_Y);
		for(j = 0; j < MAX_Y; j++){
			char type;
			switch(rand() % 2){
				case 0:
					type = 0;
					break;
				case 1:
					type = 1;
					break;
				default:
					type = 2;
			}
			init(type, &(grid1[i][j]));
			init(type, &(grid2[i][j]));
		}
	}

    ACTOR** current_grid;
    Uint32 color;
    SDL_Event event;
    int quit = 0;
    int pause = 0;
    while(!quit){
    	if(!pause){
	    	if(grid_switch){
	    		current_grid = grid1;
			}
			else{
				current_grid = grid2;
			}
			for(i = 0; i < MAX_X; i++){
				for(j = 0; j < MAX_Y; j++){
					switch(current_grid[i][j].type){
					case LIVE_ACTORTYPE:
							color = SDL_MapRGB(screen->format, 133,228,56);
							break;
					case DEAD_ACTORTYPE:
							color = SDL_MapRGB(screen->format, 88,67,11);
							break;
}
					colorblock(rect, offset, screen, surface, CELL_SIZE * i, CELL_SIZE * j, CELL_SIZE, CELL_SIZE, color);
				}
			}
			if(grid_switch){
				update(grid1, grid2, MAX_X, MAX_Y);
				grid_switch = 0;
			}
			else{
				update(grid2, grid1, MAX_X, MAX_Y);
				grid_switch = 1;
			}
			if( SDL_Flip( screen ) == -1 ){
	            return 1;    
	        }
	    }
        while(SDL_PollEvent(&event)){
        	switch(event.type){
	        	case SDL_KEYDOWN:
	        		pause = !pause;
	        		break;
	        	case SDL_QUIT:
	        		quit = 1;
	        		break;
        	}
        }
    	SDL_Delay( STEP_TIME );
	}

    
    for(i = 0; i < MAX_X; i++){
    	free(grid1[i]);
    	free(grid2[i]);
    }
    free(grid1);
    free(grid2);
    //Free the loaded image
    SDL_FreeSurface(surface);
    SDL_FreeSurface(screen);
    //Quit SDL
    SDL_Quit();
    
	return 0;
}