open Ast
open Str
open Cal_std

module StringMap = Map.Make(String);;

let rec concat_list l =
  match l with
    [] -> ""
  | hd :: tl -> hd ^ (concat_list tl)

let add_actortype_initdec fdecl = 
	let vdecls = fdecl.alocals in
	let aname = fdecl.aname in
	let string_of_vinit vd = match vd with 
		VDecl(dt, name, _) -> "    " ^ Ast.string_of_dt dt ^ " " ^ name ^ ";\n" in
			"struct " ^ aname ^ "_actortype{\n" ^  concat_list (List.map string_of_vinit vdecls) ^ "     } " ^ aname ^ "_actor;\n" 


let add_colors = function ActorType(fdecl) -> 
		(let aname = fdecl.aname in
		let red = Random.int 256 in
		let green = Random.int 256 in
		let blue = Random.int 256 in
		"					case " ^ String.uppercase aname ^ "_ACTORTYPE:
							color = SDL_MapRGB(screen->format, "^ string_of_int red ^","^ string_of_int green ^"," ^ string_of_int blue ^");
							break;\n") 
		| _ -> ""

let rec replace_actortypes block at_list = match at_list with
	[] -> block
	| hd :: tl -> 
		(match hd with ActorType(hd) -> replace_actortypes (global_replace (Str.regexp hd.aname) ((String.uppercase hd.aname) ^ "_ACTORTYPE") block) tl | _ -> block)

let add_actortype_initinit fdecl func_list =
	let vdecls = fdecl.alocals in
	let aname = fdecl.aname in
	let string_of_initinit vd = match vd with
		VDecl(_, name, value) -> "			(*actor).actors." ^ aname ^ "_actor." ^ name ^ " = " ^ (replace_actortypes value func_list) ^ ";\n" in
			"		case " ^ String.uppercase aname ^ "_ACTORTYPE:\n" ^ concat_list (List.map string_of_initinit vdecls) ^ "			break;\n"

let add_actortype_deftype fdecl type_number =
	let aname = fdecl.aname in
	"#define " ^ String.uppercase aname ^ "_ACTORTYPE " ^ string_of_int type_number ^ "\n"

let add_actortype_updateblock fdecl func_list =
	let aname = fdecl.aname in
	let rules = fdecl.arules in
	let default = fdecl.adefault in
	let locals = fdecl.alocals in
	let concat_tabs s = "						" ^ s in
	let concat_tabs2 s = "					" ^ s in
	let string_of_rule rl = match rl with
		Rule(condition, statement_list) -> "if(" ^ string_of_expr_at condition ^ "){\n" ^ concat_list (List.map concat_tabs (List.map Ast.string_of_stmt_at statement_list)) ^ "					}\n					else " in
	let string_of_default df rule_count = match rule_count with
		0 ->  concat_list (List.map  concat_tabs2 (List.map Ast.string_of_stmt_at df)) ^ "\n"
		|_  -> "{\n" ^ concat_list (List.map  concat_tabs (List.map Ast.string_of_stmt_at df)) ^ "					}\n" in
	let add_prefix_to_var s_block var = match var with
		VDecl(_, name, _) -> global_replace (Str.regexp "!addwritegrid!read_grid") "write_grid" (global_replace (Str.regexp name) ("read_grid[i][j].actors."^aname^"_actor."^name) s_block) in
	let rec add_prefix_to_vars stmt_block vars = match vars with
		[] -> stmt_block
		| hd :: tl -> add_prefix_to_vars (add_prefix_to_var stmt_block hd) tl in
	add_prefix_to_vars (replace_actortypes("				case " ^ String.uppercase aname ^ "_ACTORTYPE:\n					" ^ concat_list (List.map string_of_rule rules) ^ string_of_default default (List.length rules) ^ "					break;\n") func_list) locals
		

let get_actortype_initdecs = function ActorType(fdecl) -> add_actortype_initdec fdecl | _ -> ""

let rec get_actortype_initinits functions functions_for_count =
	let get_actortype_initinits_helper func func_list = match func with 
		ActorType(fdecl) -> (add_actortype_initinit fdecl func_list)| _ -> "" in
	match functions_for_count with
		[] -> ""
		| hd :: tl -> ((get_actortype_initinits_helper hd functions) ^ (get_actortype_initinits functions tl))

let rec get_actortype_count funcs count = match funcs with
	[] -> count
	| hd :: tl -> (match hd with
		ActorType(hd) -> get_actortype_count tl (count + 1)
		|_ -> get_actortype_count tl count)

let get_actortype_deftypes fdecl type_number = match fdecl with ActorType(fdecl) -> add_actortype_deftype fdecl type_number | _ -> ""

let rec get_actortype_deftypes_rec functions type_number =
	match functions with
	  [] -> ""
	| hd :: tl -> get_actortype_deftypes hd type_number ^ get_actortype_deftypes_rec tl (type_number + 1)

let rec get_actortype_updateblocks functions functions_for_count= 
	let get_actortype_updateblocks_helper func func_list = match func with 
		ActorType(func) -> (add_actortype_updateblock func func_list) | _ -> ""  in
	match functions_for_count with
		[] -> ""
		| hd :: tl ->((get_actortype_updateblocks_helper hd functions) ^ (get_actortype_updateblocks functions tl))

let rec get_setup_function functions func_count = match func_count with
	[] -> ""
	| hd :: tl -> (match hd with
		CFunc(hd) -> if (String.compare (string_of_dt hd.dtype) "void") == 0 && (List.length hd.formals) <= 0 && (String.compare hd.fname "setup") == 0 then replace_actortypes (concat_list (List.map Ast.string_of_stmt_setup hd.body)) functions else get_setup_function functions tl
		|_ -> get_setup_function functions tl)
	
let translate functions program_name =
	let ochannel = ignore(Random.self_init ()); open_out (program_name ^ ".c") in
		let sorted_functions = List.rev (List.sort compare functions) in
		let at_count = get_actortype_count functions 0 in
		let actor_initdecs = concat_list (List.map get_actortype_initdecs sorted_functions) in
		let actor_initinits = get_actortype_initinits sorted_functions sorted_functions in
		let actor_typedefs = get_actortype_deftypes_rec sorted_functions 0 in
		let actor_updateblocks =  get_actortype_updateblocks sorted_functions sorted_functions in
		let actor_colors = concat_list (List.map add_colors sorted_functions) in
		let normal_funcs = concat_list (List.map string_of_fdecl sorted_functions) in
		let setup_func = get_setup_function sorted_functions sorted_functions in
		let program_string = 
			global_replace (Str.regexp("PROGRAM_NAME")) ("\""^program_name^"\"")
			(Cal_std.std_template0 ^ string_of_int at_count ^ Cal_std.std_template1 ^ actor_typedefs ^ Cal_std.std_template2 ^
			actor_initdecs ^ Cal_std.std_template3 ^ actor_initinits ^
			Cal_std.std_template4 ^ actor_updateblocks ^ Cal_std.std_template5 ^
			normal_funcs ^ Cal_std.std_template6 ^ setup_func ^ Cal_std.std_template7 ^ actor_colors^ 
			Cal_std.std_template8)

		in
			let exit_code = ignore(Printf.fprintf ochannel "%s" program_string);
				close_out ochannel;
				Sys.command (Printf.sprintf "gcc -o %s.out %s.c -lmingw32 -lSDLmain -lSDL
" program_name program_name) in
					match exit_code with
						0 -> "\nCompilation was a success.\n"
						|_ -> "\nCompilation failed.\n"