let std_template0 = "#include <stdio.h>
#include <stdlib.h>
#include <time.h> 
#include \"SDL/SDL.h\"

#define SOUTHWEST 0
#define WEST 1
#define NORTHWEST 2
#define SOUTH 3
#define CENTER 4
#define NORTH 5
#define SOUTHEAST 6
#define EAST 7
#define NORTHEAST 8

#define TOTAL_TYPES "

let std_template1 = "

typedef int direction;
typedef char actor_type; 

"

let std_template2 = "

typedef struct actor{
		union actor_types{"

let std_template3 = "
;
		} actors;
		char type;
	} ACTOR;

void init(char type, ACTOR* actor){
	(*actor).type = type;
	switch(type){"

let std_template4 = "	}
}



void set_grid_random(ACTOR** grid1, ACTOR** grid2, int width, int height){
	int i,j;
	for(i = 0; i < width; i++){
		for(j = 0; j < height; j++){
			init(rand() % TOTAL_TYPES, &grid1[i][j]);
			grid2[i][j] = grid1[i][j];
		}
	}
}

void grid_size(int w, int h, ACTOR*** grid1, ACTOR*** grid2, int *width, int *height){
	int i;
	for(i = 0; i < *width; i++){
		free((*grid1)[i]);
		free((*grid2)[i]);
	}
	free(*grid1);
	free(*grid2);
	*width = w;
	*height = h;
	*grid1 = malloc(w * sizeof(ACTOR*));
	*grid2 = malloc(w * sizeof(ACTOR*));
	for(i = 0; i < w; i++){
		(*grid1)[i] = malloc(h * sizeof(ACTOR));
		(*grid2)[i] = malloc(h * sizeof(ACTOR));
	}
	set_grid_random(*grid1, *grid2, *width, *height);
}

void set_actor(int x, int y, char type, ACTOR** grid1, ACTOR** grid2){
	init(type, &grid1[x][y]);
	init(type, &grid2[x][y]);
}

void set_chronon(int millis, int *time){
	*time = millis;
}

void set_cell_size(int size, int *cellsize){
	*cellsize = size;
}

void set_grid_pattern(int pattern_type, char atype_1, char atype_2, int w_s, int h_s, int startx, int starty, ACTOR** grid1, ACTOR** grid2){
	int i,j;
	int width = startx + w_s;
	int height = starty + h_s;
	switch(pattern_type){
		//CHECKERBOARD
		case 0:
			printf(\"inloop\\n\");
			for(i = startx; i < width; i+=2){
				for(j = starty; j < height; j+=2){
					init(atype_1, &grid1[i][j]);
					grid2[i][j] = grid1[i][j];
				}
			}
			for(i = startx; i < width; i+=2){
				for(j = starty + 1; j < height; j+=2){
					init(atype_2, &grid1[i][j]);
					grid2[i][j] = grid1[i][j];
				}
			}
			for(i = startx + 1; i < width; i+=2){
				for(j = starty + 1; j < height; j+=2){
					init(atype_1, &grid1[i][j]);
					grid2[i][j] = grid1[i][j];
				}
			}
			for(i = startx + 1; i < width; i+=2){
				for(j = starty; j < height; j+=2){
					init(atype_2, &grid1[i][j]);
					grid2[i][j] = grid1[i][j];
				}
			}
			break;
		//ROWS
		case 1:
			for(i = startx; i < width; i++){
				for(j = starty; j < height; j+=2){
					init(atype_1, &grid1[i][j]);
					grid2[i][j] = grid1[i][j];
				}
			}
			for(i = startx; i < width; i++){
				for(j = starty+1; j < height; j+=2){
					init(atype_2, &grid1[i][j]);
					grid2[i][j] = grid1[i][j];
				}
			}
			break;
		//COLUMNS
		case 2:
			for(i = startx; i < width; i+=2){
				for(j = starty; j < height; j++){
					init(atype_1, &grid1[i][j]);
					grid2[i][j] = grid1[i][j];
				}
			}
			for(i = starty+1; i < width; i+=2){
				for(j = starty; j < height; j++){
					init(atype_2, &grid1[i][j]);
					grid2[i][j] = grid1[i][j];
				}
			}
			break;
		//FILL
		case 3:
			for(i = startx; i < width; i++){
				for(j = starty; j < height; j++){
					init(atype_1, &grid1[i][j]);
					grid2[i][j] = grid1[i][j];
				}
			}
			break;
	}
}

void read_grid(char* file_path, ACTOR** grid1, ACTOR** grid2, int width, int height){

}

char cellat(int direction, ACTOR** grid, int xpos, int ypos, int width, int height){
	int xstart, ystart;
	if(xpos <= 0){
		xstart = width - 1;
	}
	else{
		xstart = xpos - 1;
	}
	if(ypos <= 0){
		ystart = height - 1;
	}
	else{
		ystart = ypos - 1;
	}
	switch(direction){
		case SOUTHWEST:
			return grid[xstart%width][(ystart%height)].type;
		case WEST:
			return grid[xstart%width][((ystart+1)%height)].type;
		case NORTHWEST:
			return grid[xstart%width][((ystart+2)%height)].type;
		case SOUTH:
			return grid[(xstart+1)%width][(ystart%height)].type;
		case CENTER:
			return grid[(xstart+1)%width][((ystart+1)%height)].type;
		case NORTH:
			return grid[(xstart+1)%width][((ystart+2)%height)].type;
		case SOUTHEAST:
			return grid[(xstart+2)%width][(ystart%height)].type;
		case EAST:
			return grid[(xstart+2)%width][((ystart+1)%height)].type;
		case NORTHEAST:
			return grid[(xstart+2)%width][((ystart+2)%height)].type;
		default:
			return grid[(xstart+1)%width][((ystart+1)%height)].type;
	}
}

void assign_type(int direction, char type, ACTOR** grid, int xpos, int ypos, int width, int height){
	int xstart, ystart;
	if(xpos <= 0){
		xstart = width - 1;
	}
	else{
		xstart = xpos - 1;
	}
	if(ypos <= 0){
		ystart = height - 1;
	}
	else{
		ystart = ypos - 1;
	}
	switch(direction){
		case SOUTHWEST:
			init(type, &(grid[xstart%width][(ystart%height)]));
			break;
		case WEST:
			init(type, &(grid[xstart%width][((ystart+1)%height)]));
			break;
		case NORTHWEST:
			init(type, &(grid[xstart%width][((ystart+2)%height)]));
			break;
		case SOUTH:
			init(type, &(grid[(xstart+1)%width][(ystart%height)]));
			break;
		case CENTER:
			init(type, &(grid[(xstart+1)%width][((ystart+1)%height)]));
			break;
		case NORTH:
			init(type, &(grid[(xstart+1)%width][((ystart+2)%height)]));
			break;
		case SOUTHEAST:
			init(type, &(grid[(xstart+2)%width][(ystart%height)]));
			break;
		case EAST:
			init(type, &(grid[(xstart+2)%width][((ystart+1)%height)]));
			break;
		case NORTHEAST:
			init(type, &(grid[(xstart+2)%width][((ystart+2)%height)]));
			break;
		default:
			init(type, &(grid[(xstart+1)%width][((ystart+1)%height)]));
	}
}

void move(int direction, char replace_type, ACTOR** read_grid, ACTOR** write_grid, int xpos, int ypos, int width, int height){

	char og_type = read_grid[xpos][ypos].type;


	//assign_type(direction, og_type, grid, xpos, ypos);

	int xstart, ystart;

	if(xpos <= 0){
		xstart = width - 1;
	}
	else{
		xstart = xpos - 1;
	}
	if(ypos <= 0){
		ystart = height - 1;
	}
	else{
		ystart = ypos - 1;
	}

	switch(direction){
		case SOUTHWEST:
			write_grid[xstart%width][(ystart%height)] = write_grid[xpos][ypos];
			break;
		case WEST:
			write_grid[xstart%width][((ystart+1)%height)] = write_grid[xpos][ypos];
			break;
		case NORTHWEST:
			write_grid[xstart%width][((ystart+2)%height)] = write_grid[xpos][ypos];
			break;
		case SOUTH:
			write_grid[(xstart+1)%width][(ystart%height)] = write_grid[xpos][ypos];
			break;
		case CENTER:
			write_grid[(xstart+1)%width][((ystart+1)%height)] = write_grid[xpos][ypos];
			break;
		case NORTH:
			write_grid[(xstart+1)%width][((ystart+2)%height)] = write_grid[xpos][ypos];
			break;
		case SOUTHEAST:
			write_grid[(xstart+2)%width][(ystart%height)] = write_grid[xpos][ypos];
			break;
		case EAST:
			write_grid[(xstart+2)%width][((ystart+1)%height)] = write_grid[xpos][ypos];
			break;
		case NORTHEAST:
			write_grid[(xstart+2)%width][((ystart+2)%height)] = write_grid[xpos][ypos];
			break;
		default:
			write_grid[(xstart+1)%width][((ystart+1)%height)] = write_grid[xpos][ypos];
	}
	init(replace_type, &(write_grid[xpos][ypos]));

}

int neighborhood(char type, ACTOR** grid, int xpos, int ypos, int width, int height){
	int neighbor_count = 0;

	int i,j;
	int xstart, ystart;
	int curr_x, curr_y;
	int current_direction = 0;

	if(xpos <= 0){
		xstart = width - 1;
	}
	else{
		xstart = xpos - 1;
	}
	if(ypos <= 0){
		ystart = height - 1;
	}
	else{
		ystart = ypos - 1;
	}

	for(i = 0; i < 3; i++){
		for(j = 0; j < 3; j++){
			curr_x = (xstart+i)%width;
			curr_y = (ystart+j)%height;
			if(current_direction == 4){
				continue;
			}
			if(grid[curr_x][curr_y].type == type){
				neighbor_count++;
			}
		}
	}

	return neighbor_count;
}

int randomof(char type, ACTOR** grid, int xpos, int ypos, int width, int height){
	int neighborhood[8];
	int neighbor_count = 0;
	int current_direction = 0;

	int i,j;
	int xstart, ystart;
	int curr_x, curr_y;
	if(xpos <= 0){
		xstart = width - 1;
	}
	else{
		xstart = xpos - 1;
	}
	if(ypos <= 0){
		ystart = height - 1;
	}
	else{
		ystart = ypos - 1;
	}

	for(i = 0; i < 3; i++){
		for(j = 0; j < 3; j++){
			curr_x = (xstart+i)%width;
			curr_y = (ystart+j)%height;
			if(current_direction == 4){
				current_direction++;
				continue;
			}
			if(grid[curr_x][curr_y].type == type){
				neighborhood[neighbor_count] = current_direction;
				neighbor_count++;
			}
			current_direction++;
		}
	}

	if(neighbor_count > 0){
		return neighborhood[rand() % neighbor_count];
	}
	else{
		return -1;
	}

}


void update(ACTOR** read_grid, ACTOR** write_grid, int width, int height){
	int i,j;
	char new_type;
	for(i = 0; i < width; i++){
		for(j = 0; j < height; j++){
			write_grid[i][j] = read_grid[i][j];
		}
	}
	for(i = 0; i < width; i++){
		for(j = 0; j < height; j++){
			switch(read_grid[i][j].type){"

let std_template5 = "
			}
		}
	}
}

void colorblock(SDL_Rect rect, SDL_Rect offset, SDL_Surface* screen, SDL_Surface* surface, int xpos, int ypos, int width, int height, Uint32 color){
	
    rect.x = 0;
    rect.y = 0;
    rect.w = width;
    rect.h = height;

    offset.x = xpos;
    offset.y = ypos;
    offset.w = width;
    offset.h = height;

    SDL_FillRect(surface, &rect, color);
    SDL_BlitSurface(surface, NULL, screen, &offset);
}"

let std_template6 = "

int main(int argc, char* args[]){
	srand(time(NULL));

	int MAX_X = 100;
	int MAX_Y = 100;
	int CELL_SIZE = 4;
	int STEP_TIME = 50;
	int i,j,k;

	ACTOR** grid1 = malloc(sizeof(ACTOR*) * MAX_X);
	ACTOR** grid2 = malloc(sizeof(ACTOR*) * MAX_X);


	for(i = 0; i < MAX_X; i++){
		grid1[i] = malloc(sizeof(ACTOR) * MAX_Y);
		grid2[i] = malloc(sizeof(ACTOR) * MAX_Y);
	}
	set_grid_random(grid1,grid2,MAX_X,MAX_Y);
"
let std_template7 = "
	printf(\"%d,%d\\n\", MAX_X, MAX_Y);
	int grid_switch = 1;

	 //Setup sdl screen stuff
    SDL_Surface* screen = NULL;
    SDL_Surface* surface = NULL;
    SDL_Rect rect;
    SDL_Rect offset;
    //Start SDL
    SDL_Init( SDL_INIT_EVERYTHING );
    surface = SDL_CreateRGBSurface(0, CELL_SIZE, CELL_SIZE, 32, 0, 0, 0, 0);
    
    screen = SDL_SetVideoMode( CELL_SIZE * MAX_X, CELL_SIZE * MAX_Y, 32, SDL_SWSURFACE );
    SDL_WM_SetCaption(PROGRAM_NAME, NULL);  

	

    ACTOR** current_grid;
    Uint32 color;
    SDL_Event event;
    int quit = 0;
    int pause = 0;
    while(!quit){
    	if(!pause){
	    	if(grid_switch){
	    		current_grid = grid1;
			}
			else{
				current_grid = grid2;
			}
			for(i = 0; i < MAX_X; i++){
				for(j = 0; j < MAX_Y; j++){
					switch(current_grid[i][j].type){
"

let std_template8 =				"}
					colorblock(rect, offset, screen, surface, CELL_SIZE * i, CELL_SIZE * j, CELL_SIZE, CELL_SIZE, color);
				}
			}
			if(grid_switch){
				update(grid1, grid2, MAX_X, MAX_Y);
				grid_switch = 0;
			}
			else{
				update(grid2, grid1, MAX_X, MAX_Y);
				grid_switch = 1;
			}
			if( SDL_Flip( screen ) == -1 ){
	            return 1;    
	        }
	    }
        while(SDL_PollEvent(&event)){
        	switch(event.type){
	        	case SDL_KEYDOWN:
	        		pause = !pause;
	        		break;
	        	case SDL_QUIT:
	        		quit = 1;
	        		break;
        	}
        }
    	SDL_Delay( STEP_TIME );
	}

    
    for(i = 0; i < MAX_X; i++){
    	free(grid1[i]);
    	free(grid2[i]);
    }
    free(grid1);
    free(grid2);
    //Free the loaded image
    SDL_FreeSurface(surface);
    SDL_FreeSurface(screen);
    //Quit SDL
    SDL_Quit();
    
	return 0;
}";
