exception NoInputFile

let usage = Printf.sprintf "Usage: cal <filepath>"

			
let get_prog_name source_file_path =
	let split_path = (Str.split (Str.regexp_string "/") source_file_path) in
	let file_name = List.nth split_path ((List.length split_path) - 1) in
	let split_name = (Str.split (Str.regexp_string ".") file_name) in
		List.nth split_name ((List.length split_name) - 2)

let _ =
try
		let file_name =
			if Array.length Sys.argv > 1 then
				get_prog_name Sys.argv.(1)
			else raise NoInputFile in
		let input_chan = open_in Sys.argv.(1) in
		let lexbuf = Lexing.from_channel input_chan in
		let rev_prog = Parser.program Scanner.token lexbuf in
		let program = List.rev rev_prog in
		let semantic_check = Semantic.check_program program in
		let comp_result = if semantic_check = true then
			Compile.translate program file_name
			else raise(Failure("\nInvalid program.\n")) in
		print_string comp_result
with 
	|	NoInputFile -> ignore (Printf.printf "Invalid filepath\n%s" usage)