open Ast
open Printf
open Compile
;;
module StringMap = Map.Make(String);;

(* Obtained from: http://stackoverflow.com/questions/2214970/collecting-the-output-of-an-external-command-using-ocaml *)
let syscall_and_collect_output = fun command -> 
  let chan = Unix.open_process_in command in
  let res = ref ([] : string list) in
  let rec process_otl_aux () =  
    let e = input_line chan in
    res := e::!res;
    process_otl_aux() in
  try process_otl_aux ()
  with End_of_file ->
    let stat = Unix.close_process_in chan
    in (String.concat "\n" (List.rev !res)), stat;
;;


(* TODO delete this method - no longer needed *)
let test_progress_program program_name program_text =
  printf "Test case (%s) START\n" program_name;
  compile_program_from_string program_name program_text;
  printf "Test case (%s) SUCCESS\n" program_name;
;;

let test_progress_program_compare program_name program_text expected_result =
  printf "Test case (%s) START\n" program_name;
  compile_program_from_string program_name program_text;
  let program_output, _ = syscall_and_collect_output ("./" ^ program_name ^ ".out") in
  if program_output = expected_result
  then printf "Test case (%s) SUCCESS\n" program_name
  else
    (printf "Expected program output:\n[[[%s]]]\nbut was:\n[[[%s]]]\n" expected_result program_output;
     raise(Failure("Mismatched expectation and actual output. See previous messages"))
    );
;;

let test_progress_program_expect_exception program_name program_text =
  try
    printf "Test case (%s) START\n" program_name;
    compile_program_from_string program_name program_text;
    raise (Failure ("Expecting to throw an exception in this case for " ^ program_name))
  with CompileException(_) -> printf "Test case (%s) SUCCESS: successfully caught the expected exception!\n" program_name;
;;


let _ =
  printf "Starting Test Suite:\n";

  test_progress_program_expect_exception "testenum-duplicatevar" "
  enum myenum
  	a, b, c, c
  end enum
  function int main()
  return 0
  end function
  ";
  test_progress_program_expect_exception "testenum-duplicatevar2" "
  enum myenum
  	a, b, dupe
  end enum
  enum myenum2
  	dupe, e, f
  end enum
  function int main()
  return 0
  end function
  ";
  test_progress_program_expect_exception "testenum-enum-var-conflict" "
  enum myenum
  	a, b, c, myenum2
  end enum
  enum myenum2
  	d, e, f
  end enum
  function int main()
  return 0
  end function
  ";

  test_progress_program_expect_exception "testMismatchedAssignment" "
  enum myenum
  	a, b, c
  end enum
  function int main()
    myenum e1
  	e1 = 6
  	return 0
  end function
  ";
  
  
  test_progress_program_expect_exception "testBadIfCondition" "
  function int main()
  	if 1 + 2 then
  	end if
  	return 0
  end function
  ";

  test_progress_program_expect_exception "testMismatchedReturnType" "
  function int main()
  	return true
  end function
  ";
  
  test_progress_program_expect_exception "testDupeFuncs" "
  function int main()
  	return 0
  end function
  function int main(int a)
  	return 0
  end function
  ";
  
  test_progress_program_expect_exception "testMissingMain" "
  function int notAMain()
  	return 0
  end function
  ";
  
  test_progress_program_expect_exception "testBadMainWithArgs" "
  function int main(int arg)
  	return 0
  end function
  ";

  
  test_progress_program_expect_exception "testMismatchedFunctionAssignType" "
  function int main()
  	boolean myvar
  	myvar = func2()
  	return 0
  end function
  function int func2()
  	return 1
  end function
  ";
  
  test_progress_program_compare "testBasicFunctionCallAndAssign" "
  function int main()
  	/// testing out comments work
  	int myvar = func2()
  	printLine(\"myvar=\" @ myvar)
  	return 0
  end function
  function int func2()
  	return 1
  end function
  " "myvar=1";

  test_progress_program_compare "testBasicStringConcat" "
  function int main()
  	printLine(\"abc\" @ 123)
  	string mystring
  	mystring = \"abc\"
  	printLine(mystring)
  	mystring = \"abc\" @ \"do re mi\"
  	printLine(mystring)
  	printLine(\"abc\" @ \"do re mi\")
  	mystring = \"abc\" @ 123
  	printLine(mystring)
  	return 0
  end function
  " "abc123
abc
abcdo re mi
abcdo re mi
abc123";
  
  test_progress_program_expect_exception "testBadConcatWrongTypes1" "
  function int main()
    boolean me = true
  	printLine(me @ 123)
  end function
  ";

  test_progress_program_expect_exception "testBadConcatWrongTypes2" "
  function int main()
  	printLine(123 @ 123)
  end function
  ";
    
  test_progress_program_expect_exception "testBadFunctionCallArgsMissing1" "
  function int main()
  	me()
  end function
  
  function int me(int a)
  	return 0
  end function
  ";
  
  test_progress_program_expect_exception "testBadFunctionCallArgsMissing2" "
  function int main()
  	me(2)
  end function
  
  function int me()
  	return 0
  end function
  ";
  
  test_progress_program_expect_exception "testBadFunctionCallArgsWrongType" "
  function int main()
  	me(true)
  end function
  
  function int me(int a)
  	return 0
  end function
  ";
  
  test_progress_program_compare "testOperatorAssociativity" "
  function int main()
  	int myint = (6 + 14) * 20
  	int myint2 = 6 + (14 * 20)
  	int myint3 = 6 + 14 * 20
  	printLine(\"test operator associativity \" @ myint @ \"-\" @ myint2 @ \"-\" @ myint3)
  	return 0
  end function
  " "test operator associativity 400-286-286";
  
  test_progress_program_expect_exception "testOpTypeMismatch" "
  function int main()
  	boolean comp = true and 1
  	return 0
  end function
  ";
  
  
  
  test_progress_program_compare "testAndOr" "
  function int main()
  	if andTrue(0) then
  		printLine(\"Basic case1 success\")
  	else
  		printLine(\"Basic case1 failed\")
  	end if
  	if andFalse(0) then
  		printLine(\"Basic case2 failed\")
  	else
  		printLine(\"Basic case2 success\")
  	end if
  	
  	if andTrue(0) and andTrue(1) and andTrue(2) then
  		printLine(\"case3 success\")
  	else
  		printLine(\"case3 failed\")
  	end if

  	if andTrue(0) and andTrue(1) and andFalse(2) then
  		printLine(\"case4 failed\")
  	else
  		printLine(\"case4 success\")
  	end if

  	if andFalse(0) and andTrue(1) and andTrue(2) then
  		printLine(\"case4.1 - verify lazy evalution failed\")
  	else
  		printLine(\"case4.1 - verify lazy evalution success\")
  	end if

  	if orFalse(0) or orFalse(1) or orTrue(2) then
  		printLine(\"case5 success\")
  	else
  		printLine(\"case5 failed\")
  	end if

  	if orTrue(0) or orFalse(1) or orFalse(2) then
  		printLine(\"case5.1 - verify lazy evalution success\")
  	else
  		printLine(\"case5.1 - verify lazy evalution failed\")
  	end if

  	if orFalse(0) or orFalse(1) or orFalse(2) then
  		printLine(\"case6 failed\")
  	else
  		printLine(\"case6 success\")
  	end if

  	if orFalse(0) or andTrue(1) and andTrue(2) then
  		printLine(\"case 7 ambiguous true\")
  	else
  		printLine(\"case 7 ambiguous false\")
  	end if

  	if (orFalse(0) or andTrue(1)) and andTrue(2) then
  		printLine(\"case 7.1 success\")
  	else
  		printLine(\"case 7.1 failed\")
  	end if

  	if orFalse(0) or (andTrue(1) and andTrue(2)) then
  		printLine(\"case 7.2 success\")
  	else
  		printLine(\"case 7.2 failed\")
  	end if

  	if andTrue(0) and andTrue(1) or orFalse(2) then
  		printLine(\"case 8 ambiguous true\")
  	else
  		printLine(\"case 8 ambiguous false\")
  	end if

  	if (andTrue(0) and andTrue(1)) or orFalse(2) then
  		printLine(\"case 8.1 success\")
  	else
  		printLine(\"case 8.1 failed\")
  	end if

  	if andTrue(0) and (andTrue(1) or orFalse(2)) then
  		printLine(\"case 8.2 success\")
  	else
  		printLine(\"case 8.2 failed\")
  	end if

  	return 0
  end function
  
  function boolean andTrue(int a)
  	printLine(\"andTrue\" @ a)
  	return true
  end function
  function boolean andFalse(int a)
  	printLine(\"andFalse\" @ a)
  	return false
  end function
  function boolean orTrue(int a)
  	printLine(\"orTrue\" @ a)
  	return true
  end function
  function boolean orFalse(int a)
  	printLine(\"orFalse\" @ a)
  	return false
  end function
  	" "andTrue0
Basic case1 success
andFalse0
Basic case2 success
andTrue0
andTrue1
andTrue2
case3 success
andTrue0
andTrue1
andFalse2
case4 success
andFalse0
case4.1 - verify lazy evalution success
orFalse0
orFalse1
orTrue2
case5 success
orTrue0
case5.1 - verify lazy evalution success
orFalse0
orFalse1
orFalse2
case6 success
orFalse0
andTrue1
andTrue2
case 7 ambiguous true
orFalse0
andTrue1
andTrue2
case 7.1 success
orFalse0
andTrue1
andTrue2
case 7.2 success
andTrue0
andTrue1
case 8 ambiguous true
andTrue0
andTrue1
case 8.1 success
andTrue0
andTrue1
case 8.2 success";
  
  
  test_progress_program_compare "testIfElse" "
  function int main()
  	/* Ensure that only the first valid path is taken for these tests
  	(i.e. do not process subsequent paths even if the condition is successful */
  	if 1 == 1 then
  		printLine (\"Case 1 is good!\")
  	elseif 1 == 1 then
  		printLine(\"Don't print this!\")
  	elseif 1 == 1 then
  		printLine(\"Don't print this!\")
  	else
  		printLine(\"Don't print this!\")
  	end if

  	if false then
  		printLine(\"Don't print this!\")
  	elseif true then
  		printLine (\"Case 2 is good!\")
  	elseif true then
  		printLine(\"Don't print this!\")
  	else
  		printLine(\"Don't print this!\")
  	end if

  	if 1 == 555 then
  		printLine(\"Don't print this!\")
  	elseif 1 == 555 then
  		printLine(\"Don't print this!\")
  	elseif 1 == 1 then
  		printLine (\"Case 3 is good!\")
  	else
  		printLine(\"Don't print this!\")
  	end if

  	if 1 == 555 then
  		printLine(\"Don't print this!\")
  	elseif 1 == 555 then
  		printLine(\"Don't print this!\")
  	elseif 1 == 55 then
  		printLine(\"Don't print this!\")
  	else
  		printLine (\"Case 4 is good!\")
  	end if

  	return 0
  end function
  " "Case 1 is good!
Case 2 is good!
Case 3 is good!
Case 4 is good!";
  
  test_progress_program_expect_exception "testBoardWrongRowColCount" "
  enum myenum
  	a, b, c
  end enum
  enum myenum2
  	d, e, f
  end enum
  function int main()
  	board<myenum> myboard
  	myboard = {
  		a a a a
  		b b
  		c c c c
  	}
  	/* todo validate the enum types */
  	board<myenum> myotherboard
  end function
  ";
  
  
  test_progress_program_compare "testRegexp" "
  enum myenum
	aa, bb, cc
  end enum
  function int main()
    string input = \"___ abc123def ___\"

    if input ~= \"[a-z]*([0-9]+)([a-z]*)\" -> string inputA, string inputB then
    	printLine(\"#1 I made it in with these values \" @ inputA @ \"-\" @ inputB)
   	else
   		printLine(\"I did not make it \")
    end if

    if input ~= \"[0-9]+([a-z]*)\" -> string inputA then
    	printLine(\"#2 My string value is \" @ inputA)
   	else
   		printLine(\"I did not make it \")
    end if

    if input ~= \"[5-9]+([a-z]*)\" -> string inputA then
   		printLine(\"Should not get to this point \")
   	elseif input ~= \"([0-9]+)([a-z]*)\" -> int numberA, string inputB then
    	printLine(\"#3 Made it with this value \" @ (numberA + 100) @ \"-\" @ inputB)
    end if

    return 0
  end function
  
  " "#1 I made it in with these values 123-def
#2 My string value is def
#3 Made it with this value 223-def";


    test_progress_program_compare "testLogic" "
  enum myenum
  	aa, bb, cc
  end enum
  function int main()
    int int1 = 5
    string str1 = \"abcd\"
  	printLine(\"equality int-\" @ (int1 == 5))
  	printLine(\"equality int false-\" @ (int1 == 6))
  	printLine(\"inequality int-\" @ (int1 != 6))
  	printLine(\"equality string const-\" @ (str1 == \"abcd\"))
  	printLine(\"equality string const false-\" @ (str1 == \"zzzzabcd\"))
  	printLine(\"equality string dynamic-\" @ (str1 == (\"ab\" @ \"cd\")))
  	printLine(\"inequality string dynamic-\" @ (str1 != (\"zzzab\" @ \"cd\")))
  	return 0
  end function
  
  " "equality int-true
equality int false-false
inequality int-true
equality string const-true
equality string const false-false
equality string dynamic-true
inequality string dynamic-true";


  
  
  test_progress_program_compare "testWhile" "
  function int main()
    int i = 0
    while i < 5 do
    	int sameattrname = 999
    	print(i @ \"-\" @ sameattrname @ \" \")
    	i = i + 1
    end while

	i = 0
    while i < 0 do
    	print(\"This should never get called\")
    end while

	printLine(\"!\")
  
  	i = 0
    while i < 3 do
	  	int j
	  	j = 0
    	while j < 2 do
    		print(\"j\")
    		j = j + 1
    	end while

    	/* show that the variable scope is kept within the block */
    	int sameattrname
    	sameattrname = 333
    	print(i @ \"-\" @ sameattrname @ \" \")
    	i = i + 1
    end while

  	return 0
  end function
  " "0-999 1-999 2-999 3-999 4-999 !
jj0-333 jj1-333 jj2-333 ";
  
  test_progress_program_compare "testFor" "
  function int main()
  	int i
    for i = 0; i < 5; i = i + 1 do
    	int sameattrname = 999
    	print(i @ \"-\" @ sameattrname @ \" \")
    end for
    for i = 0; i < 0; i = i + 1 do
    	print(\"This should never get called\")
    end for

	printLine(\"!\")
  
    for i = 0; i < 3; i = i + 1 do
    	int j
	    for j = 0; j < 2; j = j + 1 do
    		print(\"j\")
    	end for

    	/* show that the variable scope is kept within the block */
    	int sameattrname
    	sameattrname = 333
    	print(i @ \"-\" @ sameattrname @ \" \")
    end for

  	return 0
  end function
  " "0-999 1-999 2-999 3-999 4-999 !
jj0-333 jj1-333 jj2-333 ";
  
  test_progress_program_expect_exception "testLoopsNestedScopeVarFail" "
  function int main()
    int i = 0
    int j = 0
    while i < 5 do
    	int sameattrname
    	sameattrname = 999
    	while j > 5 do
	    	int sameattrname /* this should throw a compile exception */
	    	sameattrname = 998
    	end while
    end while
  	return 0
  end function
  ";
  
  test_progress_program_compare "testBoardDiffSize" "
  enum Piece
  	r, b, B, R, o
  end enum
  
  function int main()
	board<Piece> myboard2 = {
		r o r o r o r o r
		o r o r o r o r o
		r o r o r o r o r
		o o o o o o o o o
		o o o o o o o o o
		o b o b o b o b o
		b o b o b o b o b
		o b o b o b o b o
		}
	printBoard_Piece(myboard2)
	return 0
  end function
  " "r o r o r o r o r 
o r o r o r o r o 
r o r o r o r o r 
o o o o o o o o o 
o o o o o o o o o 
o b o b o b o b o 
b o b o b o b o b 
o b o b o b o b o ";
  
  
  test_progress_program_compare "testBoardAndFuncCalls" "
  enum myenum
  	aa, bb, cc
  end enum
  enum myenum2
  	dd, ee, ff
  end enum

  function int main()
  	board<myenum> myboard = {
  		aa aa aa bb
  		bb bb bb cc
  		cc cc cc aa
  	}
  	printLine(\"Board 1!\")
  	printBoard_myenum(myboard)

  	board<myenum2> myotherboard = {
  		dd dd dd ee
  		ee ee ee ff
  		ff ff ff dd
  	}
  	printLine(\"Board 2!\")
  	printBoardWithMyFunction(myotherboard, 5, 6)

  	myenum testvar = myboard[1, 1]
  	printLine(\"Board has \" @ myboard.rowlength @ \" rows and \" @ myboard.collength @ \" cols\")
  	printLine(\"Hello my enum value is \" @ testvar @ \". That's it!\")
  	printLine(\"Hello my enum value is \" @ myboard[1, 1] @ \". That's it!\")
  	myboard[1, 1] = bb
  	printLine(\"Hello my enum value is \" @ myboard[1, 1] @ \". That's it!\")

  	myenum2 myreadenum = parseEnum_myenum2(\"ee\")
  	printLine(\"I just read in \" @ myreadenum)

	return 0
  end function
  function int printBoardWithMyFunction(board<myenum2> myboard, int var1, int var2)
  	printLine(\"My new function with \" @ var1 @ \" and \" @ var2)
  	printBoard_myenum2(myboard)
  	return 0
  end function
  " "Board 1!
aa aa aa bb 
bb bb bb cc 
cc cc cc aa 
Board 2!
My new function with 5 and 6
dd dd dd ee 
ee ee ee ff 
ff ff ff dd 
Board has 3 rows and 4 cols
Hello my enum value is aa. That's it!
Hello my enum value is aa. That's it!
Hello my enum value is bb. That's it!
I just read in ee";
    
  printf "Finished all test cases - we have a success!\n";
;;


