type action = Console | File

let _ =
  let action, filename =
    if Array.length Sys.argv > 1
    then
      (let input = List.assoc Sys.argv.(1) [ ("-c", Console); ("-f", File) ] in
       input, Sys.argv.(2)
      )
    else raise(Failure("Pass in -c for console or -f fileName for the file")) in
  match action with
    | Console ->
      let lexbuf = Lexing.from_channel stdin in
      Compile.compile_program_from_lexbuf filename lexbuf
    | File ->
      let lexbuf = Lexing.from_channel (open_in (filename ^ ".game")) in
      Compile.compile_program_from_lexbuf filename lexbuf
;;
