--Editor: Zeshi Wang; Jiawan Zhang
-- Data: 2013

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity top_level is
port (
signal CLOCK_50 : in std_logic; --50 MHz
--signal LEDR : out std_logic_vector(17 downto 0); --LEDs
-- PS/2 port
    PS2_DAT,                    -- Data
    PS2_CLK : in std_logic;     -- Clock
	 
	SRAM_DQ : inout std_logic_vector(15 downto 0);
	SRAM_ADDR : out std_logic_vector(17 downto 0);
	SRAM_UB_N, --Highbyte Data Mask
	SRAM_LB_N, --Lowbyte Data Mask
	SRAM_WE_N, --Write Enable
	SRAM_CE_N, --Chip Enable
	SRAM_OE_N : out std_logic; --Output Enable

	--vga
    VGA_CLK,                                            -- Clock
    VGA_HS,                                             -- H_SYNC
    VGA_VS,                                             -- V_SYNC
    VGA_BLANK,                                          -- BLANK
    VGA_SYNC : out std_logic;                           -- SYNC
    VGA_R,                                              -- Red[9:0]
    VGA_G,                                              -- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0);                   -- Blue[9:0]
	
  -- Audio CODEC
    
    AUD_ADCLRCK : inout std_logic;                      -- ADC LR Clock
    AUD_ADCDAT : in std_logic;                          -- ADC Data
    AUD_DACLRCK : inout std_logic;                      -- DAC LR Clock
    AUD_DACDAT : out std_logic;                         -- DAC Data
    AUD_BCLK : inout std_logic;                         -- Bit-Stream Clock
    AUD_XCK : out std_logic;                            -- Chip Clock
	 
-- I2C bus
    
    I2C_SDAT : inout std_logic; -- I2C Data
    I2C_SCLK : out std_logic;   -- I2C Clock 
	 
--  Ethernet Interface
    
    ENET_DATA : inout std_logic_vector(15 downto 0);    -- DATA bus 16Bits
    ENET_CMD,           -- Command/Data Select, 0 = Command, 1 = Data
    ENET_CS_N,                                          -- Chip Select
    ENET_WR_N,                                          -- Write
    ENET_RD_N,                                          -- Read
    ENET_RST_N,                                         -- Reset
    ENET_CLK : out std_logic;                           -- Clock 25 MHz
    ENET_INT : in std_logic;                            -- Interrupt 

	
	 LEDG : out std_logic_vector(8 downto 0);       -- Green LEDs
    LEDR : out std_logic_vector(17 downto 0)      -- Red LED 
);
end top_level;

architecture rtl of top_level  is

signal counter : unsigned(15 downto 0);
signal reset_n : std_logic;

  signal clk25 : std_logic := '0';
--  signal counter : unsigned(15 downto 0);
--  signal reset_n : std_logic;
  signal audio_clock : unsigned(1 downto 0) := "00";
  signal network_clock : unsigned(1 downto 0) := "00";
  signal clk_18 : std_logic;

--signals for PoolCue_ram
signal CueRam_rdaddress_VGA : std_logic_vector(8 downto 0);
signal CueRam_rdclk_VGA : std_logic;
signal CueRam_q_VGA : std_logic_vector(31 downto 0);
signal CueRam_rdaddress_RAM : std_logic_vector(8 downto 0);
signal CueRam_rdclk_RAM : std_logic;
signal CueRam_q_RAM : std_logic_vector(31 downto 0);


  component de2_i2c_av_config is
  port (
    iCLK : in std_logic;
    iRST_N : in std_logic;
    I2C_SCLK : out std_logic;
    I2C_SDAT : inout std_logic
  );
  end component;

--  component de2_audio_pll is
--  PORT
--   (
--    inclk0		: IN STD_LOGIC  := '0';
--     c0		   : OUT STD_LOGIC 
--    );
--end component de2_audio_pll;
--
--  


begin
--LEDR(17) <= ’1’;
--LEDR(16) <= ’1’;
	CueRam_rdaddress_RAM <= CueRam_rdaddress_VGA;
	CueRam_rdclk_RAM <= CueRam_rdclk_VGA;
	CueRam_q_VGA <= CueRam_q_RAM;
	
	process (CLOCK_50)
	begin
		if rising_edge(CLOCK_50) then
			if counter = x"ffff" then
				reset_n <= '1';
			else
				reset_n <= '0';
			counter <= counter + 1;
			end if;
		end if;
	end process;
	
	
process (CLOCK_50)
  begin
    if rising_edge(CLOCK_50) then
	  if audio_clock = "11" then 
	       audio_clock <= "00";
			 AUD_XCK <= '1'; 
	  else 
      audio_clock <= audio_clock + "1";
		AUD_XCK <= '0';
		end if;
    end if;
  end process;
  
process (CLOCK_50)
  begin
    if rising_edge(CLOCK_50) then
	  if network_clock = "01" then 
	       network_clock <= "00";
			 ENET_CLK <= '1'; 
	  else 
      network_clock <= network_clock + "1";
		ENET_CLK <= '0';
		end if;
    end if;
  end process;

--  AUD_XCK <= clk_18; 
--  
-- v1 : de2_audio_pll port map(
--  inclk0 => clock_50,
--  c0 => clk_18
--  );

  i2c : de2_i2c_av_config port map (
    iCLK     => CLOCK_50,
    iRST_n   => '1',
    I2C_SCLK => I2C_SCLK,
    I2C_SDAT => I2C_SDAT
  );	
	
nios : entity work.nios_system port map (
	-- the_de2_ps2_inst
	PS2_Clk_to_the_de2_ps2_0  => PS2_CLK,
	PS2_Data_to_the_de2_ps2_0 => PS2_DAT,

	clk_0 => CLOCK_50,
	reset_n => reset_n,
	--leds_from_the_leds => LEDR(15 downto 0),
	SRAM_ADDR_from_the_sram_0 => SRAM_ADDR,
	SRAM_CE_N_from_the_sram_0 => SRAM_CE_N,
	SRAM_DQ_to_and_from_the_sram_0 => SRAM_DQ,
	SRAM_LB_N_from_the_sram_0 => SRAM_LB_N,
	SRAM_OE_N_from_the_sram_0 => SRAM_OE_N,
	SRAM_UB_N_from_the_sram_0 => SRAM_UB_N,
	SRAM_WE_N_from_the_sram_0 => SRAM_WE_N,
	
	
	--the audio instruction
	 AUD_ADCDAT_to_the_audio_0        => AUD_ADCDAT,
	 AUD_ADCLRCK_from_the_audio_0     => AUD_ADCLRCK,
	 AUD_BCLK_to_and_from_the_audio_0 => AUD_BCLK,
	 AUD_DACDAT_from_the_audio_0      => AUD_DACDAT,
	 AUD_DACLRCK_from_the_audio_0     => AUD_DACLRCK,
	
	
 --  Ethernet Interface
    
	 
    ENET_DATA_to_and_from_the_DM9000A_0      => ENET_DATA,
    ENET_CMD_from_the_DM9000A_0              => ENET_CMD, 
    ENET_CS_N_from_the_DM9000A_0     			 => ENET_CS_N,           
    ENET_WR_N_from_the_DM9000A_0    			 => ENET_WR_N,                                  
    ENET_RD_N_from_the_DM9000A_0    		    => ENET_RD_N,             
    ENET_RST_N_from_the_DM9000A_0    		    => ENET_RST_N,                
    ENET_INT_to_the_DM9000A_0       			 => ENET_INT,

	-- the_de2_vga_raster
	VGA_BLANK_from_the_de2_vga_raster_0 => VGA_BLANK,
	VGA_B_from_the_de2_vga_raster_0 => VGA_B,
	VGA_CLK_from_the_de2_vga_raster_0 => VGA_CLK,
	VGA_G_from_the_de2_vga_raster_0 => VGA_G,
	VGA_HS_from_the_de2_vga_raster_0 => VGA_HS,
	VGA_R_from_the_de2_vga_raster_0 => VGA_R,
	VGA_SYNC_from_the_de2_vga_raster_0 => VGA_SYNC,
	VGA_VS_from_the_de2_vga_raster_0 => VGA_VS,
	CUERAM_addr_from_the_de2_vga_raster_0 => CueRam_rdaddress_VGA,
	CUERAM_clk_from_the_de2_vga_raster_0 => CueRam_rdclk_VGA,
	CUERAM_q_to_the_de2_vga_raster_0 => CueRam_q_VGA,
	  --LED
	LEDG_from_the_de2_vga_raster_0 => LEDG,
   LEDR_from_the_de2_vga_raster_0 => LEDR,
	
	-- PoolCue_ram
   CUE_q_from_the_PoolCue_ram_controller_0 => CueRam_q_RAM,
	CUE_rdaddress_to_the_PoolCue_ram_controller_0 => CueRam_rdaddress_RAM,
   CUE_rdclock_to_the_PoolCue_ram_controller_0 => CueRam_rdclk_RAM

);
end rtl;
