/*
 * poolball.h
 *
 *  Created on: Apr 9, 2013
 *      Author: Jiawan Zhang
 */

#ifndef POOLBALL_H_
#define POOLBALL_H_

//*****************************************
#include <io.h>
#include <system.h>
#include <stdio.h>

#define IOWR_VGA_BALL_POSITION_X(ballnum, data) \
  IOWR_16DIRECT(DE2_VGA_RASTER_0_BASE, ((ballnum)*4 + 0)*2, data)
#define IOWR_VGA_BALL_POSITION_Y(ballnum, data) \
  IOWR_16DIRECT(DE2_VGA_RASTER_0_BASE, ((ballnum)*4 + 1)*2, data)
#define IOWR_VGA_BALL_BIAS_X(ballnum, bias_x) \
  IOWR_16DIRECT(DE2_VGA_RASTER_0_BASE, ((ballnum)*4 + 2)*2, bias_x)
#define IOWR_VGA_BALL_BIAS_Y(ballnum, bias_y) \
  IOWR_16DIRECT(DE2_VGA_RASTER_0_BASE, ((ballnum)*4 + 3)*2, bias_y)

//int BALL_BIAS_X[16];
//int BALL_BIAS_Y[16];

void placeball(int ballnum, int pos_x, int pos_y, int bias_x, int bias_y, int* BiasX, int* BiasY)
{
	//BALL_BIAS_X[ballnum] = bias_x;
	//BALL_BIAS_Y[ballnum] = bias_y;

	IOWR_VGA_BALL_POSITION_X(ballnum, pos_x);
	IOWR_VGA_BALL_POSITION_Y(ballnum, pos_y);
	IOWR_VGA_BALL_BIAS_X(ballnum, bias_x);
	IOWR_VGA_BALL_BIAS_Y(ballnum, bias_y);

	*BiasX = bias_x;
	*BiasY = bias_y;

}


void moveball(int ballnum, int *pos_x, int *pos_y, int flag_x, int flag_y, int* BiasX, int* BiasY)
{
//flag_x = 0, no moving in x direction; = 1 move right 1 pixel in x direction; = -1 move left 1 pixel in x direction
//flag_y = 0, no moving in y direction; = 1 move down 1 pixel in y direction; = -1 move up 1 pixel in y direction
//ori_x, x position before moving; ori_y, y position before moving;
	int bias_x;
	int bias_y;
	int new_pos_x;
	int new_pos_y;

	bias_x = *BiasX;
	bias_y = *BiasY;
	new_pos_x = *pos_x + flag_x;
	new_pos_y = *pos_y + flag_y;

	bias_x = bias_x - flag_x;
	bias_y = bias_y - flag_y;


	if(bias_x < 0)
	{
		bias_x = 13;
	}
	else if(bias_x > 13)
	{
		bias_x = 0;
	}


	if(bias_y < 0)
	{
		bias_y = 13;
	}
	else if(bias_y > 13)
	{
		bias_y = 0;
	}


	IOWR_VGA_BALL_POSITION_X(ballnum, new_pos_x);
	IOWR_VGA_BALL_POSITION_Y(ballnum, new_pos_y);
	IOWR_VGA_BALL_BIAS_X(ballnum, bias_x);
	IOWR_VGA_BALL_BIAS_Y(ballnum, bias_y);

	*BiasX = bias_x;
	*BiasY = bias_y;
	*pos_x = new_pos_x;
	*pos_y = new_pos_y;


}



//*****************************************
#endif /* POOLBALL_H_ */

