-- Editor: Jiawan Zhang
-- Data: 2013


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity irTimer is port (
  clk_50 : in std_logic;
  reset : in std_logic;
  chipselect : in std_logic;
  read : in std_logic;
  write : in std_logic;
  address : in std_logic;
  readdata  : out std_logic_vector(15 downto 0);
  writedata : in  std_logic_vector(15 downto 0);
  irq       : out std_logic);
end irTimer;

architecture rtl of irTimer is 
  signal counter : unsigned(15 downto 0);
  --signal ms : unsigned(15 downto 0);
  signal data    : std_logic_vector(15 downto 0);
begin
  
--  process(clk_50)
--  begin
--	if rising_edge(clk_50) then
--		if reset = '1' then
--			readdata <= (others => '0');
--			counter <= (others => '0');
--			ms <= (others => '0');
--		else
--			if chipselect = '1' and address = '0' then
--				if write = '1' then
--					ms <= unsigned(writedata);
--					counter <= "1100001101010000";
--				elsif read = '1' then
--					readdata <= std_logic_vector(ms);
--				end if;
--			else 
--				if (counter = x"0000") then
--					if not (ms = x"0000") then
--						ms <= ms - x"0001";
--						counter <= "1100001101010000";
--					end if;
--				else
--					counter <= counter - x"0001";
--				end if;
--					
--			end if;
--		end if;
--	end if;
--  end process;

--  process(clk_50)
--  begin
--	if rising_edge(clk_50) then
--		if reset = '1' then
--			readdata <= (others => '0');
--			counter <= (others => '0');
--		else
--			if chipselect = '1' and address = '0' then
--				if write = '1' then
--					counter <= unsigned(writedata);
--				elsif read = '1' then
--					readdata <= std_logic_vector(counter);
--				end if;
--			else 
--				if not (counter = x"0000") then
--					counter <= counter - x"0001";
--				end if;
--					
--			end if;
--		end if;
--	end if;
--  end process;
  
  process(clk_50)
  begin
	if rising_edge(clk_50) then
		if reset = '1' then
			readdata <= (others => '0');
			counter <= (others => '0');
		else
			if chipselect = '1' and address = '0' then
				if write = '1' then
					counter <= unsigned(writedata);
				elsif read = '1' then
					readdata <= std_logic_vector(counter);
					if not (counter = x"0000") then
						counter <= counter - x"0001";
					end if;
				end if;
			else 
				if not (counter = x"0000") then
					counter <= counter - x"0001";
				end if;				
			end if;
		end if;
	end if;
  end process;
  
  
--  process (clk_50)
--  begin
--    if rising_edge(clk_50) then
--      if reset = '1' then
--			counter <= (others => '0');
--      elsif counter = "1100001101010000" then
--			counter <= (others => '0');
--		else
--         counter <= counter + x"0001";
--      end if;
--    end if;
--  end process;
    
  process (clk_50)
  begin
    if rising_edge(clk_50) then
      if reset = '1' then
        irq <= '0';
      else
        if counter = 0 then
          irq <= '1';
        elsif chipselect = '1' and write = '1' then
          irq <= '0';  
        end if;
      end if;
    end if;
  end process;
  
end rtl;
