--Editor: Jiawan Zhang
--Data: 2013

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity PoolCue_ram_controller is port(
		chipselect : in std_LOGIC;
		writedata		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
		wraddress		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		clk_50		: IN STD_LOGIC;
		write		: IN STD_LOGIC;
		CUE_rdaddress		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		CUE_rdclock		: IN STD_LOGIC ;	
		CUE_q		: OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
	);
end entity PoolCue_ram_controller;

architecture blockram of PoolCue_ram_controller is

component PoolCue_ram IS
	PORT
	(
		data		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
		rdaddress		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		rdclock		: IN STD_LOGIC ;
		wraddress		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		wrclock		: IN STD_LOGIC;
		wren		: IN STD_LOGIC;
		q		: OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
	);
end component PoolCue_ram;

signal inter_CUE_rdaddress : std_logic_vector(8 downto 0);
signal inter_CUE_rdclock : std_logic;
signal inter_CUE_q : std_logic_vector(31 downto 0);

begin
	the_PoolCue_ram : PoolCue_ram port map(
		data => writedata,
		wraddress => wraddress,
		wrclock => clk_50,
		wren => write,
		rdaddress => inter_CUE_rdaddress,
		rdclock => inter_CUE_rdclock,
		q => inter_CUE_q
		);
	inter_CUE_rdaddress <= CUE_rdaddress;
	inter_CUE_rdclock <= CUE_rdclock;
	CUE_q <= inter_CUE_q;
	
end blockram;
