-------------------------------------------------------------------------------
--
-- Seven segment display driver
--
-- David Calhoun
-- dmc2202@columbia.edu
--
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;


entity seven_seg is 
port(
	inbits : in std_logic_vector(3 downto 0);
	outseg : out std_logic_vector(6 downto 0)

	);
end seven_seg;

architecture conv of seven_seg is

signal outsig : std_logic_vector(6 downto 0);

begin

	process (inbits)
	begin
		case inbits is
		
			when x"1" =>
				outsig <= "1111001";	
			when x"2" =>
				outsig <= "0100100"; 	
			when x"3" =>
				outsig <= "0110000"; 	
			when x"4" => 
				outsig <= "0011001"; 	
			when x"5" =>
				outsig <= "0010010"; 	
			when x"6" =>
				outsig <= "0000010"; 	
			when x"7" =>
				outsig <= "1111000"; 	
			when x"8" =>
				outsig <= "0000000"; 	
			when x"9" =>
				outsig <= "0011000"; 	
			when x"a" =>
				outsig <= "0001000";
			when x"b" =>
				outsig <= "0000011";
			when x"c" =>
				outsig <= "1000110";
			when x"d" =>
				outsig <= "0100001";
			when x"e" =>
				outsig <= "0000110";
			when x"f" =>
				outsig <= "0001110";
			when x"0" =>
				outsig <= "1000000";
		end case;
	end process;
		
		outseg <= outsig;

end conv;