-------------------------------------------------------------------------------
--
-- Memory mapper
--
-- Currently configured for mapping a 16x16 block to an arbitrary location in 
-- a 128x128 block
--
-- David Calhoun
-- dmc2202@columbia.edu
--
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity map_memory is

	port(
		clock : in std_logic;
		addr_in : in unsigned(13 downto 0);
		wren : in std_logic;
		addr_aout : out unsigned(13 downto 0);
		addr_sout : out unsigned(7 downto 0)
		--rden_selects : in std_logic_vector(3 downto 0)
		--addr_out : out unsigned(13 downto 0)
	);
	
end map_memory;


architecture rtl of map_memory is
	--constant COL_HOP : unsigned := "00000000000001";
	--constant LIN_HOP : unsigned := "00000010000000";
	signal addr_map : unsigned(13 downto 0) := "11111111111111";
	signal addr_start : unsigned(13 downto 0);
	signal addr_cnt : unsigned(7 downto 0) := "11111110";
	signal counter : unsigned(3 downto 0) := "0000";
	
	
begin
	
	
	process(clock)
	
	begin
		if(rising_edge(clock)) then
				if addr_cnt = "11111111" then
					addr_start <= addr_in;
					addr_map <= addr_in;
					addr_cnt <= addr_cnt + 1;
					counter <= "0001";
				elsif addr_cnt(3 downto 0) = "1111" then
					-- move by 128
					addr_start <= addr_start + "00000010000000";
					addr_map <= addr_start + "00000010000000";
					addr_cnt <= addr_cnt + 1;
					counter <= "0001";
				else 
					addr_map <= addr_start + counter;
					addr_cnt <= addr_cnt + 1;
					counter <= counter + 1;
				end if;
		end if;
	
	end process;
	
	
	addr_aout <= addr_map;
	addr_sout <= addr_cnt+1;
	
	
	
	
	 
end rtl;