--Kishore Padmaraju
--April 9th, 2013

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;


entity de2_FSM_controller is
  port(
	reset : in std_logic;
   clk   : in std_logic; 
	
	read			:	in std_logic;
	write		: 	in std_logic;
	chipselect	:	in std_logic;
	address		: 	in std_logic_vector(3 downto 0);
	readdata	:	out std_logic_vector(15 downto 0);
	writedata	:	in std_logic_vector(15 downto 0);

	
	
	gpio: inout std_logic_vector(35 downto 0)
	-- have to add ports so that dx,dy,lc,rc registers are accessible from software
  );
end de2_FSM_controller;

architecture layout of de2_FSM_controller is

	component Mouse_FSM is
		port(
			CLOCK	    : in std_logic; 						-- 50 MHz clock 
			FSM_en		: in std_logic; 						-- FSM_en is to enable or halt the FSM	
			GPIO		: inout std_logic_vector(35 downto 0); 	-- GPIO pin connections			
			MEM_wr		: out std_logic_vector(4 downto 0);
			data_out	: out std_logic_vector(7 downto 0);	-- data written out to memory blocks
			wr_addr		: out std_logic_vector(7 downto 0) 
		);
	end component;
	
	component RAM2 is
		port(
			clock		: in std_logic :='1';
			data		: in std_logic_vector (7 downto 0);
			rdaddress	: in std_logic_vector (7 downto 0);
			wraddress	: in std_logic_vector (7 downto 0);
			wren		: in std_logic :='0';
			q			: out std_logic_vector (7 downto 0)
		);
	end component;
	
	component RAM3 is
		port(
			clock		: in std_logic :='1';
			data		: in std_logic_vector (7 downto 0);
			rdaddress	: in std_logic_vector (7 downto 0);
			wraddress	: in std_logic_vector (7 downto 0);
			wren		: in std_logic :='0';
			q			: out std_logic_vector (7 downto 0)
		);
	end component;
	
	component RAM4 is
		port(
			clock		: in std_logic :='1';
			data		: in std_logic_vector (7 downto 0);
			rdaddress	: in std_logic_vector (7 downto 0);
			wraddress	: in std_logic_vector (7 downto 0);
			wren		: in std_logic :='0';
			q			: out std_logic_vector (7 downto 0)
		);
	end component;
	
	component RAM5 is
		port(
			clock		: in std_logic :='1';
			data		: in std_logic_vector (7 downto 0);
			rdaddress	: in std_logic_vector (7 downto 0);
			wraddress	: in std_logic_vector (7 downto 0);
			wren		: in std_logic :='0';
			q			: out std_logic_vector (7 downto 0)
		);
	end component;
	
	signal dx2 : std_logic_vector(7 downto 0);
	signal dx3 : std_logic_vector(7 downto 0);
	signal dx4 : std_logic_vector(7 downto 0);
	signal dx5 : std_logic_vector(7 downto 0);
	
	signal dy2 : std_logic_vector(7 downto 0);
	signal dy3 : std_logic_vector(7 downto 0);
	signal dy4 : std_logic_vector(7 downto 0);
	signal dy5 : std_logic_vector(7 downto 0);
	
	signal lc2 : std_logic_vector(7 downto 0);
	signal lc3 : std_logic_vector(7 downto 0);
	signal lc4 : std_logic_vector(7 downto 0);
	signal lc5 : std_logic_vector(7 downto 0);
	
	signal rc2 : std_logic_vector(7 downto 0);
	signal rc3 : std_logic_vector(7 downto 0);
	signal rc4 : std_logic_vector(7 downto 0); 
	signal rc5 : std_logic_vector(7 downto 0);
	
	signal FSM_enable		: std_logic :='1';
	signal mem_write		: std_logic_vector(4 downto 0); -- specifies whether RAM, dx, dy, lc, or rc registers should be written to
	
	signal wren_selects 	: std_logic_vector(3 downto 0) :="0001"; -- selects which image sample (2-5) should be written to
	signal wren_RAM2, wren_RAM3, wren_RAM4, wren_RAM5: std_logic; 
	signal data_line		: std_logic_vector(7 downto 0); 
	signal read_address		: std_logic_vector(7 downto 0) := (others => '0');
	signal write_address	: std_logic_vector(7 downto 0);
	signal display_pixel	: std_logic_vector(7 downto 0) := (others => '0');

	 
begin

	SW_Access : process (clk)
	begin
		
		if rising_edge(clk) then
			if reset = '1' then
			
			elsif chipselect = '1' then
				if read = '1' then
					
					if address= "0000" then
					
					elsif address= "0001" then
						
					
					else 
						
					end if;
				end if;
				if write = '1' then
					
					if address = "0010" then

					elsif address = "0011" then	
					
					else 
						
						
					end if;
				end if;
			end if;
		end if;
	end process SW_Access;






	process(clk)
	begin
		if(rising_edge(clk)) then
		
			case mem_write is
				when "00100" =>
					wren_RAM2 <= wren_selects(0);
					wren_RAM3 <= wren_selects(1);
					wren_RAM4 <= wren_selects(2);
					wren_RAM5 <= wren_selects(3);
				when others =>
					wren_RAM2 <= '0';
					wren_RAM3 <= '0';
					wren_RAM4 <= '0';
					wren_RAM5 <= '0';
			end case;
				
			case mem_write is
				when "00001" =>
					case wren_selects is
						when "0001" =>
							dx2 <= data_line;
						when "0010" =>
							dx3 <= data_line;
						when "0100" =>
							dx4 <= data_line;
						when "1000" =>
							dx5 <= data_line;
						when others =>
							null;
					end case;
				when "00010" =>
					case wren_selects is
						when "0001" =>
							dy2 <= data_line;
						when "0010" =>
							dy3 <= data_line;
						when "0100" =>
							dy4 <= data_line;
						when "1000" =>
							dy5 <= data_line;
						when others =>
							null;
					end case;
				when "01000" =>
					case wren_selects is
						when "0001" =>
							lc2 <= data_line;
						when "0010" =>
							lc3 <= data_line;
						when "0100" =>
							lc4 <= data_line;
						when "1000" =>
							lc5 <= data_line;
						when others =>
							null;
					end case;
				when "10000" =>
					case wren_selects is
						when "0001" =>
							rc2 <= data_line;
						when "0010" =>
							rc3 <= data_line;
						when "0100" =>
							rc4 <= data_line;
						when "1000" =>
							rc5 <= data_line;
						when others =>
							null;
					end case;
				when others =>
					null;
				end case;
		end if;
	end process;
			
	Mouse_FSM_0: Mouse_FSM
	port map(
		CLOCK => clk,
		FSM_en => FSM_enable,
		GPIO => gpio,
		MEM_wr => mem_write,
		data_out => data_line,
		wr_addr => write_address
	);

	RAM2_inst: RAM2
	port map(
		clock => clk, 
		data => data_line,
		rdaddress => read_address,
		wraddress => write_address,
		wren => wren_RAM2,
		q => display_pixel
	);
	
	RAM3_inst: RAM3
	port map(
		clock => clk, 
		data => data_line,
		rdaddress => read_address,
		wraddress => write_address,
		wren => wren_RAM3,
		q => display_pixel
	);
	
	RAM4_inst: RAM4
	port map(
		clock => clk, 
		data => data_line,
		rdaddress => read_address,
		wraddress => write_address,
		wren => wren_RAM4,
		q => display_pixel
	);
	
	RAM5_inst: RAM5
	port map(
		clock => clk, 
		data => data_line,
		rdaddress => read_address,
		wraddress => write_address,
		wren => wren_RAM5,
		q => display_pixel
	);
	
end layout;