-------------------------------------------------------------------------------
--
-- GPIO and FSM controller
--
-- Originally written by Kishore Padmaraju, kp2362@columbia.edu
-- 
-- Joint debugging and and editing by David Calhoun, dmc2202@columbia.edu 
-- and Kishore Padmaraju
--
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;


entity de2_FSM_controller is
  port(
	reset : in std_logic;
   clk   : in std_logic; 
	--slowclock 	: in std_logic;
	
	--connection to SW
	read			:	in std_logic;
	write		: 	in std_logic;
	chipselect	:	in std_logic;
	address		: 	in std_logic_vector(3 downto 0);
	readdata	:	out std_logic_vector(15 downto 0);
	writedata	:	in std_logic_vector(15 downto 0);
	
	--address to get pixel buffer data from
	read_address : in std_logic_vector(7 downto 0);
	--current pixel data
	display_pixel_out : out std_logic_vector(7 downto 0);
	-- selects which image sample (2-5) should be written to
	--wren_selects	: in std_logic_vector(3 downto 0);
	-- selects which image sample (2-5) should be read from
	rden_selects 	: in std_logic_vector(3 downto 0);
	--physical IO
	gpio	: inout std_logic_vector(35 downto 0);
		 
	ledr	: out std_logic_vector(7 downto 0);
	ledg	: out std_logic_vector(7 downto 0)
	
  );
end de2_FSM_controller;

architecture layout of de2_FSM_controller is

	component Mouse_FSM is
		port(
			CLOCK	    : in std_logic; 						-- 50 MHz clock 
			--SLOWCLOCK 	:	 in std_logic;
			RESET		: in std_logic;
			FSM_en		: in std_logic; 						-- FSM_en is to enable or halt the FSM	
			GPIO		: inout std_logic_vector(35 downto 0); 	-- GPIO pin connections			
			MEM_wr		: out std_logic_vector(5 downto 0);
			data_out	: out std_logic_vector(7 downto 0);	-- data written out to memory blocks
			wr_addr		: out std_logic_vector(7 downto 0)
		);
	end component;
	
	component RAM2 is
		port(
			clock		: in std_logic :='1';
			data		: in std_logic_vector (7 downto 0);
			rdaddress	: in std_logic_vector (7 downto 0);
			wraddress	: in std_logic_vector (7 downto 0);
			wren		: in std_logic :='0';
			q			: out std_logic_vector (7 downto 0)
		);
	end component;
	
	component RAM3 is
		port(
			clock		: in std_logic :='1';
			data		: in std_logic_vector (7 downto 0);
			rdaddress	: in std_logic_vector (7 downto 0);
			wraddress	: in std_logic_vector (7 downto 0);
			wren		: in std_logic :='0';
			q			: out std_logic_vector (7 downto 0)
		);
	end component;
	
	component RAM4 is
		port(
			clock		: in std_logic :='1';
			data		: in std_logic_vector (7 downto 0);
			rdaddress	: in std_logic_vector (7 downto 0);
			wraddress	: in std_logic_vector (7 downto 0);
			wren		: in std_logic :='0';
			q			: out std_logic_vector (7 downto 0)
		);
	end component;
	
	component RAM5 is
		port(
			clock		: in std_logic :='1';
			data		: in std_logic_vector (7 downto 0);
			rdaddress	: in std_logic_vector (7 downto 0);
			wraddress	: in std_logic_vector (7 downto 0);
			wren		: in std_logic :='0';
			q			: out std_logic_vector (7 downto 0)
		);
	end component;
	
	signal dx : std_logic_vector(7 downto 0);
	signal dx2 : std_logic_vector(7 downto 0);
	signal dx3 : std_logic_vector(7 downto 0);
	signal dx4 : std_logic_vector(7 downto 0);
	signal dx5 : std_logic_vector(7 downto 0);
	
	signal dy : std_logic_vector(7 downto 0);
	signal dy2 : std_logic_vector(7 downto 0);
	signal dy3 : std_logic_vector(7 downto 0);
	signal dy4 : std_logic_vector(7 downto 0);
	signal dy5 : std_logic_vector(7 downto 0);
	
	signal lc : std_logic_vector(7 downto 0);
	signal lc2 : std_logic_vector(7 downto 0);
	signal lc3 : std_logic_vector(7 downto 0);
	signal lc4 : std_logic_vector(7 downto 0);
	signal lc5 : std_logic_vector(7 downto 0);
	
	signal rc : std_logic_vector(7 downto 0);
	signal rc2 : std_logic_vector(7 downto 0);
	signal rc3 : std_logic_vector(7 downto 0);
	signal rc4 : std_logic_vector(7 downto 0); 
	signal rc5 : std_logic_vector(7 downto 0);
	

	signal img_smp: std_logic_vector(15 downto 0) := (others => '0'); -- stores the sequence numbers for all the image samples
	
	signal FSM_enable		: std_logic :='1';
	signal mem_write		: std_logic_vector(5 downto 0); -- specifies whether RAM, dx, dy, lc, or rc registers should be written to
	
	signal wren_selects 	: std_logic_vector(3 downto 0) :="0001"; -- selects which image sample (2-5) should be written to
	signal wren_RAM2, wren_RAM3, wren_RAM4, wren_RAM5: std_logic; 
	signal data_line		: std_logic_vector(7 downto 0); 
	--signal read_address		: std_logic_vector(7 downto 0) := (others => '0');
	signal write_address	: std_logic_vector(7 downto 0);
	signal display_pixel2	: std_logic_vector(7 downto 0) := (others => '0');
	signal display_pixel3	: std_logic_vector(7 downto 0) := (others => '0');
	signal display_pixel4	: std_logic_vector(7 downto 0) := (others => '0');
	signal display_pixel5	: std_logic_vector(7 downto 0) := (others => '0');

	 
begin
--
	SW_Access : process (clk)
	begin
		
		if rising_edge(clk) then
			if reset = '1' then
			
			elsif chipselect = '1' then
				if read = '1' then
					
					--status of LC
					if address= "0000" then
						readdata <= "00000000" & lc;
					--status of RC
					elsif address= "0001" then
						readdata <= "00000000" & rc;
					--status of dx
					elsif address = "0010" then
						readdata <= "00000000" & dx;
					--status of dy
					elsif address = "0011" then
						readdata <= "00000000" & dy;
					elsif address = "0100" then
						readdata <= img_smp;
								
					end if;
				end if;
				if write = '1' then
					
--					if address = "0100" then
--
--					elsif address = "0101" then	
--					
--					else 
--						
--						
--					end if;
				end if;
			end if;
		end if;
	end process SW_Access;






	process(clk)
	begin
		if(rising_edge(clk)) then
		
			case mem_write is
				when "000100" =>
					wren_RAM2 <= wren_selects(0);
					wren_RAM3 <= wren_selects(1);
					wren_RAM4 <= wren_selects(2);
					wren_RAM5 <= wren_selects(3);
				when others =>
					wren_RAM2 <= '0';
					wren_RAM3 <= '0';
					wren_RAM4 <= '0';
					wren_RAM5 <= '0';
			end case;
				
			case mem_write is
				when "000001" =>
					case wren_selects is
						when "0001" =>
							dx2 <= data_line;
						when "0010" =>
							dx3 <= data_line;
						when "0100" =>
							dx4 <= data_line;
						when "1000" =>
							dx5 <= data_line;
						when others =>
							null;
					end case;
					--dx <= data_line;
				when "000010" =>
					case wren_selects is
						when "0001" =>
							dy2 <= data_line;
						when "0010" =>
							dy3 <= data_line;
						when "0100" =>
							dy4 <= data_line;
						when "1000" =>
							dy5 <= data_line;
						when others =>
							null;
					end case;
					--dy <= data_line;
				when "001000" =>
					case wren_selects is
						when "0001" =>
							lc2 <= data_line;
						when "0010" =>
							lc3 <= data_line;
						when "0100" =>
							lc4 <= data_line;
						when "1000" =>
							lc5 <= data_line;
						when others =>
							null;
					end case;
					--lc <= data_line;
				when "010000" =>
					case wren_selects is
						when "0001" =>
							rc2 <= data_line;
						when "0010" =>
							rc3 <= data_line;
						when "0100" =>
							rc4 <= data_line;
						when "1000" =>
							rc5 <= data_line;
						when others =>
							null;
					end case;
					--rc <= data_line;
				when "100000" =>
					case wren_selects is
						when "0001" =>
							img_smp(3 downto 0) <= data_line(3 downto 0);
							wren_selects <= "0010";
						when "0010" =>
							img_smp(7 downto 4) <= data_line(3 downto 0);
							wren_selects <= "0100";
						when "0100" =>
							img_smp(11 downto 8) <= data_line(3 downto 0);
							wren_selects <= "1000";
						when "1000" =>
							img_smp(15 downto 12) <= data_line(3 downto 0);
							wren_selects <= "0001";
						when others =>
							null;
					end case;
				when others =>
					null;		
				end case;
		end if;
	end process;
			
	Mouse_FSM_0: Mouse_FSM
	port map(
		CLOCK => clk,
		--SLOWCLOCK => slowclock,
		RESET => reset,
		FSM_en => FSM_enable,
		GPIO => gpio,
		MEM_wr => mem_write,
		data_out => data_line,
		wr_addr => write_address
		
	);

	RAM2_inst: RAM2
	port map(
		clock => clk, 
		data => data_line,
		rdaddress => read_address,
		wraddress => write_address,
		wren => wren_RAM2,
		q => display_pixel2
	);
	
	RAM3_inst: RAM3
	port map(
		clock => clk, 
		data => data_line,
		rdaddress => read_address,
		wraddress => write_address,
		wren => wren_RAM3,
		q => display_pixel3
	);
	
	RAM4_inst: RAM4
	port map(
		clock => clk, 
		data => data_line,
		rdaddress => read_address,
		wraddress => write_address,
		wren => wren_RAM4,
		q => display_pixel4
	);
	
	RAM5_inst: RAM5
	port map(
		clock => clk, 
		data => data_line,
		rdaddress => read_address,
		wraddress => write_address,
		wren => wren_RAM5,
		q => display_pixel5
	);
	
	
	Select_mem : process(clk)
	-- this could also end up being on the 25 MHz clock pulse we use for VGA
	begin
		if rising_edge(clk) then
			case wren_selects is
				when "0010" => 
					display_pixel_out <= display_pixel2;
					dx <= dx2;
					dy <= dy2;
					lc <= lc2;
					rc <= rc2;
				when "0100" => 
					display_pixel_out <= display_pixel3;
					dx <= dx3;
					dy <= dy3;
					lc <= lc3;
					rc <= rc3;
				when "1000" => 
					display_pixel_out <= display_pixel4;
					dx <= dx4;
					dy <= dy4;
					lc <= lc4;
					rc <= rc4;
				when "0001" => 
					display_pixel_out <= display_pixel5;
					dx <= dx5;
					dy <= dy5;
					lc <= lc5;
					rc <= rc5;
				when others => 
					display_pixel_out <= "00000000"; 
					dx <= "10101010";
					dy <= "10101010";
					lc <= "00000000";
					rc <= "00000000";
			end case;
		end if;
	end process Select_mem;
	
	ledg <= dx;
	ledr <= dy;
	
end layout;