library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity statistic is

    generic(
			cam_width: integer :=96-1
	 );
    port(
            clk: in std_logic;
            session: in std_logic_vector(95 downto 0) := (others => '0');--session passed from parser
            valid: in std_logic;
            rst: in std_logic;--global reset
				hit_addr_out: out integer range 0 to 8:= 0;
				sel: out std_logic := '0';--select value, pass the seesion when 0, block it when 1
				sel_v: out std_logic := '0'
            
        );
      
end statistic;

architecture func of statistic is
  
    type ram_stat_data is array(0 to 8) of integer range 0 to 8;
    type ram_lut is array(0 to 8) of std_logic_vector(cam_width downto 0);
    type next_state_type is(s0,s1);
    signal statistic_stat_data: ram_stat_data;--store the statistic data
    signal lut: ram_lut;--look up table for comparing
    signal statistic_session: std_logic_vector(cam_width downto 0);--store the session
    --signal statistic_lut: ram_lut;--store the session for outputing
    signal next_state: next_state_type;--current next_state
    signal count: integer range 0 to 8;--indicate the last position in the look up table
	 
	 --signal ram_u: std_logic;--indicating the transfer action when it is set to 1;
	 --signal update: std_logic;--flag to indicate time to update the blacklist
	 signal blacklist: std_logic_vector(0 to 8);
  
begin

    process(clk,rst)
	 variable j: integer := 0;--counter, used as a time period
	 variable hit:std_logic:='0';--indicate that a certain seesion has appeared before
	 variable hit_addr:integer range 0 to 8;
    begin
        
        
		  if(rising_edge(clk)) then
			  if(rst = '1') then--reset settings
					next_state <= s0;
					statistic_session <= (others =>'0');
					
					for c in 0 to 8 loop
						if c=0 then
							lut(c) <= x"c0a80101c0a801ffffffffff";
							blacklist(c)<='1';
						else
							lut(c) <= (others => '0');
							blacklist(c) <= '0';
						end if;
					end loop;
					
					count <= 1;
				else	
					j := j + 1;
					if(j > 200000000) then
						for a1 in 0 to 8 loop
							statistic_stat_data(a1) <= 0;
						end loop;
					j := 0;
					end if;
					
					case next_state is
						 when s0 =>							  
									if valid = '0' then
										next_state <= s0;
									else
										next_state <= s1;
										statistic_session <= session;--store the session to a vector for further use
										for addr in 0 to 8 loop--check the look up table with the port value which lasts for one cycle
											if(session = lut(addr) and hit = '0') then
												hit := '1';--match found									
												------------------------------
												hit_addr :=addr;
												hit_addr_out <= addr;
												-------------------------------variable
											else
												hit:= hit;														 
											end if;
										end loop;
										if hit = '1' then
											sel <= blacklist(hit_addr);
											
										else
											sel <= '0';
										end if;
										sel_v <= '1';
									end if;
									
						 when s1 =>
							  next_state <= s0;
									  sel_v <= '0';
									  if(hit = '1') then
											  statistic_stat_data(hit_addr) <= statistic_stat_data(hit_addr) + 1;
											  hit := '0';
											  --sel <= blacklist(hit_addr);
											  if (statistic_stat_data(hit_addr) > 5) then
														blacklist(hit_addr) <= '1';
												end if; 
											  
											  
									  else
											  lut(count) <= statistic_session;
											  statistic_stat_data(count) <= 1;
											  
											  
											  hit_addr_out <= count;
											  count <= count + 1;
											  
													
											  
											  
									  end if;
					end case;
				end if;
        end if;
    end process;			
end func;