/*
** Copyright 2005-2012  Solarflare Communications Inc.
**                      7505 Irvine Center Drive, Suite 100, Irvine, CA 92618
** Copyright 2002-2005  Level 5 Networks Inc.
**
** This program is licensed software; you may NOT redistribute it.
** Modification and other provisions are permitted according to the terms
** contained within the LICENSE file provided as part of this software
** distribution by Solarflare Communications Inc.
**

SOLARFLARE MAKES THIS SOFTWARE PROGRAM AVAILABLE "AS IS", WITHOUT ANY WARRANTY
AND SOLARFLARE HEREBY EXPRESSLY DISCLAIMS ALL WARRANTIES, EXPRESS, IMPLIED OR
STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, TITLE, ACCURACY AND NONINFRINGEMENT, AND ALL WARRANTIES
THAT MAY ARISE OUT OF COURSE OF DEALING, COURSE OF PERFORMANCE OR USAGE OF
TRADE.

**
*/

package application_wiring_pkg;


typedef struct packed {
    bit sfp0_rx_valid;
    bit [31:0] sfp0_rx_data;
    bit sfp0_rx_error;
    bit sfp0_rx_startofpacket;
    bit sfp0_rx_endofpacket;
    bit [1:0] sfp0_rx_empty;
    bit sfp1_tx_ready;
    bit [6:0] avalon_master_burstcount;
    bit [31:0] avalon_master_writedata;
    bit [29:0] avalon_master_address;
    bit avalon_master_write;
    bit avalon_master_read;
    bit [3:0] avalon_master_byteenable;
    bit avalon_master_debugaccess;
    bit sfp0_tx_ready;
    bit sfp_312_5_clk;
    bit avalon_slave_waitrequest;
    bit [31:0] avalon_slave_readdata;
    bit avalon_slave_readdatavalid;
    bit clk_200;
    bit [31:0] timestamp_counter;
    bit async_reset_n;
    bit nic1_rx_valid;
    bit [31:0] nic1_rx_data;
    bit nic1_rx_error;
    bit nic1_rx_startofpacket;
    bit nic1_rx_endofpacket;
    bit [1:0] nic1_rx_empty;
    bit nic1_tx_ready;
    bit sfp1_rx_valid;
    bit [31:0] sfp1_rx_data;
    bit sfp1_rx_error;
    bit sfp1_rx_startofpacket;
    bit sfp1_rx_endofpacket;
    bit [1:0] sfp1_rx_empty;
    bit nic0_tx_ready;
    bit nic0_rx_valid;
    bit [31:0] nic0_rx_data;
    bit nic0_rx_error;
    bit nic0_rx_startofpacket;
    bit nic0_rx_endofpacket;
    bit [1:0] nic0_rx_empty;
    bit nic_312_5_clk;
} ports_out_struct;

typedef struct packed {
    bit sfp0_rx_ready;
    bit sfp1_tx_valid;
    bit [31:0] sfp1_tx_data;
    bit sfp1_tx_error;
    bit sfp1_tx_startofpacket;
    bit sfp1_tx_endofpacket;
    bit [1:0] sfp1_tx_empty;
    bit avalon_master_waitrequest;
    bit [31:0] avalon_master_readdata;
    bit avalon_master_readdatavalid;
    bit sfp0_tx_valid;
    bit [31:0] sfp0_tx_data;
    bit sfp0_tx_error;
    bit sfp0_tx_startofpacket;
    bit sfp0_tx_endofpacket;
    bit [1:0] sfp0_tx_empty;
    bit [6:0] avalon_slave_burstcount;
    bit [31:0] avalon_slave_writedata;
    bit [8:0] avalon_slave_address;
    bit avalon_slave_write;
    bit avalon_slave_read;
    bit [3:0] avalon_slave_byteenable;
    bit avalon_slave_debugaccess;
    bit nic1_rx_ready;
    bit nic1_tx_valid;
    bit [31:0] nic1_tx_data;
    bit nic1_tx_error;
    bit nic1_tx_startofpacket;
    bit nic1_tx_endofpacket;
    bit [1:0] nic1_tx_empty;
    bit sfp1_rx_ready;
    bit nic0_tx_valid;
    bit [31:0] nic0_tx_data;
    bit nic0_tx_error;
    bit nic0_tx_startofpacket;
    bit nic0_tx_endofpacket;
    bit [1:0] nic0_tx_empty;
    bit nic0_rx_ready;
} ports_in_struct;

endpackage : application_wiring_pkg
