/*
** Copyright 2005-2012  Solarflare Communications Inc.
**                      7505 Irvine Center Drive, Suite 100, Irvine, CA 92618
** Copyright 2002-2005  Level 5 Networks Inc.
**
** This program is licensed software; you may NOT redistribute it.
** Modification and other provisions are permitted according to the terms
** contained within the LICENSE file provided as part of this software
** distribution by Solarflare Communications Inc.
**

SOLARFLARE MAKES THIS SOFTWARE PROGRAM AVAILABLE "AS IS", WITHOUT ANY WARRANTY
AND SOLARFLARE HEREBY EXPRESSLY DISCLAIMS ALL WARRANTIES, EXPRESS, IMPLIED OR
STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, TITLE, ACCURACY AND NONINFRINGEMENT, AND ALL WARRANTIES
THAT MAY ARISE OUT OF COURSE OF DEALING, COURSE OF PERFORMANCE OR USAGE OF
TRADE.

**
*/


module application_demux_wiring #(parameter MUX_SIZE_IN=500, parameter MUX_SIZE_OUT=500) (

    output                       async_reset_n,      // Completely asynchronous reset
    output                       clk_200,            // 200Mhz clock on a global net driven by a PLL
    output                       clk_200_reset_n,    // Synchronously deassrted

    output [31:0]                timestamp_out0, 
    output [31:0]                timestamp_out1, 
    output [31:0]                timestamp_out2, 
    output [31:0]                timestamp_out3, 

    // Avalon-MM slave port connected to board services to permit register
    // accesses from the host

    // Interface is synchronous to clk_200
    output  [5:0]                avalon_master_burstcount,
    output  [29:0]               avalon_master_address,
    input                        avalon_master_waitrequest,
    output                       avalon_master_read,
    input [31:0]                 avalon_master_readdata,
    input                        avalon_master_readdatavalid,
    output                       avalon_master_write,
    output  [31:0]               avalon_master_writedata,


    // Avalon-MM master to access the read-only registers in board services
    input                        avalon_slave_clk,
    input                        avalon_slave_reset_n,
 
    output                       avalon_slave_waitrequest,    //      avalon_slave.waitrequest
    output  [31:0]               avalon_slave_readdata,       //                  .readdata
    output                       avalon_slave_readdatavalid,  //                  .readdatavalid
    input [6:0]                  avalon_slave_burstcount,     //                  .burstcount
    input [8:0]                  avalon_slave_address,        //                  .address
    input                        avalon_slave_read,           //                  .read
    input [3:0]                  avalon_slave_byteenable,     //                  .byteenable
    input                        avalon_slave_debugaccess,    //                  .debugaccess
    input                        avalon_slave_write,          //                  .write
    input [31:0]                 avalon_slave_writedata,      //                  .writedata

    // ========================================================================
    // MAC interfaces

    // SFP 312.5MHz clock
    output                       sfp_312_5_clk,
    output                       nic_312_5_clk,

    output                       sfp_312_5_reset_n,
    output                       nic_312_5_reset_n,

    // SFP0 transmit synchronous to clk_sfp_312_5
    input                        sfp0_tx_startofpacket,      //                    sfp0_tx.startofpacket
    input                        sfp0_tx_valid,              //                           .valid
    input [31:0]                 sfp0_tx_data,               //                           .data
    input [1:0]                  sfp0_tx_empty,              //                           .empty
    output                       sfp0_tx_ready,              //                           .ready
    input                        sfp0_tx_error,              //                           .error
    input                        sfp0_tx_endofpacket,        //                           .endofpacket

    // SFP0 receive synchronous to clk_sfp_312_5
    output                       sfp0_rx_startofpacket,      //                    sfp0_rx.startofpacket
    output                       sfp0_rx_endofpacket,        //                           .endofpacket
    output                       sfp0_rx_valid,              //                           .valid
    input                        sfp0_rx_ready,              //                           .ready
    output  [31:0]               sfp0_rx_data,               //                           .data
    output  [1:0]                sfp0_rx_empty,              //                           .empty
    output                       sfp0_rx_error,              //                           .error

    // SFP1 transmit synchronous to clk_sfp_312_5
    input                        sfp1_tx_startofpacket,      //                    sfp1_tx.startofpacket
    input                        sfp1_tx_valid,              //                           .valid
    input [31:0]                 sfp1_tx_data,               //                           .data
    input [1:0]                  sfp1_tx_empty,              //                           .empty
    output                       sfp1_tx_ready,              //                           .ready
    input                        sfp1_tx_error,              //                           .error
    input                        sfp1_tx_endofpacket,        //                           .endofpacket

    // SFP1 receive synchronous to clk_sfp_312_5
    output                       sfp1_rx_startofpacket,      //                    sfp1_rx.startofpacket
    output                       sfp1_rx_endofpacket,        //                           .endofpacket
    output                       sfp1_rx_valid,              //                           .valid
    input                        sfp1_rx_ready,              //                           .ready
    output  [31:0]               sfp1_rx_data,               //                           .data
    output  [1:0]                sfp1_rx_empty,              //                           .empty
    output                       sfp1_rx_error,              //                           .error

    // NIC0 transmit synchronous to clk_nic_312_5
    input                        nic0_tx_startofpacket,      //                    nic0_tx.startofpacket
    input                        nic0_tx_valid,              //                           .valid
    input [31:0]                 nic0_tx_data,               //                           .data
    input [1:0]                  nic0_tx_empty,              //                           .empty
    output                       nic0_tx_ready,              //                           .ready
    input                        nic0_tx_error,              //                           .error
    input                        nic0_tx_endofpacket,        //                           .endofpacket

    // NIC0 receive synchronous to clk_nic_312_5
    output                       nic0_rx_startofpacket,      //                    nic0_rx.startofpacket
    output                       nic0_rx_endofpacket,        //                           .endofpacket
    output                       nic0_rx_valid,              //                           .valid
    input                        nic0_rx_ready,              //                           .ready
    output  [31:0]               nic0_rx_data,               //                           .data
    output  [1:0]                nic0_rx_empty,              //                           .empty
    output                       nic0_rx_error,              //                           .error

    // NIC0 transmit synchronous to clk_nic_312_5
    input                        nic1_tx_startofpacket,      //                    nic1_tx.startofpacket
    input                        nic1_tx_valid,              //                           .valid
    input [31:0]                 nic1_tx_data,               //                           .data
    input [1:0]                  nic1_tx_empty,              //                           .empty
    output                       nic1_tx_ready,              //                           .ready
    input                        nic1_tx_error,              //                           .error
    input                        nic1_tx_endofpacket,        //                           .endofpacket

    // NIC1 receive synchronous to clk_nic_312_5
    output                       nic1_rx_startofpacket,      //                    nic1_rx.startofpacket
    output                       nic1_rx_endofpacket,        //                           .endofpacket
    output                       nic1_rx_valid,              //                           .valid
    input                        nic1_rx_ready,              //                           .ready
    output  [31:0]               nic1_rx_data,               //                           .data
    output  [1:0]                nic1_rx_empty,              //                           .empty
    output                       nic1_rx_error,              //                           .error

    input   [MUX_SIZE_IN-1:0]    ports_in,
    output  [MUX_SIZE_OUT-1:0]   ports_out

);

application_wiring_pkg::ports_in_struct  pi;
application_wiring_pkg::ports_out_struct po;

assign ports_out = pi;
assign po = ports_in;

assign pi.sfp0_rx_ready                       = sfp0_rx_ready;
assign pi.sfp1_tx_valid                       = sfp1_tx_valid;
assign pi.sfp1_tx_data                        = sfp1_tx_data;
assign pi.sfp1_tx_error                       = sfp1_tx_error;
assign pi.sfp1_tx_startofpacket               = sfp1_tx_startofpacket;
assign pi.sfp1_tx_endofpacket                 = sfp1_tx_endofpacket;
assign pi.sfp1_tx_empty                       = sfp1_tx_empty;
assign pi.avalon_master_waitrequest           = avalon_master_waitrequest;
assign pi.avalon_master_readdata              = avalon_master_readdata;
assign pi.avalon_master_readdatavalid         = avalon_master_readdatavalid;
assign pi.sfp0_tx_valid                       = sfp0_tx_valid;
assign pi.sfp0_tx_data                        = sfp0_tx_data;
assign pi.sfp0_tx_error                       = sfp0_tx_error;
assign pi.sfp0_tx_startofpacket               = sfp0_tx_startofpacket;
assign pi.sfp0_tx_endofpacket                 = sfp0_tx_endofpacket;
assign pi.sfp0_tx_empty                       = sfp0_tx_empty;
assign pi.avalon_slave_burstcount             = avalon_slave_burstcount;
assign pi.avalon_slave_writedata              = avalon_slave_writedata;
assign pi.avalon_slave_address                = avalon_slave_address;
assign pi.avalon_slave_write                  = avalon_slave_write;
assign pi.avalon_slave_read                   = avalon_slave_read;
assign pi.avalon_slave_byteenable             = avalon_slave_byteenable;
assign pi.avalon_slave_debugaccess            = avalon_slave_debugaccess;
assign pi.nic1_rx_ready                       = nic1_rx_ready;
assign pi.nic1_tx_valid                       = nic1_tx_valid;
assign pi.nic1_tx_data                        = nic1_tx_data;
assign pi.nic1_tx_error                       = nic1_tx_error;
assign pi.nic1_tx_startofpacket               = nic1_tx_startofpacket;
assign pi.nic1_tx_endofpacket                 = nic1_tx_endofpacket;
assign pi.nic1_tx_empty                       = nic1_tx_empty;
assign pi.sfp1_rx_ready                       = sfp1_rx_ready;
assign pi.nic0_tx_valid                       = nic0_tx_valid;
assign pi.nic0_tx_data                        = nic0_tx_data;
assign pi.nic0_tx_error                       = nic0_tx_error;
assign pi.nic0_tx_startofpacket               = nic0_tx_startofpacket;
assign pi.nic0_tx_endofpacket                 = nic0_tx_endofpacket;
assign pi.nic0_tx_empty                       = nic0_tx_empty;
assign pi.nic0_rx_ready                       = nic0_rx_ready;

assign sfp0_rx_valid                          = po.sfp0_rx_valid;
assign sfp0_rx_data                           = po.sfp0_rx_data;
assign sfp0_rx_error                          = po.sfp0_rx_error;
assign sfp0_rx_startofpacket                  = po.sfp0_rx_startofpacket;
assign sfp0_rx_endofpacket                    = po.sfp0_rx_endofpacket;
assign sfp0_rx_empty                          = po.sfp0_rx_empty;
assign sfp1_tx_ready                          = po.sfp1_tx_ready;
assign avalon_master_burstcount               = po.avalon_master_burstcount;
assign avalon_master_writedata                = po.avalon_master_writedata;
assign avalon_master_address                  = po.avalon_master_address;
assign avalon_master_write                    = po.avalon_master_write;
assign avalon_master_read                     = po.avalon_master_read;
assign avalon_master_byteenable               = po.avalon_master_byteenable;
assign avalon_master_debugaccess              = po.avalon_master_debugaccess;
assign sfp0_tx_ready                          = po.sfp0_tx_ready;
assign sfp_312_5_clk                          = po.sfp_312_5_clk;
assign avalon_slave_waitrequest               = po.avalon_slave_waitrequest;
assign avalon_slave_readdata                  = po.avalon_slave_readdata;
assign avalon_slave_readdatavalid             = po.avalon_slave_readdatavalid;
assign clk_200                                = po.clk_200;
assign timestamp_counter                      = po.timestamp_counter;
assign async_reset_n                          = po.async_reset_n;
assign nic1_rx_valid                          = po.nic1_rx_valid;
assign nic1_rx_data                           = po.nic1_rx_data;
assign nic1_rx_error                          = po.nic1_rx_error;
assign nic1_rx_startofpacket                  = po.nic1_rx_startofpacket;
assign nic1_rx_endofpacket                    = po.nic1_rx_endofpacket;
assign nic1_rx_empty                          = po.nic1_rx_empty;
assign nic1_tx_ready                          = po.nic1_tx_ready;
assign sfp1_rx_valid                          = po.sfp1_rx_valid;
assign sfp1_rx_data                           = po.sfp1_rx_data;
assign sfp1_rx_error                          = po.sfp1_rx_error;
assign sfp1_rx_startofpacket                  = po.sfp1_rx_startofpacket;
assign sfp1_rx_endofpacket                    = po.sfp1_rx_endofpacket;
assign sfp1_rx_empty                          = po.sfp1_rx_empty;
assign nic0_tx_ready                          = po.nic0_tx_ready;
assign nic0_rx_valid                          = po.nic0_rx_valid;
assign nic0_rx_data                           = po.nic0_rx_data;
assign nic0_rx_error                          = po.nic0_rx_error;
assign nic0_rx_startofpacket                  = po.nic0_rx_startofpacket;
assign nic0_rx_endofpacket                    = po.nic0_rx_endofpacket;
assign nic0_rx_empty                          = po.nic0_rx_empty;
assign nic_312_5_clk                          = po.nic_312_5_clk;

assign timestamp_out0               = po.timestamp_counter;
assign timestamp_out1               = po.timestamp_counter;
assign timestamp_out2               = po.timestamp_counter;
assign timestamp_out3               = po.timestamp_counter;

// Reset Synchronoizers:
sf_reset_sync usfp_312_5_reset_n_sync (
  .reset_n       (async_reset_n),
  .clk           (sfp_312_5_clk),
  .reset_n_sync  (sfp_312_5_reset_n));

sf_reset_sync unic_312_5_reset_n_sync (
  .reset_n       (async_reset_n),
  .clk           (nic_312_5_clk),
  .reset_n_sync  (nic_312_5_reset_n));


sf_reset_sync unic_200_reset_n_sync (
  .reset_n       (async_reset_n),
  .clk           (clk_200),
  .reset_n_sync  (clk_200_reset_n));

endmodule
