-- killswitch.vhd

-- This file was auto-generated as a prototype implementation of a module
-- created in component editor.  It ties off all outputs to ground and
-- ignores all inputs.  It needs to be edited to make it do something
-- useful.
-- 
-- This file will not be automatically regenerated.  You should check it in
-- to your version control system if you want to keep it.

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity killswitch is
	generic(
		id_length :natural := 10 * 8;
		statistic_width : natural := 96
--		fixengine_width :natural := 8;
--		fix_tag_width : natural := 3*8;
--		fix_value_width : natural := 256
	);
	port (
		clk             : in  std_logic := '0'; --                     clk.clk
		reset           : in  std_logic := '0'; --                 reset_n.reset
		
		--Avalon_streaming sink
		ready_sink           : out std_logic;        --               stream_in.ready
		valid_sink           : in  std_logic := '0'; --                        .valid
		data_sink            : in  std_logic_vector(63 downto 0) := x"0000000000000000"; -- .data
		error_sink           : in  std_logic := '1'; --                        .error
		startofpacket_sink   : in  std_logic := '0'; --                        .startofpacket
		endofpacket_sink     : in  std_logic := '0'; --                        .endofpacket
		empty_sink           : in  std_logic_vector(2 downto 0)  := "100"; --                        .empty
		
		--Avalon_streaming source to sfp
		ready_sfp         : in  std_logic := '0'; -- avalon_streaming_source.ready
		valid_sfp         : out std_logic;        --                        .valid
		data_sfp          : out std_logic_vector(63 downto 0);        --                        .data
		error_sfp         : out std_logic := '0';      --                        .error
		startofpacket_sfp : out std_logic;        --                        .startofpacket
		endofpacket_sfp   : out std_logic;        --                        .endofpacket
		empty_sfp         : out std_logic_vector(2 downto 0);       --                        .empty
		
		--Avalon_streaming source to nic
		ready_nic         : in  std_logic := '0'; -- avalon_streaming_source.ready
		valid_nic         : out std_logic;        --                        .valid
		data_nic          : out std_logic_vector(63 downto 0);        --                        .data
		error_nic         : out std_logic := '0';      --                        .error
		startofpacket_nic : out std_logic;        --                        .startofpacket
		endofpacket_nic   : out std_logic;        --                        .endofpacket
		empty_nic         : out std_logic_vector(2 downto 0)       --                        .empty
		
--		--FIX_Engine
--		fix_tag				: in  std_logic_vector(fix_tag_width-1 downto 0) := (others => '0');
--		fix_tag_v         : in  std_logic :='0';
--		fix_value         : in  std_logic_vector(fix_value_width-1 downto 0) := (others => '0');
--		fix_value_v       : in  std_logic :='0';
--		fix_data_out          : out std_logic_vector(fixengine_width-1 downto 0) := (others => '0');
--		fix_data_valid_out		: out std_logic := '0'
		
	);
end entity killswitch;

architecture rtl of killswitch is


signal moveout: std_logic :='0';

signal pfifo_empty: std_logic := '1';
signal pfifo_full: std_logic := '0';
signal pfifo_q: std_logic_vector(63 downto 0) := (others => '0');

signal cfifo_empty: std_logic := '1';
signal cfifo_full: std_logic := '0';
signal cfifo_q: std_logic_vector(7 downto 0) := (others => '0');

signal next_packet_req : std_logic := '0';
signal decision : std_logic := '0'; -- 1 for pass, 0 for drop
signal sel_v <= : std_logic := '0';
signal decision_empty := std_logic := '0';
signal decision_full := std_logic := '0';
signal decision_q := std_logic := '0';

signal package_data: std_logic_vector(63 downto 0) := x"0000000000000000";
signal package_data_out: std_logic_vector(63 downto 0) := x"0000000000000000";
signal command_data_out: std_logic_vector(63 downto 0) := x"0000000000000000";

signal ip_src_addr: std_logic_vector(31 downto 0) := x"00000000";
signal ip_dest_addr: std_logic_vector(31 downto 0) := x"00000000";
signal tcp_src_port: std_logic_vector(15 downto 0) := x"0000";
signal tcp_dest_port: std_logic_vector(15 downto 0) := x"0000";
--signal fix_comp_id: std_logic_vector(id_length-1 downto 0) := (others => '0');
--signal fix_targ_id: std_logic_vector(id_length-1 downto 0) := (others => '0');

signal start_statistic: std_logic :='0';
--signal start_fixengine: std_logic :='0';
signal session_tag: std_logic_vector(statistic_width-1 downto 0) := (others => '0');
signal drop : std_logic := '0';
signal stat_addr_out: integer range 0 to 511:=0;
signal release : std_logic := '1';
signal ready_in : std_logic := '0';

signal fix_data : std_logic_vector := (others => '0');
signal fix_data_valid : std_logic := '0';

begin
V1: entity work.packetbuffer port map (clk, package_data, ready_in, reset, moveout, pfifo_empty, pfifo_full,pfifo_q);
V2: entity work.commandbuffer port map (clk, command_data, ready_in, reset, moveout, cfifo_empty, cfifo_full,pfifo_q);
V3: entity work.decision_buffer port map (clk, decision, next_packet_req, reset, decision_v, decision_empty, decision_full,decision_q);
V4: entity work.statistic port map (clk,session_tag,start_statistic,reset,stat_addr_out,decision,decision_v);

	process (clk)	
	variable offset: integer range 0 to 1000 := 0;
	begin
		if (rising_edge) then
			if reset = '1' then
				ip_src_addr <= (others => '0');
				ip_dest_addr <= (others => '0');
				tcp_src_port <= (others => '0');
				tcp_dest_port <= (others => '0');
				fix_comp_id <= (others => '0');
				fix_targ_id <= (others => '0');
				  
				start_filter <= '0';
				offset := 0;
			  
				valid_sfp <= '0';
				startofpacket_sfp <= '0';
				endofpacket_sfp <= '0';
				empty_sfp <= "000";
				error_sfp <= '0';
				data_sfp <= (others => '0');

				valid_nic <= '0';
				startofpacket_nic <= '0';
				endofpacket_nic <= '0';
				empty_nic <= "000";
				error_nic <= '0';
				data_nic <= (others => '0');

			else
				if pfifo_full = '0' and cfifo_full ='0' and decision_full = '0' then
					ready_sink <= '1';
					if valid_sink = '1' then
						command_data(5) <= startofpacket_sink;
						command_data(4) <= endofpacket_sink;
						command_data(3 downto 1) <= empty_sink;
						command_data(0) <= error_sink;
						package_data <= data_sink;
						ready_in <= '1';
						if startofpacket_sink = '1' then
							offset := 0;
							fix_data_valid <= '0';
							start_statistic <= '0';
						elsif endofpacket_sink = '1'
							if release = '0' then
								start_statistic <= '1';
							else
								decision <= '0';
								decision_v <= '1';
							end if;
						else
						   start_statistic <= '0';
							offset := offset + 1;
							case offset is
								when 2 => -- let go all non-ipv4 packets
									if package_data(31 downto 0) /= x"08004500" then
										release <= '1';
									end if;
								when 3 => -- let go all non-tcp packets
									if package_data(7 downto 0) /= x"06" then
										release <= '1';
									end if;
								when 4 => -- take record of ip source address 
								          -- & first 16 bits of destination address
									if release = '0' then
										ip_src_addr <= package_data(47 downto 16);
										ip_dest_addr(31 downto 16) <= package_data(15 downto 0);
									end if;
								when 5 => -- take record of remaining 16 bits of destination address,
											 -- TCP source port & destination port
									if release = '0' then
										ip_dest_addr(15 downto 0) <= package_data(63 downto 48);
										tcp_src_port <= package_data(47 downto 32);
										tcp_dest_port <= package_data(31 downto 16);
									end if;
								when 8 => -- let go all non-fix packets
									if data_sink(48 downto 0) /= x"383d4649582e" then --try to find "8=FIX."
										release <= '1';
									end if;							
								when others => --do nothing for non-fix packets, forward data to FIX parser
									if release = 0 and offset > 9 then
										fix_data(15 downto 0) <= data_sink(63 downto 48);
										fix_data(63 downto 16) <= package_data(48 downto 0);
										fix_data_valid <= '1';
									end if;
							end case;	
						end if;
					else
						ready_in <= '0';
					end if;
				else 
					ready_sink <= '0';
					ready_in <= '0';
				end if;
				
				if (ready_sfp = '1' or ready_nic ='1') and (pfifo_empty = '0' and cfifo_empty = '0' and decision_empty = '0') then
					if decision_q = '0' and ready_sfp = '1' then -- pass
						moveout <= '1';
						data_sfp <= pfifo_q;
						valid_sfp <= '1';
						startofpacket_sfp <= cfifo_q(5);
						endofpacket_sfp <= cfifo_q(4);
						empty_sfp <= cfifo_q(3 downto 1);
						error_sfp <= cfifo_q(0);
						
						valid_nic <= '0'
						
						if cfifo_q(4) = '1' then
							next_packet_req <= '1';
						end if;
					elsif decision_q = '1' and ready_nic ='1' then -- drop
						moveout <= '1';
						data_nic <= pfifo_q;
						valid_nic <= '1';
						startofpacket_nic <= cfifo_q(5);
						endofpacket_nic <= cfifo_q(4);
						empty_nic <= cfifo_q(3 downto 1);
						error_nic <= cfifo_q(0);
						
						valid_sfp <= '0'
						
						if cfifo_q(4) = '1' then
							next_packet_req <= '1';
						end if;
					else
						moveout <= '0';
						valid_sfp <= '0';
						valid_nic <= '0';
						next_packet_req <= '0';
					end if;
				else
					moveout <= '0';
					valid_sfp <= '0';
					valid_nic <= '0';
					next_packet_req <= '0';
				end if;
			end if;
		end if;	
	end process;
	

end architecture rtl; -- of killswitch
