library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity rotary_controller is

	port(
		clk      : in std_logic;
		reset_n  : in std_logic;
	 
      read       : in  std_logic;
      write      : in  std_logic;
      chipselect : in  std_logic;
      address    : in  std_logic_vector(4 downto 0);
      readdata   : out std_logic_vector(15 downto 0);
      writedata  : in  std_logic_vector(15 downto 0);
		
		GPIO_1      : inout std_logic_vector(35 downto 0)
		
      );
end entity;

architecture rot of rotary_controller is

	type state_type is (s0, s1, s2, s3, s4, s5, s6);
   signal state      : state_type := s0;
   signal lr_flag    : std_logic_vector(1 downto 0):="00";
	signal lr_input   : std_logic_vector(1 downto 0);
	signal lr_tempout  : std_logic_vector(1 downto 0):="00";
	--signal push_input : std_logic;
   signal locker     : integer range 0 to 10000:=0;	

	
begin
  
  lr_input <=GPIO_1(17 downto 16);
--push_input <= GPIO_1(21);
  
 forRam: process (clk)
    begin	 
    if rising_edge(clk) then
      if reset_n = '0' then
        readdata <= (others => '0');
      else
        if (chipselect and read) = '1' then
          readdata(1 downto 0) <= lr_tempout;
        end if;
		end if;          
    end if;
  end process forRam;
  
stateprocess: process (clk)
	begin
		if (rising_edge(clk)) then
			case state is
				when s0=>
					if lr_input = "01" then
						state <= s1;
					elsif lr_input = "10" then
						state <= s4;
					else
						state <= s0;
					end if;	
				when s1=>
					if lr_input = "01" then
						state <= s1;
					elsif lr_input = "11" then
						state <= s2;
					else
						state <= s0;
					end if;
				when s2=>
					if lr_input = "11" then
						state <= s2;
					elsif lr_input = "10" then
						state <= s3;
					else
						state <= s0;
					end if;
				when s3=>
					state <= s0;		--reach the clockwise
				when s4=>
					if lr_input = "10" then
						state <= s4;
					elsif lr_input = "11" then
						state <= s5;
					else
						state <= s0;
					end if;
				when s5=>
					if lr_input = "11" then
						state <= s5;
					elsif lr_input = "01" then
						state <= s6;
					else
						state <= s0;
					end if;
				when s6=>		
					state <= s0;		--reach the counter-clockwise				
			end case;
		end if;
end process stateprocess;

debounce:	process (clk)
	begin
	if rising_edge(clk) then  
		 case state is		    
		   when s3 =>
				lr_flag <= "10";     --clockwise rotation				
			when s6 =>
				lr_flag <= "01";     --counter-clockwise rotation		
			when others =>
				null;
		 end case;

         if lr_flag ="10" then
         locker <= locker+1; 
         lr_tempout <= "10";        

         elsif lr_flag ="01" then
         locker <= locker+1;
         lr_tempout <= "01";     
         
         elsif lr_flag ="00" then
         lr_tempout <= "00";
         locker <=0;
         
         end if;

         if locker=10000 then
           lr_flag <="00";
           locker<=0;
         end if;
    end if;

end process debounce;	

--pushbutton:	process (clk)
--	begin
--	if rising_edge(clk) then  
--		   if push_input = '0' then
--				push_input <= '1';
--			else 
--				push_input <= '0';
--			end if;
--		 
--   end if;
--end process pushbutton;	


end rot;
