-------------------------------------------------------------------------------
--
-- Simple VGA raster display
--
-- Stephen A. Edwards
-- sedwards@cs.columbia.edu
--
-------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

entity de2_vga_raster is 
  port (
    reset_n : in std_logic;
    clk   : in std_logic;                    -- Should be 25.125 MHz
	 
	 --SRAM_DQ : in std_logic_vector(15 downto 0);
    --SRAM_ADDR : in std_logic_vector(17 downto 0);
    --SRAM_UB_N, SRAM_LB_N : in std_logic;
    --SRAM_WE_N, SRAM_CE_N : in std_logic;
    --SRAM_OE_N            : in std_logic
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  std_logic_vector(4 downto 0);
    readdata   : out std_logic_vector(15 downto 0);
    writedata  : in  std_logic_vector(15 downto 0);

    VGA_CLK,                         -- Clock
    VGA_HS,                          -- H_SYNC
    VGA_VS,                          -- V_SYNC
    VGA_BLANK,                       -- BLANK
    VGA_SYNC : out std_logic;        -- SYNC
    VGA_R,                           -- Red[9:0]
    VGA_G,                           -- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0) -- Blue[9:0]
    );

end de2_vga_raster;

architecture rtl of de2_vga_raster is
  
  -- Video parameters
  
  constant HTOTAL       : integer := 800;
  constant HSYNC        : integer := 96;
  constant HBACK_PORCH  : integer := 48;
  constant HACTIVE      : integer := 640;
  constant HFRONT_PORCH : integer := 16;
  
  constant VTOTAL       : integer := 525;
  constant VSYNC        : integer := 2;
  constant VBACK_PORCH  : integer := 33;
  constant VACTIVE      : integer := 480;
  constant VFRONT_PORCH : integer := 10;
  
  
--  constant x       : integer := 300;    --the coodination of circle
--  constant y       : integer := 300;
  
--  type cir_pix is array (0 to 14) of
--       std_logic_vector(0 to 14);  
--  constant cir_pixel: cir_pix :=
--(
--('0','0','0','0','0','1','1','1','1','1','0','0','0','0','0'),
--('0','0','0','1','1','1','1','1','1','1','1','1','0','0','0'),
--('0','0','1','1','1','1','1','1','1','1','1','1','1','0','0'),
--('0','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
--('0','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
--('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
--('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
--('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
--('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
--('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
--('0','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
--('0','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
--('0','0','1','1','1','1','1','1','1','1','1','1','1','0','0'),
--('0','0','0','1','1','1','1','1','1','1','1','1','0','0','0'),
--('0','0','0','0','0','1','1','1','1','1','0','0','0','0','0')
--);

constant brick_layout: std_logic_vector(0 to 127) :=  ---bricklayout= 16*8
(
'0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0',
'0','0','1','1','1','1','0','1','1','1','1','1','1','1','0','0',
'0','0','1','1','0','1','1','1','1','1','1','0','1','1','0','0',
'0','0','1','1','1','0','1','1','1','1','1','1','1','1','0','0',
'0','0','1','1','1','0','1','1','1','1','1','1','1','1','0','0',
'0','0','1','1','0','0','1','1','1','1','1','1','0','1','0','0',
'0','0','1','1','1','1','1','1','1','0','1','1','1','1','0','0'
);


constant circle_pix: std_logic_vector(0 to 224) :=
(
'0','0','0','0','0','1','1','1','1','1','0','0','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','0','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','0','0','0',
'0','0','0','0','0','1','1','1','1','1','0','0','0','0','0'
);


constant board_pix: std_logic_vector(0 to 942) :=
(
'0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0',
'0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0'
);


type shape is array (0 to 22) of
       std_logic_vector(0 to 40);  
constant board_pixel: shape := 
(
('0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0'),
('0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0'),
('0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0'),
('0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
('0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
('0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
('0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
('0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
('0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
('0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0'),
('0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0'),
('0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0'),
('0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0'),
('0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0'),
('0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0'),
('0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0'),
('0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0')
);


constant brick1_pix: std_logic_vector(0 to 799) :=
(
'0','0','0','0','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','1','0','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','0','0',
'0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0'
);

constant brick2_pix: std_logic_vector(0 to 799) :=
(
'0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','1','1','1','0','0','1','1','1','1','1','1','1','1','1','0','0','0','1','1','0','0','0'
);



type RGB is array (0 to 255) of
       integer;  
  constant R: RGB :=
(255,255,70,199,102,142,223,37,255,255,255,255,255,255,255,255,
255,255,255,65,129,93,118,157,23,25,37,16,255,255,255,255,
255,255,9,53,83,120,204,155,141,153,172,115,63,10,255,255,
255,255,138,142,124,162,186,195,191,183,155,130,157,142,255,255,
255,156,109,99,154,155,148,150,151,149,150,152,106,125,164,255,
178,145,62,121,133,150,159,161,159,155,142,132,131,79,158,179,
205,62,82,120,139,150,152,158,135,144,158,133,78,90,73,211,
135,31,77,84,82,89,83,95,60,49,122,96,35,57,56,151,
121,26,34,42,67,87,99,107,71,18,92,70,26,42,46,121,
122,24,42,72,100,114,122,132,107,82,115,95,75,60,26,118,
157,30,64,93,120,132,143,149,154,162,130,115,93,51,24,170,
120,80,75,108,126,145,166,179,179,164,145,127,108,62,79,129,
7,176,71,135,135,154,185,210,210,185,153,137,127,60,181,8,
8,114,146,98,162,184,197,221,225,197,185,159,95,153,117,8,
0,0,108,168,108,151,207,229,230,207,151,108,175,114,0,0,
0,0,2,19,100,176,133,141,141,133,175,101,20,2,0,0
);


  constant G: RGB :=
(255,255,70,209,141,168,228,40,255,255,255,255,255,255,255,255,
255,255,255,67,153,141,155,182,31,32,40,17,255,255,255,255,
255,255,9,58,103,160,225,187,173,182,193,133,68,10,255,255,
255,255,144,173,166,199,217,223,223,216,192,169,184,146,255,255,
255,158,151,157,199,202,195,196,196,194,198,200,162,160,164,255,
178,176,133,184,187,195,203,204,210,206,190,186,197,152,184,178,
217,126,155,180,195,203,205,209,187,194,211,192,121,145,136,221,
165,123,167,172,177,185,191,199,113,61,200,198,67,73,129,179,
158,129,152,158,182,198,208,218,155,24,177,199,90,71,128,159,
158,127,160,181,205,223,231,240,202,127,212,211,177,161,127,155,
183,122,183,205,228,239,244,245,248,255,240,222,203,177,119,191,
126,141,190,218,234,244,245,246,246,245,244,235,218,180,139,133,
7,196,153,239,243,244,246,249,249,246,244,243,236,148,199,8,
8,114,175,179,250,255,250,251,251,250,255,249,176,179,117,8,
0,0,110,193,164,209,248,255,255,248,209,165,195,113,0,0,
0,0,2,21,113,195,165,172,172,165,195,113,22,2,0,0
);



 constant B: RGB :=
(255,255,70,217,174,192,234,42,255,255,255,255,255,255,255,255,
255,255,255,67,175,178,187,203,39,37,43,19,255,255,255,255,
255,255,10,62,123,189,240,211,200,205,211,148,71,10,255,255,
255,255,149,198,197,223,236,241,241,235,217,198,206,151,255,255,
255,162,183,197,227,228,222,223,222,221,225,229,200,189,165,255,
179,201,182,218,216,222,227,228,235,231,219,216,232,199,205,178,
227,170,201,216,224,228,229,232,206,213,236,219,137,173,178,231,
189,173,208,212,215,222,227,232,128,67,233,237,78,82,177,200,
187,184,203,207,222,232,237,245,173,26,201,245,113,86,179,189,
187,181,209,222,235,244,249,254,213,133,231,243,212,202,183,184,
203,172,224,236,248,253,255,255,255,255,255,242,235,223,171,210,
132,179,228,243,251,255,253,254,254,253,255,251,243,221,178,138,
8,214,192,254,255,254,253,252,252,253,254,255,255,188,216,8,
8,115,199,208,255,255,254,252,253,254,255,255,206,202,117,8,
0,0,112,211,192,225,253,255,255,253,225,192,213,115,0,0,
0,0,2,23,124,211,189,194,194,189,211,124,23,2,0,0
);



type RGB_Board is array (0 to 942) of
       integer;  
  constant R_Board: RGB_Board :=
(255,255,255,255,255,255,255,148,139,139,139,139,143,157,152,128,168,170,170,159,110,134,130,121,139,157,139,121,116,103,121,121,121,139,152,255,255,255,255,255,255,
255,255,255,255,152,112,115,148,170,148,116,85,85,103,110,233,255,255,255,255,223,95,159,191,98,141,201,212,223,255,255,212,148,85,94,134,255,255,255,255,255,
255,255,255,139,132,223,255,255,255,255,255,244,212,138,106,255,255,255,255,255,255,255,255,233,170,255,255,255,255,255,255,255,255,233,159,95,125,139,139,255,255,
255,255,139,108,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,244,180,212,170,112,255,
255,152,97,197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,113,255,
255,121,149,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,212,103,255,
255,89,191,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,201,127,116,255,
130,117,210,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,244,116,121,255,
112,152,210,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,89,255,
103,172,210,218,255,255,255,255,255,255,159,127,191,255,255,255,255,255,255,255,255,255,255,255,255,255,223,95,63,79,255,255,255,255,255,255,255,255,255,148,130,
103,178,210,210,235,255,255,255,255,143,255,95,47,239,255,255,255,255,255,255,255,255,255,255,255,255,143,255,111,0,143,255,255,255,255,255,255,255,255,212,107,
116,178,210,210,210,221,238,255,255,31,175,47,0,191,255,239,191,255,255,159,255,255,159,63,255,255,63,127,47,0,127,255,255,255,255,255,255,255,255,180,116,
134,147,210,210,210,210,210,215,226,71,0,0,31,239,255,191,191,255,95,95,143,191,143,79,255,255,175,15,0,47,239,255,255,255,255,255,255,255,252,111,143,
255,133,210,210,210,210,210,210,210,183,118,105,181,255,255,239,127,127,239,255,175,127,127,223,255,255,255,223,191,239,243,255,255,255,255,255,255,252,187,98,255,
255,130,194,210,210,210,210,210,210,210,210,210,210,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,252,212,218,246,255,255,255,246,207,108,139,255,
255,255,133,210,210,210,210,210,210,210,210,210,210,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,210,210,210,194,203,210,186,112,130,255,255,
255,255,134,131,210,210,210,210,210,210,210,210,210,210,226,232,232,232,249,255,255,255,240,243,255,255,255,246,221,210,210,210,210,109,103,103,107,143,255,255,255,
255,255,255,112,108,178,210,210,210,210,210,210,210,210,210,210,210,210,226,243,243,232,210,210,210,210,210,210,210,210,210,210,147,148,255,255,255,255,255,255,255,
255,255,255,255,116,85,108,116,202,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,186,110,255,255,255,255,255,255,255,255,
255,255,255,255,255,148,139,98,186,210,210,194,186,210,210,210,210,210,210,210,210,210,186,186,210,210,210,210,210,210,191,105,143,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,125,139,210,210,131,116,210,210,210,210,210,210,210,210,178,120,101,131,178,178,178,178,147,101,143,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,152,107,103,103,121,121,112,178,210,210,210,194,147,100,112,148,255,125,112,103,103,103,130,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,148,116,103,103,103,116,139,143,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);

constant G_Board: RGB_Board :=
(255,255,255,255,255,255,255,189,182,182,182,182,185,197,193,170,196,196,196,188,155,178,174,167,182,197,182,167,163,152,167,167,167,182,193,255,255,255,255,255,255,
255,255,255,255,193,159,159,181,196,181,159,137,137,152,155,240,255,255,255,255,232,144,188,210,148,177,218,225,232,255,255,225,181,137,144,178,255,255,255,255,255,
255,255,255,182,170,232,255,255,255,255,255,247,225,173,151,255,255,255,255,255,255,255,255,240,196,255,255,255,255,255,255,255,255,240,188,144,170,182,182,255,255,
255,255,182,155,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,247,203,225,196,159,255,
255,193,147,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,159,255,
255,167,184,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,225,152,255,
255,140,222,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,218,166,163,255,
174,163,237,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,247,159,167,255,
159,190,237,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,232,140,255,
152,207,237,240,255,255,255,255,255,255,159,127,191,255,255,255,255,255,255,255,255,255,255,255,255,255,223,95,63,79,255,255,255,255,255,255,255,255,255,181,174,
152,212,237,237,247,255,255,255,255,143,255,95,47,239,255,255,255,255,255,255,255,255,255,255,255,255,143,255,111,0,143,255,255,255,255,255,255,255,255,225,155,
163,212,237,237,237,241,248,255,255,31,175,47,0,191,255,239,191,255,255,159,255,255,159,63,255,255,63,127,47,0,127,255,255,255,255,255,255,255,255,203,163,
178,187,237,237,237,237,237,239,243,76,0,0,31,239,255,191,191,255,95,95,143,191,143,79,255,255,175,15,0,47,239,255,255,255,255,255,255,255,253,156,185,
255,175,237,237,237,237,237,237,237,207,133,118,197,255,255,239,127,127,239,255,175,127,127,223,255,255,255,223,191,239,250,255,255,255,255,255,255,253,215,148,255,
255,174,224,237,237,237,237,237,237,237,237,237,237,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,238,240,251,255,255,255,251,233,155,182,255,
255,255,175,237,237,237,237,237,237,237,237,237,237,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,237,237,237,224,232,237,218,159,174,255,255,
255,255,178,174,237,237,237,237,237,237,237,237,237,237,243,246,246,246,252,255,255,255,249,250,255,255,255,251,241,237,237,237,237,157,152,152,155,185,255,255,255,
255,255,255,159,155,212,237,237,237,237,237,237,237,237,237,237,237,237,243,250,250,246,237,237,237,237,237,237,237,237,237,237,187,189,255,255,255,255,255,255,255,
255,255,255,255,163,137,155,162,230,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,218,158,255,255,255,255,255,255,255,255,
255,255,255,255,255,189,182,148,218,237,237,224,218,237,237,237,237,237,237,237,237,237,218,218,237,237,237,237,237,237,222,153,185,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,170,180,237,237,174,162,237,237,237,237,237,237,237,237,212,165,150,174,212,212,212,212,187,150,185,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,193,155,152,152,167,167,159,212,237,237,237,224,187,149,159,189,255,170,159,152,152,152,174,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,189,163,152,152,152,163,182,185,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);


constant B_Board: RGB_Board :=
(255,255,255,255,255,255,255,234,234,234,234,234,234,234,234,236,243,244,244,243,236,234,234,234,234,234,234,234,234,234,234,234,234,234,234,255,255,255,255,255,255,
255,255,255,255,234,234,236,241,244,241,237,234,234,234,236,252,255,255,255,255,251,235,243,247,234,239,248,249,251,255,255,249,241,234,234,234,255,255,255,255,255,
255,255,255,234,239,251,255,255,255,255,255,253,249,240,236,255,255,255,255,255,255,255,255,252,244,255,255,255,255,255,255,255,255,252,243,235,234,234,234,255,255,
255,255,234,237,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,245,249,244,234,255,
255,234,235,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,235,255,
255,234,229,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,249,234,255,
255,234,247,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,248,239,234,255,
234,237,251,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,237,234,255,
234,242,251,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,251,234,255,
234,244,251,251,255,255,255,255,255,255,159,127,191,255,255,255,255,255,255,255,255,255,255,255,255,255,223,95,63,79,255,255,255,255,255,255,255,255,255,241,234,
234,246,251,251,253,255,255,255,255,143,255,95,47,239,255,255,255,255,255,255,255,255,255,255,255,255,143,255,111,0,143,255,255,255,255,255,255,255,255,249,234,
234,246,251,251,251,252,253,255,255,31,175,47,0,191,255,239,191,255,255,159,255,255,159,63,255,255,63,127,47,0,127,255,255,255,255,255,255,255,255,245,234,
234,242,251,251,251,251,251,251,252,78,0,0,31,239,255,191,191,255,95,95,143,191,143,79,255,255,175,15,0,47,239,255,255,255,255,255,255,255,254,237,234,
255,239,251,251,251,251,251,251,251,219,141,125,204,255,255,239,127,127,239,255,175,127,127,223,255,255,255,223,191,239,254,255,255,255,255,255,255,254,247,234,255,
255,234,248,251,251,251,251,251,251,251,251,251,251,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,251,251,254,255,255,255,254,250,237,234,255,
255,255,239,251,251,251,251,251,251,251,251,251,251,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,252,251,251,251,248,248,251,247,237,234,255,255,
255,255,234,240,251,251,251,251,251,251,251,251,251,251,252,253,253,253,254,255,255,255,253,254,255,255,255,254,252,251,251,251,251,236,234,234,234,234,255,255,255,
255,255,255,234,237,246,251,251,251,251,251,251,251,251,251,251,251,251,252,254,254,253,251,251,251,251,251,251,251,251,251,251,242,234,255,255,255,255,255,255,255,
255,255,255,255,234,234,237,238,249,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,247,235,255,255,255,255,255,255,255,255,
255,255,255,255,255,234,234,234,247,251,251,248,247,251,251,251,251,251,251,251,251,251,247,247,251,251,251,251,251,251,247,236,234,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,234,241,251,251,240,238,251,251,251,251,251,251,251,251,246,238,235,240,246,246,246,246,242,235,234,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,234,234,234,234,234,234,237,246,251,251,251,248,242,236,234,234,255,234,234,234,234,234,234,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,234,234,234,234,234,234,234,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);


type RGB_Brick1 is array (0 to 799) of
       integer;  
  constant R_Brick1: RGB_Brick1 :=
(255,255,255,250,220,221,222,222,222,222,222,220,219,219,175,228,228,224,217,220,220,224,233,235,235,235,235,233,224,220,255,255,255,255,255,255,255,255,255,255,
255,255,218,222,238,246,251,251,251,251,251,244,234,224,251,251,251,251,230,225,238,248,251,250,250,250,250,251,249,236,216,218,220,223,223,223,223,223,255,255,
255,217,226,249,251,250,249,249,249,249,249,250,251,252,249,249,249,249,250,246,251,250,249,249,249,249,249,249,249,251,231,234,246,253,253,253,253,251,226,255,
241,218,240,249,249,249,250,248,246,247,250,249,249,249,249,250,250,250,249,250,249,249,250,250,250,250,250,249,246,244,247,250,250,249,249,249,249,249,228,255,
216,226,247,249,250,250,250,255,255,255,244,247,250,250,250,250,250,250,249,249,250,250,250,250,250,250,247,245,255,255,255,249,249,250,250,250,250,249,231,255,
221,232,245,250,249,250,250,205,172,194,255,253,245,249,250,250,250,250,250,250,250,250,250,250,249,245,254,255,197,122,156,246,250,250,250,250,250,250,222,255,
219,227,244,248,250,249,250,223,203,133,110,212,255,250,247,250,250,250,250,250,250,250,250,249,248,255,211,76,40,134,224,255,248,250,250,250,250,239,218,255,
222,230,243,244,249,250,249,255,178,62,5,13,91,233,255,250,250,250,250,250,250,250,250,252,247,113,27,26,35,84,73,134,255,250,250,250,250,245,221,227,
240,242,244,243,245,249,252,108,180,229,231,217,179,76,124,250,250,250,250,250,250,250,250,207,79,52,205,238,237,225,215,144,168,250,250,250,250,250,241,217,
244,244,244,244,243,244,198,137,254,255,255,255,255,168,206,250,249,250,250,250,250,250,249,216,202,160,255,255,255,255,255,254,104,250,250,250,250,249,250,222,
243,243,244,244,243,243,87,233,253,252,252,252,253,223,187,248,252,250,249,248,249,250,251,255,158,180,255,253,251,251,254,236,83,250,250,250,250,249,250,225,
244,243,244,244,244,244,144,193,255,255,255,255,255,136,213,255,237,247,254,255,248,247,243,229,201,116,233,255,255,255,255,153,192,249,249,249,249,250,249,219,
242,243,243,243,243,244,242,97,188,206,206,206,206,141,253,223,213,255,236,210,255,255,250,127,254,213,159,174,181,181,173,152,255,250,250,250,249,249,244,217,
227,245,244,244,243,244,242,207,126,160,160,160,158,251,245,105,179,182,159,122,161,184,198,83,249,254,228,130,116,116,153,252,248,249,248,249,250,250,230,219,
218,232,241,242,243,244,243,250,255,255,255,255,255,241,243,156,137,152,199,216,154,142,133,139,247,244,250,255,255,255,255,249,249,245,243,245,246,245,217,221,
217,214,219,225,230,243,243,241,239,240,240,240,240,243,244,243,227,253,254,250,255,245,228,246,243,243,242,240,241,241,243,245,245,246,243,243,243,242,219,221,
255,244,242,215,222,244,243,243,243,243,243,243,243,243,243,244,249,243,241,241,240,246,249,243,243,243,243,243,243,243,243,244,244,229,244,244,244,245,222,218,
255,255,255,255,216,234,243,245,244,244,244,244,244,244,245,243,228,234,245,245,241,225,227,244,245,244,244,244,244,244,245,237,225,215,223,237,239,234,216,255,
255,255,255,255,255,220,220,228,232,232,232,232,232,230,223,221,219,219,221,221,221,218,219,221,229,232,232,232,232,230,223,219,219,255,255,221,221,220,255,255,
255,255,255,255,255,255,250,220,220,220,220,220,220,220,255,255,255,255,255,255,255,255,255,255,219,220,220,220,220,219,219,255,255,255,255,255,255,255,255,255);

 constant G_Brick1: RGB_Brick1 :=
(255,255,255,234,157,133,122,122,122,122,122,117,132,170,111,121,121,107,100,175,149,119,143,150,150,150,150,143,113,141,255,255,255,255,255,255,255,255,255,255,
255,255,150,104,155,192,214,214,214,214,214,186,143,99,200,214,214,215,129,104,156,200,213,212,212,212,212,213,207,149,138,171,114,123,123,123,123,164,255,255,
255,172,105,207,214,210,207,207,207,207,207,210,216,221,209,207,207,207,210,193,214,209,207,208,208,208,208,207,208,215,127,137,193,219,219,219,219,207,142,255,
224,86,163,208,207,208,209,207,206,206,209,208,207,205,208,209,209,209,207,210,207,208,209,209,209,209,209,208,206,202,211,213,210,206,206,206,206,208,118,255,
148,106,188,207,209,209,209,216,220,216,204,207,209,209,209,209,209,209,208,208,209,209,209,209,209,209,207,205,215,228,221,207,208,209,209,209,209,208,135,255,
149,126,174,211,208,209,209,171,143,162,225,212,205,208,209,209,209,209,209,209,209,209,209,209,208,205,212,220,165,102,130,205,209,209,209,209,209,208,99,255,
160,111,163,193,208,208,209,186,170,112,93,178,224,209,207,209,209,209,209,209,209,209,209,208,208,221,176,63,33,111,187,220,207,209,209,209,209,167,120,255,
107,119,161,169,208,209,208,221,147,50,2,8,74,194,216,209,209,209,209,209,209,209,209,211,206,94,22,28,35,77,63,110,213,209,209,209,209,188,114,211,
146,158,162,161,174,204,211,98,178,229,230,218,179,69,103,209,209,209,209,209,209,209,209,172,66,50,206,238,237,227,218,143,140,209,209,209,209,210,173,133,
164,163,162,161,161,163,156,138,254,255,255,255,255,169,172,209,208,209,209,209,209,209,208,180,168,160,255,255,255,255,255,255,94,209,209,209,209,208,210,96,
161,161,162,162,162,161,61,233,253,252,252,252,253,223,156,207,211,209,208,207,208,209,209,214,131,181,255,252,251,251,254,237,69,209,209,209,209,208,209,109,
163,161,162,162,162,162,97,195,255,255,255,255,255,136,177,215,198,206,212,217,207,206,203,192,168,111,234,255,255,255,255,152,160,208,208,208,208,209,206,84,
157,160,161,161,161,162,162,79,193,214,214,214,207,126,213,186,176,221,196,175,217,220,207,105,212,179,147,173,181,181,170,131,213,209,211,209,208,207,187,80,
108,167,163,162,161,162,161,136,89,127,127,127,115,189,183,86,152,155,135,105,137,157,168,73,212,211,190,104,92,92,124,209,207,207,195,206,212,214,128,133,
91,122,156,160,161,162,161,166,176,169,169,169,171,156,158,106,99,110,151,166,106,101,96,98,185,176,186,226,235,234,228,212,208,184,163,176,183,181,81,201,
170,88,79,92,119,161,161,160,159,161,161,161,160,162,163,160,148,169,171,168,173,160,148,162,157,158,157,170,181,183,185,180,175,171,161,158,157,153,90,191,
255,219,199,145,93,165,161,161,161,161,161,161,161,161,160,162,170,163,158,159,160,170,171,160,162,162,162,158,160,161,160,160,161,112,165,165,164,167,95,169,
255,255,255,255,93,127,161,165,164,164,164,164,164,164,166,159,113,133,167,166,150,99,108,166,165,164,164,165,164,164,166,143,96,117,99,140,144,127,93,255,
255,255,255,255,255,140,95,111,125,125,125,125,125,120,98,117,138,112,89,96,123,157,137,89,116,125,125,125,125,120,98,106,186,255,255,150,144,147,255,255,
255,255,255,255,255,255,236,176,141,141,141,141,148,185,255,255,255,255,255,255,255,255,255,255,162,141,141,141,141,140,166,255,255,255,255,255,255,255,255,255);

 constant B_Brick1: RGB_Brick1 :=
(255,255,255,245,214,203,197,197,197,197,197,194,202,221,157,197,197,189,186,223,210,195,208,212,212,212,212,208,192,206,255,255,255,255,255,255,255,255,255,255,
255,255,212,189,215,234,246,246,246,246,246,231,209,186,240,246,246,246,201,188,215,238,245,245,245,245,245,245,241,212,205,222,193,198,198,198,198,218,255,255,
255,222,189,242,246,243,242,242,242,242,242,243,246,249,242,242,242,242,243,235,246,243,242,242,242,242,242,242,242,246,200,204,234,248,248,248,248,241,208,255,
243,178,223,242,242,242,243,241,240,240,243,242,242,241,242,243,243,243,242,243,242,242,243,243,243,243,243,242,239,237,242,245,243,241,241,241,241,242,195,255,
211,193,237,242,243,243,243,251,255,251,237,240,243,243,243,243,243,243,242,242,243,243,243,243,243,243,240,238,250,255,255,242,242,243,243,243,243,242,204,255,
210,206,232,243,242,243,243,199,167,188,255,246,238,242,243,243,243,243,243,243,243,243,243,243,242,239,247,255,191,119,151,239,243,243,243,243,243,242,185,255,
216,197,230,238,242,242,243,217,197,129,107,207,255,243,241,243,243,243,243,243,243,243,243,242,241,255,205,74,39,130,217,255,241,243,243,243,243,220,196,255,
191,202,229,231,242,243,242,255,172,60,5,12,87,227,251,243,243,243,243,243,243,243,243,245,240,109,26,26,35,83,71,130,248,243,243,243,243,232,193,240,
220,227,230,229,233,241,245,107,179,229,231,217,179,75,120,243,243,243,243,243,243,243,243,201,76,52,205,238,237,225,215,143,163,243,243,243,243,243,224,203,
231,230,230,230,229,230,191,137,254,255,255,255,255,169,201,243,242,243,243,243,243,243,242,210,196,160,255,255,255,255,255,255,102,243,243,243,243,243,243,184,
229,229,230,230,230,229,82,233,253,252,252,252,253,223,182,241,245,243,242,241,242,243,244,249,153,180,255,252,251,251,254,237,80,243,243,243,243,242,243,190,
230,229,230,230,230,230,135,193,255,255,255,255,255,136,207,250,230,240,246,252,241,240,236,223,195,116,233,255,255,255,255,153,187,242,242,242,242,243,241,178,
226,229,229,229,229,230,228,95,189,208,208,208,206,139,246,216,206,255,229,204,254,255,242,123,247,208,156,174,181,181,173,148,248,243,243,243,242,242,231,176,
194,233,231,230,229,230,229,196,120,154,154,154,151,240,234,102,175,177,155,120,157,180,193,81,242,246,221,125,112,112,148,244,241,242,239,241,243,244,200,202,
180,203,225,228,230,230,229,235,251,244,244,244,244,227,229,148,130,145,190,208,145,135,127,132,236,232,239,255,255,255,255,243,242,235,230,233,235,234,176,236,
222,180,178,185,202,229,229,228,225,227,227,227,227,229,230,229,213,239,240,236,247,230,214,232,228,229,227,228,231,232,233,234,233,235,229,228,228,226,181,231,
255,239,229,208,184,232,229,229,229,229,229,229,229,229,229,230,237,230,226,227,227,235,237,228,229,229,229,228,229,229,229,229,230,197,231,231,231,233,185,222,
255,255,255,255,184,208,229,232,231,231,231,231,231,231,232,228,197,211,233,233,222,188,194,232,232,231,231,231,231,231,232,218,187,195,189,216,219,207,183,255,
255,255,255,255,255,206,185,196,206,206,206,206,206,202,187,195,204,192,182,185,198,214,204,182,200,206,206,206,206,202,187,190,229,255,255,212,209,210,255,255,
255,255,255,255,255,255,245,224,206,206,206,206,210,228,255,255,255,255,255,255,255,255,255,255,217,206,206,206,206,205,218,255,255,255,255,255,255,255,255,255);

 constant R_Brick2: RGB_Brick1 :=
(
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,227,218,221,218,255,255,218,220,224,208,179,228,216,231,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,214,220,223,228,228,228,228,225,221,216,219,234,238,236,224,215,218,227,241,244,244,246,244,243,230,214,255,255,255,255,255,255,255,255,255,255,
255,255,255,215,231,246,252,251,252,252,251,252,251,236,241,250,251,251,245,229,242,252,249,250,250,249,249,250,251,238,218,219,227,229,230,229,231,223,255,255,
255,255,214,227,253,249,248,249,249,249,249,249,249,251,251,249,249,248,250,249,250,249,249,249,249,249,249,249,249,248,238,245,254,252,252,252,253,242,217,255,
255,235,219,240,249,248,250,249,250,250,249,250,249,249,249,249,250,250,249,249,249,250,250,250,250,250,249,250,249,250,251,250,249,249,249,248,249,239,220,255,
255,216,223,245,249,248,250,250,250,250,250,250,250,250,250,250,250,249,250,249,249,250,249,250,250,250,250,249,250,249,249,249,250,249,249,249,249,241,221,255,
255,220,226,244,248,249,249,249,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,249,251,229,215,255,
255,219,220,245,244,250,248,250,250,250,250,250,250,249,249,250,250,250,250,250,250,250,250,250,250,249,249,249,250,250,250,249,249,249,249,249,249,218,245,255,
223,221,235,244,243,247,250,249,249,249,249,249,249,250,250,249,250,250,250,250,250,250,250,249,249,250,251,249,249,249,249,250,250,250,249,249,249,237,224,255,
217,239,244,243,243,244,245,249,255,254,255,254,252,251,250,249,249,250,249,250,250,250,249,250,250,247,248,255,255,255,255,252,247,249,250,249,249,251,222,221,
219,244,244,243,242,247,227,201,230,227,227,231,241,226,241,252,248,248,248,248,248,248,247,248,251,212,151,210,230,226,232,209,204,242,251,249,248,250,234,219,
219,244,243,244,243,244,240,176,126,146,137,162,195,190,235,249,252,255,255,255,255,255,255,255,255,242,154,109,148,142,138,167,236,253,248,250,249,250,234,221,
220,242,243,243,244,243,243,253,255,255,255,255,255,255,254,214,219,222,200,198,198,198,198,201,233,252,255,255,255,255,255,255,251,249,250,250,248,251,225,217,
216,230,244,242,243,243,243,241,242,245,245,246,246,249,235,155,201,207,173,177,181,180,179,173,173,255,244,246,247,247,247,247,249,250,250,249,249,249,219,232,
235,221,240,245,244,244,243,243,243,244,245,245,242,254,175,173,218,238,232,201,190,189,192,171,128,254,245,250,249,249,249,249,249,247,247,247,250,234,217,255,
255,215,223,234,237,238,244,243,244,243,243,243,240,252,178,156,219,247,238,212,203,202,205,179,97,255,240,247,249,250,249,248,246,243,242,243,246,225,218,255,
255,255,214,215,217,226,244,242,243,244,244,244,243,244,236,208,205,171,158,163,166,166,163,145,159,251,241,244,245,245,244,244,243,243,242,242,243,230,218,255,
255,255,255,247,239,219,245,243,242,244,244,244,244,243,245,254,232,216,209,208,208,206,204,207,236,244,243,243,243,242,242,245,231,228,242,244,245,230,217,255,
255,255,255,255,255,216,227,237,243,243,243,244,243,244,241,237,229,229,242,246,243,228,229,244,244,243,243,243,243,243,238,226,219,218,225,231,230,220,218,255,
255,255,255,255,255,255,216,219,221,225,224,225,224,225,221,219,255,255,217,217,217,255,255,216,219,225,224,224,225,222,219,217,255,255,255,226,215,255,255,255
);

 constant G_Brick2: RGB_Brick1 :=
(255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,195,169,171,170,255,255,180,157,149,136,108,153,141,185,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,155,131,116,124,121,121,124,111,98,109,141,154,154,151,98,118,123,127,172,184,184,186,185,178,116,121,255,255,255,255,255,255,255,255,255,255,
255,255,255,124,125,192,222,217,219,219,218,220,217,153,167,213,215,215,192,121,176,219,211,211,211,210,210,211,218,160,125,127,113,126,128,125,147,173,255,255,
255,255,152,116,225,208,205,207,206,206,206,206,206,217,215,207,207,206,210,209,212,206,207,208,208,208,208,206,208,203,158,184,228,221,221,220,223,161,159,255,
255,217,87,162,209,206,209,208,209,209,208,209,208,206,207,208,209,209,208,208,207,209,209,209,209,209,208,209,208,209,218,213,205,206,206,204,209,166,153,255,
255,169,95,181,210,208,209,209,209,209,209,209,209,209,209,209,209,208,209,208,208,209,208,209,209,209,209,208,209,208,206,207,209,208,208,207,211,170,176,255,
255,185,103,171,208,207,208,208,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,205,218,117,168,255,
255,167,87,165,178,212,206,209,209,209,209,209,209,208,208,209,209,209,209,209,209,209,209,209,209,208,208,208,209,209,209,208,208,208,208,207,206,93,230,255,
191,99,136,161,164,199,210,208,208,208,208,208,208,209,209,208,209,209,209,209,209,209,209,208,208,209,210,208,208,208,208,209,209,209,208,207,210,159,154,255,
137,147,163,161,160,166,189,206,214,212,213,212,211,210,209,208,208,209,208,209,209,209,208,209,209,206,207,214,213,213,214,210,206,208,209,208,207,215,108,197,
101,162,162,162,160,163,152,156,194,190,190,193,200,189,200,211,207,208,207,207,207,207,206,207,210,176,126,175,193,189,193,174,171,203,210,208,206,213,143,173,
86,163,162,162,161,161,162,134,107,121,114,135,163,158,196,206,209,213,218,218,218,218,218,217,214,203,129,91,123,118,114,139,197,211,208,209,207,211,143,176,
124,157,160,161,162,162,159,185,225,219,219,217,214,214,212,186,188,188,168,165,165,166,165,169,196,209,216,222,219,219,220,216,210,207,208,208,206,216,111,165,
154,122,164,159,160,161,160,162,182,200,204,205,205,206,187,148,201,203,170,174,178,177,177,170,151,216,205,204,206,206,206,206,207,212,212,210,207,211,84,198,
216,95,155,168,165,163,162,161,159,171,178,177,175,186,119,164,219,238,232,201,189,189,191,171,111,210,201,212,207,207,207,208,211,192,189,199,211,147,122,255,
255,138,86,130,140,148,163,161,162,160,158,158,156,166,111,147,227,249,238,212,203,203,205,185,87,178,171,197,211,213,211,204,192,164,159,168,181,99,162,255,
255,255,131,91,95,107,164,159,161,162,162,162,162,163,157,140,163,154,149,155,157,157,154,126,112,164,158,166,175,175,173,170,165,161,160,158,161,116,138,255,
255,255,255,228,196,89,166,161,160,162,162,162,162,161,163,168,151,145,139,138,137,135,130,132,155,162,162,160,158,157,157,166,121,112,158,165,169,117,138,255,
255,255,255,255,255,132,108,146,160,161,161,162,161,162,157,148,112,103,140,149,143,95,95,145,160,161,161,161,161,161,146,110,127,143,120,123,120,107,187,255,
255,255,255,255,255,255,163,113,100,105,104,105,104,109,113,129,255,255,115,110,142,255,255,103,98,106,104,104,107,95,93,157,255,255,255,180,161,255,255,255);


 constant B_Brick2: RGB_Brick1 :=
(255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,231,221,222,221,255,255,226,214,212,195,160,216,206,224,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,214,202,194,199,197,197,199,192,186,191,206,214,213,213,185,195,198,199,222,230,230,232,230,227,194,197,255,255,255,255,255,255,255,255,255,255,
255,255,255,198,199,233,249,247,248,248,247,249,247,213,220,245,246,246,234,196,225,248,243,244,244,243,243,244,247,217,198,201,193,200,201,199,211,224,255,255,
255,255,212,195,250,243,240,241,241,241,241,241,241,247,246,242,242,241,243,243,244,241,241,242,242,242,242,241,243,239,216,229,252,249,248,248,249,218,216,255,
255,240,180,224,242,241,243,242,243,243,242,243,242,241,242,242,243,243,242,242,242,243,243,243,243,243,242,243,242,243,247,245,241,241,241,240,243,220,212,255,
255,221,187,236,242,241,243,243,243,243,243,243,243,243,243,243,243,242,243,242,242,243,242,243,243,243,243,242,243,242,241,242,243,242,242,242,243,222,224,255,
255,228,192,233,241,242,242,242,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,241,247,194,221,255,
255,218,181,232,233,244,241,243,243,243,243,243,243,242,242,243,243,243,243,243,243,243,243,243,243,242,242,242,243,243,243,242,242,242,242,241,241,183,244,255,
230,188,213,230,229,239,243,242,242,242,242,242,242,243,243,242,243,243,243,243,243,243,243,242,242,243,244,242,242,242,242,243,243,243,242,242,243,216,212,255,
204,220,230,229,229,231,235,242,249,246,248,247,245,244,243,242,242,243,242,243,243,243,242,243,243,240,241,248,248,248,248,244,240,242,243,242,242,246,190,234,
186,230,230,229,228,232,214,192,224,221,221,225,234,219,234,245,241,242,241,241,241,241,240,241,244,206,147,203,224,219,225,202,199,236,244,242,241,245,208,222,
179,230,230,230,229,230,227,169,122,142,133,157,190,185,228,242,245,249,253,254,254,254,254,252,249,236,150,105,144,138,133,163,230,246,241,243,242,244,208,224,
197,226,229,229,230,229,229,241,255,254,255,253,249,248,246,209,213,216,195,192,193,193,192,195,227,244,252,255,254,255,255,252,244,242,242,242,241,246,191,219,
213,203,231,227,229,229,229,228,232,238,238,239,239,241,226,154,201,206,172,176,180,179,178,172,169,250,238,238,240,240,240,240,242,244,244,243,242,243,178,232,
239,184,224,234,231,231,229,229,229,232,234,233,231,243,165,172,219,238,232,201,190,189,192,172,126,253,237,243,242,242,242,242,243,238,237,239,244,210,197,255,
255,205,181,209,215,220,231,229,230,229,229,229,226,238,167,154,220,248,238,212,203,202,205,180,95,247,229,239,243,244,243,241,238,229,228,231,237,188,216,255,
255,255,201,182,184,193,231,228,229,230,230,230,229,230,223,196,198,168,157,162,164,165,162,141,151,237,227,231,233,233,232,231,231,229,228,228,230,201,205,255,
255,255,255,242,227,183,232,229,228,230,230,230,230,229,231,240,219,205,197,196,195,194,191,194,223,230,229,229,229,228,228,233,203,198,227,231,234,201,205,255,
255,255,255,255,255,202,193,218,228,229,229,230,229,230,227,219,198,195,219,225,221,190,191,222,229,228,229,229,229,229,219,195,200,207,200,204,202,190,229,255,
255,255,255,255,255,255,218,192,188,193,191,192,191,195,193,201,255,255,192,189,206,255,255,185,186,192,191,191,193,185,182,214,255,255,255,224,217,255,255,255);




  
--  constant RECTANGLE_HSTART : integer := x-15; 
--  constant RECTANGLE_HEND   : integer := x+14; 
--  constant RECTANGLE_VSTART : integer := y-14; 
--  constant RECTANGLE_VEND   : integer := y+15; 
 
    signal RECTANGLE_HSTART : unsigned(15 downto 0); 
    signal RECTANGLE_HEND   : unsigned(15 downto 0); 
    signal RECTANGLE_VSTART : unsigned(15 downto 0); 
    signal RECTANGLE_VEND   : unsigned(15 downto 0);
	 
	 signal RECTANGLE_HSTART_board : unsigned(15 downto 0);    ----to draw the board
    signal RECTANGLE_HEND_board   : unsigned(15 downto 0); 
    signal RECTANGLE_VSTART_board : unsigned(15 downto 0); 
    signal RECTANGLE_VEND_board   : unsigned(15 downto 0);
	 
	 
	 signal RECTANGLE_HSTART_brick1 : unsigned(15 downto 0);    ----to draw the board
    signal RECTANGLE_HEND_brick1   : unsigned(15 downto 0); 
    signal RECTANGLE_VSTART_brick1 : unsigned(15 downto 0); 
    signal RECTANGLE_VEND_brick1   : unsigned(15 downto 0);
	 
	 signal bg_change : std_logic_vector(9 downto 0);
	 signal brick_change : unsigned(15 downto 0);
	 signal timer: unsigned(31 downto 0);
	 signal brick_choose: std_logic;
	 
    signal count_H: unsigned(15 downto 0); --- use to draw brick arrays
    signal count_V: unsigned(15 downto 0);
-----------------------------ram-----------------------------------
type ram_type is array(15 downto 0) of
             std_logic_vector(15 downto 0);
signal RAM: ram_type :=(others=>("0000000100000000"));
signal ram_address: unsigned(3 downto 0);

signal x: unsigned(15 downto 0); --------coordinate of circle
signal y: unsigned(15 downto 0); --------coordinate of circle
signal x_board: unsigned(15 downto 0); --------coordinate of board

signal brick_x: unsigned(15 downto 0); --- coordination of bricks
signal brick_y: unsigned(15 downto 0);

-------------------------------------------------------------------

 -- Signals for the video controller
 
  signal Hcount : unsigned(9 downto 0);  -- Horizontal position (0-800)
  signal Vcount : unsigned(9 downto 0);  -- Vertical position (0-524)
  signal EndOfLine, EndOfField : std_logic;

  signal vga_hblank, vga_hsync,
    vga_vblank, vga_vsync : std_logic;  -- Sync. signals

  signal rectangle_h, rectangle_v, rectangle, circle : std_logic;  -- rectangle area    circle board and brick signal
  signal rectangle_h_board, rectangle_v_board, rectangle_board, board : std_logic;
  signal rectangle_h_brick1, rectangle_v_brick1, rectangle_brick1, brick1 : std_logic;
  signal temp : std_logic_vector(14 downto 0);
  signal temp_board : std_logic_vector(40 downto 0);

  signal feedback : std_logic ;       ---for random num generator
  signal lfsr_reg : std_logic_vector(128 - 1 downto 0) ;
  signal feedback2 : std_logic ;       ---for random num generator
  signal lfsr_reg2 : std_logic_vector(128 - 1 downto 0) ;
  signal feedback3 : std_logic ;       ---for random num generator
  signal lfsr_reg3 : std_logic_vector(128 - 1 downto 0) ;
  signal random_temp : std_logic_vector(128 - 1 downto 0) ;
  signal random_temp2 : std_logic_vector(128 - 1 downto 0) ;
  signal random_temp3 : std_logic_vector(128 - 1 downto 0) ;
  signal random_temp4 : std_logic_vector(128 - 1 downto 0) ;
  
begin
------------------------------ram_address initial----------------------
   ram_address <= unsigned(address(3 downto 0));
  --ram_address <= ('0','0','0','0');
-----------------------------------------------------------------------
  -- Horizontal and vertical counters
--RECTANGLE_HSTART <= x - 14;
--RECTANGLE_HEND <= x + 14;
--RECTANGLE_VSTART <= y - 14;
--RECTANGLE_VEND <= y + 14;
--RAM(0):ram_type:= "0000000001011111";
--RAM(2):= "0000000001011111";
---------------------------ram process---------------------------------
  forRam: process(clk)
    begin	 
    if rising_edge(clk) then
      if reset_n = '0' then
        readdata <= (others => '0');
      else
		  --x <= ('0','0','0','0','0','0','0','0','0','1','0','1','1','1','1','1');
        --y <= ('0','0','0','0','0','0','0','0','0','1','0','1','1','1','1','1');
		  -- x <= unsigned(RAM(to_integer(ram_address)));               -------read the coordinate
		  -- y <= unsigned(RAM(to_integer(ram_address) + 2));	 
        if chipselect = '1' then
          if address(4) = '0' then   -----the address indicate to the RAM
             if read = '1' then
               readdata <= RAM(1);
           --   x <= ('0','0','0','0','0','0','0','0','0','1','0','1','1','1','1','1');
           --   y <= ('0','0','0','0','0','0','0','0','0','1','0','1','1','1','1','1');
             elsif write = '1' then
             RAM(to_integer(ram_address)) <= writedata;       --the VHDL code do not need to write in the RAM
             -- RAM(0) <= std_logic_vector(x);
             -- RAM(2) <= std_logic_vector(y);
             end if;
          end if;
		  end if;
		  x <= unsigned(RAM(0));
		  y <= unsigned(RAM(1));
		  RECTANGLE_HSTART <= x - 8;
		  RECTANGLE_HEND <= x + 6;
		  RECTANGLE_VSTART <= y - 7;
		  RECTANGLE_VEND <= y + 8; 
		  x_board <= unsigned(RAM(2));
		  RECTANGLE_HSTART_board <= x_board - 21;
		  RECTANGLE_HEND_board <= x_board + 19;
		  RECTANGLE_VSTART_board <= to_unsigned(405,16);        ------leave 50-11 pixels for text
		  RECTANGLE_VEND_board <= to_unsigned(428,16);   

--      RECTANGLE_HSTART_brick1 <= to_unsigned(1,16);   -- brick_x;
--		  RECTANGLE_HEND_brick1 <= to_unsigned(40,16); --brick_x + 40; 
--		  RECTANGLE_VSTART_brick1 <= to_unsigned(59,16);-- brick_y;        ------leave 50-11 pixels for text
--		  RECTANGLE_VEND_brick1 <= to_unsigned(79,16);--brick_y + 20 ;        


        RECTANGLE_HSTART_brick1 <= to_unsigned(0,16);   -- brick_x;
		  RECTANGLE_HEND_brick1 <= to_unsigned(639,16); --brick_x + 40; 
		  RECTANGLE_VSTART_brick1 <= to_unsigned(0,16);-- brick_y;        ------leave 50-11 pixels for text
		  RECTANGLE_VEND_brick1 <= to_unsigned(159,16);--brick_y + 20 ;    		  
		end if;
    end if;
  end process forRam;
  ---------------------------random num generator!!-------------------------


  randomnum: process(clk)
  begin
  if rising_edge(clk) then     
    feedback <= lfsr_reg(127) xor lfsr_reg(0) ;

          if (reset_n = '0') then          --------neccessary????
             lfsr_reg <= brick_layout;

          else
            lfsr_reg <= lfsr_reg(lfsr_reg'high - 1 downto 0) & feedback ;

          end if;
  end if;

  end process randomnum;
  
  
  randomnum2: process(clk)
  begin
  if rising_edge(clk) then     
    feedback2 <= lfsr_reg2(127) xor lfsr_reg2(0) ;

          if (reset_n = '0') then          --------neccessary????
             lfsr_reg2 <= brick_layout + 1024 ;

          else
            lfsr_reg2 <= lfsr_reg2(lfsr_reg2'high - 1 downto 0) & feedback2 ;

          end if;
  end if;

  end process randomnum2;
  
  
  randomnum3: process(clk)
  begin
  if rising_edge(clk) then     
    feedback3 <= lfsr_reg3(127) xor lfsr_reg3(0) ;

          if (reset_n = '0') then          --------neccessary????
             lfsr_reg3 <= brick_layout - 655356 ;

          else
            lfsr_reg3 <= lfsr_reg3(lfsr_reg3'high - 1 downto 0) & feedback3 ;

          end if;
  end if;

  end process randomnum3;
----------------use lfsr_reg(7) as output-----------------------------------

  
  
  
  
  
  
  
  
-------------------------------------------------------------------------
--Bricklayout : process(clk)
--begin
--    if rising_edge(clk) then      
--      if reset_n = '0' then
--        brick_x <= to_unsigned(0,16);
--  brick_y <= to_unsigned(59,16)
--    elsif EndOfLine = '1' then
--      Hcount <= (others => '0');
--    else
--      Hcount <= Hcount + 1;
--    end if;      
--  end if;
--end process bricklayout;

HCounter : process (clk)
  begin
    if rising_edge(clk) then      
      if reset_n = '0' then
        Hcount <= (others => '0');	  
      elsif EndOfLine = '1' then
        Hcount <= (others => '0');
      else
        Hcount <= Hcount + 1;
      end if;      
    end if;
  end process HCounter;

  EndOfLine <= '1' when Hcount = HTOTAL - 1 else '0';
  
  VCounter: process (clk)
  begin
    if rising_edge(clk) then      
      if reset_n = '0' then
        Vcount <= (others => '0');
		  bg_change <= (others => '0');       --------------------------------initial bg_change here!!!!!!!!
      elsif EndOfLine = '1' then
        if EndOfField = '1' then
          Vcount <= (others => '0');
			 bg_change <= (others => '0');
        else
          Vcount <= Vcount + 1;
			 bg_change <= bg_change + 1;
        end if;
      end if;
    end if;
  end process VCounter;

  EndOfField <= '1' when Vcount = VTOTAL - 1 else '0';

  -- State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK

  HSyncGen : process (clk)
  begin
    if rising_edge(clk) then     
      if reset_n = '0' or EndOfLine = '1' then
        vga_hsync <= '1';
      elsif Hcount = HSYNC - 1 then
        vga_hsync <= '0';
      end if;
    end if;
  end process HSyncGen;
  
  HBlankGen : process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        vga_hblank <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH then
        vga_hblank <= '0';
      elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE then
        vga_hblank <= '1';
      end if;      
    end if;
  end process HBlankGen;

  VSyncGen : process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        vga_vsync <= '1';
      elsif EndOfLine ='1' then
        if EndOfField = '1' then
          vga_vsync <= '1';
        elsif Vcount = VSYNC - 1 then
          vga_vsync <= '0';
        end if;
      end if;      
    end if;
  end process VSyncGen;

  VBlankGen : process (clk)
  begin
    if rising_edge(clk) then    
      if reset_n = '0' then
        vga_vblank <= '1';
      elsif EndOfLine = '1' then
        if Vcount = VSYNC + VBACK_PORCH - 1 then
          vga_vblank <= '0';
        elsif Vcount = VSYNC + VBACK_PORCH + VACTIVE - 1 then
          vga_vblank <= '1';
        end if;
      end if;
    end if;
  end process VBlankGen;

  -- Rectangle generator

  RectangleHGen : process (clk)
  begin
    if rising_edge(clk) then     
      if reset_n = '0' then
        rectangle_h <= '0';
		elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND) + 1 then
		  rectangle_h <= circle_pix(TO_INTEGER(Hcount - HSYNC - HBACK_PORCH - RECTANGLE_HSTART + TO_INTEGER(Vcount - VSYNC - VBACK_PORCH - RECTANGLE_VSTART) * 15));
      else
        rectangle_h <= '0';
		end if;
    end if;
  end process RectangleHGen;

RectangleHGen_Board : process (clk)
  begin
    if rising_edge(clk) then  
		if reset_n = '0' then
        rectangle_h_board <= '0';
		elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART_board) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND_board) + 1 then
		  rectangle_h_board <= board_pix (TO_INTEGER(Hcount - HSYNC - HBACK_PORCH - RECTANGLE_HSTART_board + TO_INTEGER(Vcount - VSYNC - VBACK_PORCH - RECTANGLE_VSTART_board) * 41));       
      else
        rectangle_h_board <= '0';
		end if;     
	end if;
  end process RectangleHGen_Board;
  
  RectangleHGen_Brick1 : process (clk)
  begin
    if rising_edge(clk) then  
		if reset_n = '0' then
        rectangle_h_brick1 <= '0';
		elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART_brick1) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND_brick1) + 1 and random_temp2(to_INTEGER(count_H)+to_INTEGER(count_V)*16) = '0' then
		  rectangle_h_brick1 <= brick1_pix ((TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_brick1) - TO_INTEGER(count_H)*40 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_brick1) ) - TO_INTEGER(count_V)*20)*40));       
		elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART_brick1) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND_brick1) + 1 and random_temp2(to_INTEGER(count_H)+to_INTEGER(count_V)*16) = '1' then
		  rectangle_h_brick1 <= brick2_pix ((TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_brick1) - TO_INTEGER(count_H)*40 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_brick1) ) - TO_INTEGER(count_V)*20)*40));       
		else
        rectangle_h_brick1 <= '0';
		end if;     
	end if;
  end process RectangleHGen_Brick1;
  
  
  RectangleVGen : process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then       
        rectangle_v <= '0';
      elsif EndOfLine = '1' then
        if Vcount > VSYNC + VBACK_PORCH - 2 + RECTANGLE_VSTART and Vcount < VSYNC + VBACK_PORCH + RECTANGLE_VEND then
          rectangle_v <= '1';
        else
          rectangle_v <= '0';
        end if;
		end if;
		  
		if reset_n = '0' then       
        rectangle_v_board <= '0';
      elsif EndOfLine = '1' then
        if Vcount > VSYNC + VBACK_PORCH - 2 + RECTANGLE_VSTART_board and Vcount < VSYNC + VBACK_PORCH + RECTANGLE_VEND_board then
          rectangle_v_board <= '1';
        else
          rectangle_v_board <= '0';
        end if;
		end if;  
		  
		if reset_n = '0' then       
        rectangle_v_brick1 <= '0';
      elsif EndOfLine = '1' then
        if Vcount > VSYNC + VBACK_PORCH - 2 + RECTANGLE_VSTART_brick1 and Vcount < VSYNC + VBACK_PORCH + RECTANGLE_VEND_brick1 then
          rectangle_v_brick1 <= '1';
        else
          rectangle_v_brick1 <= '0';
        end if;
		end if;  
		  
    end if;      

  end process RectangleVGen;

  circle <= rectangle_h and rectangle_v;

  board <= rectangle_h_board and rectangle_v_board;
  
  brick1 <= rectangle_h_brick1 and rectangle_v_brick1;
  
  brickchange: process(clk,reset_n) 
  begin
	  if(reset_n='0') then
		 random_temp <= brick_layout;
		 random_temp2 <= brick_layout;
		 timer <= "00000000000000000000000000000000";
		elsif clk'event and clk = '1' then
			random_temp <= lfsr_reg;
			random_temp3 <= lfsr_reg2;
		   random_temp4 <= lfsr_reg3;
			timer <= timer + 1;
			if timer = 3200000 then
				random_temp2 <= random_temp and random_temp3 and random_temp4;

				timer <= timer + 1;
			elsif timer =3800000 then
				timer <= "00000000000000000000000000000000";
			end if;
		end if;
  end process brickchange;
				
			

  	
  -- Registered video signals going to the video DAC

  VideoOut: process (clk, reset_n)
  begin
    if reset_n = '0' then
      VGA_R <= "0000000000";
      VGA_G <= "0000000000";
      VGA_B <= "0000000000";
		count_H <= "0000000000000000";
		count_V <= "0000000000000000";
		
elsif rising_edge(clk) then
		if Hcount = 40 * (to_INTEGER(count_H)+1) + HSYNC + HBACK_PORCH  then  ----
		  count_H <= count_H + 1;  -------
--VGA_R <= "0000000000";
-- VGA_G <= "0000000000";
 --     VGA_B <= "0000000000";
	--	  elsif count_H = "0000000000001111"  then   --1111 BIN = 15 DEC
		  elsif endOfLine = '1'  then   --1111 BIN = 15 DEC
		  count_H <= "0000000000000000";
		  elsif Vcount = 20 *  (to_INTEGER(count_V)+1) + VSYNC + VBACK_PORCH -1 then
		  count_V <= count_V +1;
		  elsif count_V = "0000000000001001" then  --101 bin = 5 dec
		  count_V <= "0000000000000000" ; 
		  
		  elsif endOfField = '1' then
			count_H <= "0000000000000000";
			count_V <= "0000000000000000";
			end if;
			
    elsif clk'event and clk = '1' then
      --if circle = '1' then
		if circle = '1' then
        VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART) ))*16),8));
        VGA_R(1 downto 0) <= "00";
	     VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART) ))*16),8));
        VGA_G(1 downto 0) <= "00";
        VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART) ))*16),8));
        VGA_B(1 downto 0) <= "00";
		elsif  board = '1' then
		  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_board(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_board)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_board) ))*41),8));
        VGA_R(1 downto 0) <= "00";
	     VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_board(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_board)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_board) ))*41),8));
        VGA_G(1 downto 0) <= "00";
        VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_board(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_board)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_board) ))*41),8));
        VGA_B(1 downto 0) <= "00";
		  
		  elsif  (brick1 and (brick_layout(to_INTEGER(count_H)+to_INTEGER(count_V)*16))) = '1' and (random_temp2(to_INTEGER(count_H)+to_INTEGER(count_V)*16)) = '0' then
		  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_brick1(TO_integer(Hcount)- To_integer(RECTANGLE_HSTART_brick1) - To_integer(count_H)*40  - HSYNC - HBACK_PORCH- 1 +(TO_integer(Vcount)- To_integer(RECTANGLE_VSTART_brick1) - To_integer(count_V)*20 - VSYNC - VBACK_PORCH ) *40),8));
        VGA_R(1 downto 0) <= "00";
	     VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_brick1(TO_integer(Hcount)- To_integer(RECTANGLE_HSTART_brick1) - To_integer(count_H)*40  - HSYNC - HBACK_PORCH- 1 +(TO_integer(Vcount)- To_integer(RECTANGLE_VSTART_brick1) - To_integer(count_V)*20 - VSYNC - VBACK_PORCH ) *40),8));
		  --std_logic_vector(to_unsigned(G_brick1(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_brick1 - TO_INTEGER(count_H)*40 )- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_brick1 - TO_INTEGER(count_V)*20) ))*40),8));
        VGA_G(1 downto 0) <= "00";
        VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_brick1(TO_integer(Hcount)- To_integer(RECTANGLE_HSTART_brick1) - To_integer(count_H)*40  - HSYNC - HBACK_PORCH- 1 +(TO_integer(Vcount)- To_integer(RECTANGLE_VSTART_brick1) - To_integer(count_V)*20 - VSYNC - VBACK_PORCH ) *40),8));
        VGA_B(1 downto 0) <= "00";
		  
	
	  elsif  (brick1 and (brick_layout(to_INTEGER(count_H)+to_INTEGER(count_V)*16))) = '1' and (random_temp2(to_INTEGER(count_H)+to_INTEGER(count_V)*16)) = '1' then
		  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_brick2(TO_integer(Hcount)- To_integer(RECTANGLE_HSTART_brick1) - To_integer(count_H)*40  - HSYNC - HBACK_PORCH- 1 +(TO_integer(Vcount)- To_integer(RECTANGLE_VSTART_brick1) - To_integer(count_V)*20 - VSYNC - VBACK_PORCH ) *40),8));
        VGA_R(1 downto 0) <= "00";
	     VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_brick2(TO_integer(Hcount)- To_integer(RECTANGLE_HSTART_brick1) - To_integer(count_H)*40  - HSYNC - HBACK_PORCH- 1 +(TO_integer(Vcount)- To_integer(RECTANGLE_VSTART_brick1) - To_integer(count_V)*20 - VSYNC - VBACK_PORCH ) *40),8));
		  --std_logic_vector(to_unsigned(G_brick1(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_brick1 - TO_INTEGER(count_H)*40 )- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_brick1 - TO_INTEGER(count_V)*20) ))*40),8));
        VGA_G(1 downto 0) <= "00";
        VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_brick2(TO_integer(Hcount)- To_integer(RECTANGLE_HSTART_brick1) - To_integer(count_H)*40  - HSYNC - HBACK_PORCH- 1 +(TO_integer(Vcount)- To_integer(RECTANGLE_VSTART_brick1) - To_integer(count_V)*20 - VSYNC - VBACK_PORCH ) *40),8));
        VGA_B(1 downto 0) <= "00";
--		elsif circle = '0' and rectangle = '1' then
--		  VGA_R <= "1111111111";
--       VGA_G <= "1111111111";
--        VGA_B <= "1111111111";
      elsif vga_hblank = '0' and vga_vblank ='0' then
        VGA_R <= bg_change + "0011111100" ;   ----+ bg_change
        VGA_G <= bg_change + "0011111100" ;
        VGA_B <= "1111111111";
      else
        VGA_R <= "0000000000";
        VGA_G <= "0000000000";
        VGA_B <= "0000000000";    
      end if;
    end if;
  end process VideoOut;

  VGA_CLK <= clk;
  VGA_HS <= not vga_hsync;
  VGA_VS <= not vga_vsync;
  VGA_SYNC <= '0';
  VGA_BLANK <= not (vga_hsync or vga_vsync);


	
end rtl;
