/* Bare-bones demonstration of interrupts on the NIOS II
 *
 * Shangru Li  
 */

#include <stdio.h>
#include "system.h"       
#include <sys/alt_irq.h>  // the irq functions
#include <io.h>
#include <alt_types.h>

static void irqhandler (void * context, alt_u32 id)
{
  printf ("interrupt occurred\n"); 
  IOWR_16DIRECT(IRQSOURCE_BASE, 0, 0);  // reset the interrupt request
}

int main()
{      
  printf("main() started\n");
  alt_irq_register( IRQSOURCE_IRQ, NULL,
		    (void*)irqhandler ); // register IRQSOURCE

  for (;;) {} // Do nothing forever
  
  return 0; // Never executed
}
