{ open Parser }

rule token = parse
[' ' '\r' '\n'] {token lexbuf} (* Whitespace *)
| '?'   	{comment lexbuf} (* Comments *)
| '\"' ([^'\"']+ as str) '\"'	{STRING(str)} (* strings *)
| '\t'		{TAB} 
(**| '\t'+'\n'	{TABENDL} (* allow tabs at the end of a line *)*)
| '('      	{LPAREN}
| ')'      	{RPAREN}
| '['		{LBRACK}
| ']'		{RBRACK}
| '+'		{PLUS}
| '-'		{MINUS}
| "=="		{EQ}
| "!="		{NEQ}
| '<'		{LT}
| '>'		{GT}
| "<="		{LEQ}
| ">="		{GEQ}
| "&&"		{AND}
| "||"		{OR}
| '!'		{NOT}
| ','		{COMMA}
| ':'		{COLON}
| '|'		{BAR}
| '='		{ASSIGN}
| "FOREACH"	{FOREACH}
| "foreach"	{FOREACH}
| "WHILE"	{WHILE}
| "while"	{WHILE}
| "IF"		{IF}
| "if"		{IF}
| "str"  	{STR}
| "str[]"	{ARR}
| "int"		{INT}
| '@' 		{IO}
| ['0'-'9']+ as lxm { INTEGER(int_of_string lxm) }
| ['a'-'z' 'A'-'Z' '0'-'9']+ as lxm { ID(lxm) }
| eof { EOF }
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
'\n' {token lexbuf}
| _    { comment lexbuf }

