type action = Ast | Invalid | Bytecode | Compile

let _ = 

if Sys.argv.(1) = "-h" then 
  print_endline "help is on the way!" (* do nothing. *)
else
  let action = if Array.length Sys.argv > 1 then
    List.assoc Sys.argv.(1) [ ("-a", Ast);
			      ("-b", Bytecode);
			     ("-c", Compile)]
  else Compile in
  let debug = if (Array.length Sys.argv > 2) && (Sys.argv.(2) = "-d") then 1 else 0 in
  let lexbuf = Lexing.from_channel stdin in
  let program = Parser.program Scanner.token lexbuf in
 (* let program = Semantics.check program in*)
  match action with
    Ast -> let listing = Ast.string_of_program program
           in print_string listing
  | Bytecode -> let listing =
      Bytecode.string_of_prog (Compile.translate program)
    in print_endline listing
 | Compile -> Execute.execute_prog (Compile.translate program) debug
