open Type

type expr_c = 
    Literal of literal (* 42 *)
  | Id of string (* foo *)
  | Binop of expr * op * expr (* a + b *)
  | Assign of expr * expr (* a = b *)
  | Call of string * (expr list) (* foo(1, 25) *)
  | Noexpr (* While() *)
  | Uniop of op * expr 
  | ObjValue of (expr list)

and expr = expr_c * t

type event_def = {
	typename: string;
	members : (t * string * (expr option)) list;
}

type stmt = 
     Block of (stmt list) (* statement list and var list *)
   | Expr of expr 
   | Return of expr 
   | If of expr * stmt * stmt (* if (foo == 42) {} else {} *)
   | For of expr * expr * expr * stmt (* for loop *)
   | While of expr * stmt 
   | Vardecl of (t * string * (expr option)) list
   | Empty 
   
(*type func_decl = {
	return_type : t;
    fname : string;
    params : (t * string) list;
    body : stmt list; 
}
               
type program = {
		eventdef: event_def list;
		globalvar: (t * string * (expr option)) list;
		funcdef: func_decl list;
}*)
