%{ open Type %}
%{ open Ast %}

%token <string> ID
%token IF ELSE WHILE FOR RETURN
%token INT_T FLOAT_T STRING_T BOOL_T VOID EVENTTYPE CALENDAR
%token <int>INT
%token <float>FLOAT
%token <bool>BOOL
%token <string>STRING
%token NULL
%token LBRACE RBRACE SEMI COMMA
%token ASSIGN

%token OR AND NOT
%token NEQ GT LT LEQ GEQ EQ
%token PLUS MINUS TIMES DIVIDE MOD
%token LBRACK RBRACK DOT
%token LPAREN RPAREN
%token EOF

%nonassoc NOELSE
%nonassoc ELSE

%right ASSIGN

%left OR 
%left AND
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS   /* for binop they are left, but for unop should they be right? */
%left TIMES DIVIDE MOD
%right NOT
%nonassoc LBRACK
%left DOT

%start program
%type <Ast.program> program      /* this type should be AST.program. just put int because AST is not finished */
%%


program:
program_  { {
		eventdef = List.rev $1.eventdef;
		globalvar = List.rev $1.globalvar;
		funcdef = List.rev $1.funcdef;
  } }
	
program_:
   /* nothing */	{ {eventdef = []; globalvar = []; funcdef = []} }
 | program_ type_def	{{ $1 with eventdef = ($2 :: $1.eventdef)}}
 | program_ decl	{ {$1 with globalvar = ($2 :: $1.globalvar) } }
 | program_ func_def	{ {$1 with funcdef = ($2 :: $1.funcdef) } }
 
    
type_def:
    EVENTTYPE ID LBRACE decl_list RBRACE                                      
                                                            { { typename = $2;
                                                                members = List.rev $4;
                                                               }}

decl_list:
    decl                                     { [$1] }
    | decl_list decl                         { $2::$1 }

decl:
    type_specifier init_list SEMI            { ($1, List.rev $2) }

type_specifier:
    INT_T                                   { Int }
    | FLOAT_T                               { Float }
    | STRING_T                              { String }
    | BOOL_T                                { Boolean }
    | ID                                    { Event_type($1) }  
	| CALENDAR								{ Calendar }
	| VOID                                  { Void }


init_list:
    init                                    { [$1] }
    | init_list COMMA init                  { $3::$1 }

init:
    ID                                      { WithoutInit($1) }
    | ID ASSIGN expr                        { WithInit($1 ,$3) }

func_def:
    type_specifier ID LPAREN para_list RPAREN stmt_block           { {  return_type = $1;
                                                                        fname = $2;
                                                                        params = List.rev $4;
																	  	body = $6	
																    } }

para_list:
    /* nothing */					        {[]}
    | para_decl                             { [$1] }
    | para_list COMMA para_decl             { $3::$1 }

para_decl:
    type_specifier ID                       { ($1, $2) }
    
stmt_block:
    LBRACE stmt_list RBRACE                 { List.rev $2 }

stmt_list:
    /* nothing */                           { [] }
    | stmt_list stmt                        { $2::$1 }

stmt:
    expr SEMI                               				  { Expr($1) }
    | decl                                                    { Vardecl($1) }
    | stmt_block                                              { Block($1) }
    | IF LPAREN expr RPAREN stmt %prec NOELSE                 { If($3, $5, Block([])) }
    | IF LPAREN expr RPAREN stmt ELSE stmt                    { If($3, $5, $7) }
    | WHILE LPAREN expr RPAREN stmt                           { While($3, $5) }
    | FOR LPAREN expr SEMI expr SEMI expr RPAREN stmt         { For($3, $5, $7, $9) }
    | RETURN expr SEMI                                        { Return($2) }
    | RETURN SEMI                                             { ReturnVoid }
    | SEMI                                                    { Empty }      

expr:
	
	| literal                             { Literal($1) }
	
    | expr PLUS expr                      { Binop($1, Add, $3) }
    | expr MINUS expr                     { Binop($1, Sub, $3) }
    | expr TIMES expr                     { Binop($1, Mult, $3) }
    | expr DIVIDE expr                    { Binop($1, Div, $3) }

    | expr GT expr                    	  { Binop($1, Greater_than, $3) }
    | expr LT expr                        { Binop($1, Less_than, $3) }
    | expr GEQ expr                       { Binop($1, Geq, $3) }
    | expr LEQ expr                       { Binop($1, Leq, $3) }
    | expr NEQ expr                       { Binop($1, Neq, $3) }
    | expr EQ expr                        { Binop($1, Equal, $3) }

    | expr AND expr                       { Binop($1, And, $3) }
    | expr OR expr                        { Binop($1, Or, $3) }
    | NOT expr                            { Uniop(Not, $2) }

    | lvalue                              { $1 }

    | lvalue ASSIGN expr                  { Assign($1, $3) }
    
    | LPAREN expr RPAREN                  { $2 }
    | ID LPAREN arg_list RPAREN           { Call($1, List.rev $3) }
	| LBRACK obj_list RBRACK	{ObjValue(List.rev $2)}
	
	 
	


obj_list:
	/*nothing*/ 				{ [] }
	| expr						{ [$1] }
	|obj_list COMMA expr		{ $3::$1}
	
literal:
    INT                                   { IntLit($1) }
    | FLOAT                               { FloatLit($1) }
    | STRING                              { StringLit($1) }
    | BOOL                                { BoolLit($1) }


lvalue:
    ID                                    { Id($1) }
    | ID DOT ID                         { Binop(Id($1), Dot, Id($3)) }
    | expr LBRACK expr RBRACK             { Binop($1, Child, $3) }

arg_list:
    /* nothing */                         { [] }
    | expr                                { [$1] }
    | arg_list COMMA expr                 { $3::$1 }
   
