open Type
open Ast


let string_of_call (f, el) =
	 match f with
		"print" -> "System.out.println("^(String.concat "," (List.map string_of_expr el))^")"
		|_    -> f ^ "(" ^ String.concat ", " (List.map string_of_expr el) ^ ")"

let rec string_of_expr = function
    Literal(l) -> Ast.string_of_literal l
  | Id(s) -> s
  | Assign(e1,e2)->string_of_expr e1 ^" = "^string_of_expr e2
  | Call(f, el) -> string_of_call (f, el) (*(match f with
			print -> print_endline "print"
			| _ -> print_endline "other"); *)
  | Noexpr (* While() *)-> ""
  | Uniop(o,e)->Ast.string_of_op o ^" "^string_of_expr e
  | ObjValue(l)->"[" ^ (String.concat ", " (List.map string_of_expr l)) ^" ]"
  | Binop(e1,o,e2)-> (match o with
					 Child -> string_of_expr e1 ^ "[" ^ string_of_expr e2 ^ "]"
					|Dot   -> string_of_expr e1 ^ Ast.string_of_op o ^ string_of_expr e2
					| _    -> string_of_expr e1 ^ " " ^ Ast.string_of_op o ^ " " ^ string_of_expr e2)
  
  
let string_of_init = function
	WithInit(v,e)-> v ^ "=" ^ string_of_expr e
	|WithoutInit(v)-> v 
	
let string_of_initlist (init) =
	(String.concat ", " (List.map string_of_init init))^";\n"
	
let string_of_event_init myEvent = function
	WithInit(v,e)-> v ^ "= new "^ myEvent ^ Str.global_replace(Str.regexp "\\]") ")" (Str.global_replace(Str.regexp "\\[") "(" (string_of_expr e))
	|WithoutInit(v)-> v 
	
let string_of_event_initlist myEvent (init) =
	(String.concat ", " (List.map (string_of_event_init myEvent) init))^";\n"
	
let string_of_vdecl (t, l) = 
	match t with
	 Calendar -> string_of_initlist l
	|Event_type(myEvent) -> myEvent ^" "^ string_of_event_initlist myEvent l^"\n"
	| _ -> Ast.string_of_dt t^" "^ string_of_initlist l^"\n"
	


let string_of_mem (t, l) =
	"this."^(Str.global_replace (Str.regexp ";\n") "" (string_of_initlist l)) ^" = "^ (string_of_initlist l)
	
let string_of_event (myevent) = 
	"class "^myevent.typename^"{\n"^ String.concat "\n" (List.map string_of_vdecl myevent.members)^ 
	"public " ^ myevent.typename ^"("^ Str.global_replace (Str.regexp ";\n\n") "" (String.concat "," (List.map string_of_vdecl myevent.members))^ "){\n"^
	String.concat "" (List.map string_of_mem myevent.members)^
	"}\n}\n"
	
let string_of_arg(t, name) = 
	(Ast.string_of_dt t) ^ " " ^ name

let rec string_of_stmt = function
	Block(stmts) -> "{\n" ^ String.concat "\n" (List.map string_of_stmt stmts) ^ "}\n"
   | Expr(e) -> string_of_expr e ^";"
   | Return(e) ->"return "^ (string_of_expr e) ^";"
   | ReturnVoid ->"return ;"
   | If(e, s, Block([]))->"if (" ^ string_of_expr e ^ ")\n" ^ string_of_stmt s
   | If(e, s1, s2) ->  "if (" ^ string_of_expr e ^ ")\n" ^ string_of_stmt s1 ^ "else\n" ^ string_of_stmt s2
   | For(e1,e2,e3,s)->"for (" ^ string_of_expr e1^ " ; " ^ string_of_expr e2 ^ " ; " ^ string_of_expr e3  ^ ")\n " ^ string_of_stmt s
   | While(e, s) -> "while (" ^ string_of_expr e ^ ") " ^ string_of_stmt s
   | Vardecl(v)-> string_of_vdecl v
   | Empty->""
	
let string_of_func (f) = 
	match f.fname with
	"main" -> "public static "^(Ast.string_of_dt f.return_type)^" main(String[] args)"^
	"{\n" ^ (String.concat "" (List.map string_of_stmt f.body) )^ "}\n"
	|_     -> "public static "^(Ast.string_of_dt f.return_type)^" "^ f.fname ^ " (" ^ String.concat ", " (List.map string_of_arg f.params)^")"^
	"{\n" ^ (String.concat "" (List.map string_of_stmt f.body) )^ "}\n"
	
let string_of_events = function
	[] -> ""
	| elist -> String.concat "\n" (List.map string_of_event elist)
	
let string_of_vars_g = function
    [] -> ""
	| v -> "static " ^ String.concat "\n static" (List.map string_of_vdecl v)


let string_of_funs = function
	[] -> ""
	| flist -> String.concat "\n" (List.map string_of_func flist)

let string_of_program (p:program) prog_name =
	let out_chan = open_out (prog_name ^ ".java") in
		let translated_prog = 
			"import java.util.ArrayList;\n\n" ^ 
			string_of_events p.eventdef ^"public class " ^
			prog_name ^"{\n"^ string_of_vars_g p.globalvar ^  
			string_of_funs p.funcdef^"\n}" in
		
			let proc_status = ignore(Printf.fprintf out_chan "%s" translated_prog); 
				close_out out_chan; 
				print_string translated_prog;
				Sys.command (Printf.sprintf "javac %s.java" prog_name) in
					match proc_status with
					  0 -> "\n\nCompilation successful\n" 
					| _ -> "\nCompilation unsuccessful!\n"
							
	