#!/bin/sh

EXT=".wfm"
WARMFUSION="./warmfusion"
runprogram=0
deletefile=0

if [ $# -eq 0 ]
then
        echo "Usage: warmfusionc.sh [-r] [-d] <file.wfm>"
        echo "-d   Delete generated .cs file"
        echo "-r   Run the program after compiling"
        exit 1
fi

#Run the program if -r is specified
while getopts "rd" option
do
        case $option in
        d)
                deletefile=1
                ;;
        r)
                runprogram=1
                ;;
        esac
done
shift `expr $OPTIND - 1`

filename=$(basename "$1")
filenamewithoutext=${filename%$EXT}

#Concatenate the stub.cs with the generated output
cat stub.cs > "$filenamewithoutext.cs"
${WARMFUSION} < $1 >> "$filenamewithoutext.cs"

#Do the compilation using Mono (requires libmono-system-web2.0-cil to be installed)
#Alternatively, if you're using Microsoft's C# compiler, you could do something similar to: C:\Windows\Microsoft.NET\Framework\v4.0.30319\csc.exe /r:System.Web.dll $filenamewithoutext.cs
mcs /r:System.Web.dll "$filenamewithoutext.cs"

#Allow it to execute
chmod 755 "$filenamewithoutext.exe"

#Delete .cs file
if [ $runprogram -eq 1 ] ; then
        rm $filenamewithoutext.cs
fi

#Run the program
if [ $runprogram -eq 1 ] ; then
        ./$filenamewithoutext.exe
fi
