using System;
using System.Collections.Specialized;
using System.Web;

#pragma warning disable 0162

public class WF
{
    private static Random rand = new Random();

    //WarmFusion isn't strongly typed, so we store everything as strings, and convert to a number when necessary
    public static decimal ConvertToNumber(string s)
    {
        if (s.Length == 0)
            return 0;

        decimal d;
        bool success = decimal.TryParse(s, out d);
        if (!success)
            throw new Exception("Could not convert \"" + s + "\" to a number.");

        return d;
    }

    //The number 0, an empty string or the string "false" all evaluate to false.  Everything else evaluates to true
    public static bool ConvertStringToBool(string s)
    {
        bool boolValue;
        try
        {
            decimal d = ConvertToNumber(s);
            boolValue = (d != 0);
        }
        catch (Exception)
        {
            boolValue = (s.ToLower() != "false");
        }

        return boolValue;
    }

    public static string ConvertBoolToString(bool b)
    {
        if (b)
            return "1";
        else
            return "0";
    }

    public static string Negate(string s)
    {
        if (ConvertStringToBool(s))
            return "0";
        else
            return "1";
    }

    public static string Negative(string s)
    {
        return (-ConvertToNumber(s)).ToString();
    }

    public static string Add(string s1, string s2)
    {
        return (ConvertToNumber(s1) + ConvertToNumber(s2)).ToString();
    }

    public static string Sub(string s1, string s2)
    {
        return (ConvertToNumber(s1) - ConvertToNumber(s2)).ToString();
    }

    public static string Mult(string s1, string s2)
    {
        return (ConvertToNumber(s1) * ConvertToNumber(s2)).ToString();
    }

    public static string Div(string s1, string s2)
    {
        return (ConvertToNumber(s1) / ConvertToNumber(s2)).ToString();
    }

    public static string Modulus(string s1, string s2)
    {
        return (ConvertToNumber(s1) % ConvertToNumber(s2)).ToString();
    }

    public static string Concatenate(string s1, string s2)
    {
        return s1 + s2;
    }

    public static string Equal(string s1, string s2)
    {
        bool isEqual;
        try
        {
            //If they're both numbers, do a numeric comparison
            decimal d1 = ConvertToNumber(s1);
            decimal d2 = ConvertToNumber(s2);
            isEqual = (d1 == d2);
        }
        catch (Exception)
        {
            //Otherwise do a string comparison
            isEqual = (s1 == s2);
        }

        return ConvertBoolToString(isEqual);
    }

    public static string Neq(string s1, string s2)
    {
        return Negate(Equal(s1, s2));
    }

    public static string Less(string s1, string s2)
    {
        return ConvertBoolToString(ConvertToNumber(s1) < ConvertToNumber(s2));
    }

    public static string Leq(string s1, string s2)
    {
        return ConvertBoolToString(ConvertToNumber(s1) <= ConvertToNumber(s2));
    }

    public static string Greater(string s1, string s2)
    {
        return ConvertBoolToString(ConvertToNumber(s1) > ConvertToNumber(s2));
    }

    public static string Geq(string s1, string s2)
    {
        return ConvertBoolToString(ConvertToNumber(s1) >= ConvertToNumber(s2));
    }

    public static string And(string s1, string s2)
    {
        return ConvertBoolToString(ConvertStringToBool(s1) && ConvertStringToBool(s2));
    }

    public static string Or(string s1, string s2)
    {
        return ConvertBoolToString(ConvertStringToBool(s1) || ConvertStringToBool(s2));
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    // Built-in functions
    /////////////////////////////////////////////////////////////////////////////////////////

    public static string GetTickCount()
    {
        return Environment.TickCount.ToString();
    }

    public static string Sqr(string s)
    {
        decimal dec = ConvertToNumber(s);
        double dbl = Math.Sqrt((double)dec);
        return dbl.ToString();
    }

    public static string LCase(string s)
    {
        return s.ToLower();
    }

    public static string UCase(string s)
    {
        return s.ToUpper();
    }

    public static string Len(string s)
    {
        return s.Length.ToString();
    }

    public static string Left(string s, string len)
    {
        try
        {
            return s.Substring(0, (int)ConvertToNumber(len));
        }
        catch (Exception)
        {
            throw new Exception("Invalid len " + len + " in " + s);
        }
    }

    // String Mid function.  In WarmFusion, the index starts at 1 instead of 0.
    public static string Mid(string s, string start, string count)
    {
        try
        {
            return s.Substring((int)ConvertToNumber(start) - 1, (int)ConvertToNumber(count));
        }
        catch (Exception)
        {
            throw new Exception("Invalid start " + start + " or count " + count + " in " + s);
        }
    }

    public static string Right(string s, string len)
    {
        try
        {
            return s.Substring(s.Length - (int)ConvertToNumber(len));
        }
        catch (Exception)
        {
            throw new Exception("Invalid len " + len + " in " + s);
        }
    }

    //List functions below.  A list is basically a comma delimited string.
    //e.g str = "a,b,c,d"
    //In the example above, ListLen(str) is 4; ListGetAt(str, 2) is "b"; ListSetAt(str, 2, 'x') is "a,x,c,d"; ListAppend(str, "e") is "a,b,c,d,e"; ListFind(str, "d") is 4
    public static string ListLen(string lst)
    {
        string[] splitted = lst.Split(',');
        return splitted.Length.ToString();
    }

    public static string ListGetAt(string lst, string num)
    {
        try
        {
            string[] splitted = lst.Split(',');
            return splitted[(int)ConvertToNumber(num) - 1];
        }
        catch (Exception)
        {
            throw new Exception("Invalid index " + num + " in " + lst);
        }
    }

    public static string ListSetAt(string lst, string num, string str)
    {
        try
        {
            string[] splitted = lst.Split(',');
            splitted[(int)ConvertToNumber(num) - 1] = str;
            return String.Join(",", splitted);
        }
        catch (Exception)
        {
            throw new Exception("Invalid index " + num + " in " + lst);
        }
    }

    public static string ListAppend(string lst, string str)
    {
        if (lst.Length == 0)
            return str;
        else
            return lst + "," + str;
    }

    //Returns 0 if the string could not be found, otherwise it returns the index.
    public static string ListFind(string lst, string str)
    {
        string[] splitted = lst.Split(',');
        int val = Array.IndexOf(splitted, str);
        return (val + 1).ToString();
    }

    public static string Rand()
    {
        return rand.NextDouble().ToString();
    }

    public static string Now()
    {
        return DateTime.Now.ToString();
    }

    public static string HTMLEditFormat(string str)
    {
        return HttpUtility.HtmlEncode(str);
    }

    public static string URLEncodedFormat(string str)
    {
        return HttpUtility.UrlEncode(str);
    }

    //This get up the URL query parameter if running this program as a CGI binary
    //e.g. http://localhost/warmfusion.exe?var=1234 The value "1234" can be accessed by calling GetURLParameter("var")
    public static string GetQueryParameter(string name)
    {
        string queryString = System.Environment.GetEnvironmentVariable("QUERY_STRING");
        if (queryString != null)
        {
            NameValueCollection queryParameters = HttpUtility.ParseQueryString(queryString);
            string val = queryParameters[name];
            if (val != null)
                return val;
        }

        return "";
    }
}
