{
	open Parser;;
	let strBuffer = Buffer.create 100;;
	let strOutput = Buffer.create 1000;;
}

rule token = parse
  [' ' '\t' '\r' '\n'] { token lexbuf } (* Whitespace *)
| "<!---"     { comment 0 lexbuf }           (* Comments *)
| "'"      { Buffer.clear strBuffer; STRING(string lexbuf) }
| "<wfoutput>"      { Buffer.clear strOutput; RAWOUTPUT(wfoutput lexbuf) }
| '"'      { QUOTE }
| '('      { LPAREN }
| ')'      { RPAREN }
| '{'      { LBRACE }
| '}'      { RBRACE }
| ';'      { SEMI }
| ','      { COMMA }
| '+'      { PLUS }
| '-'      { MINUS }
| '*'      { TIMES }
| '/'      { DIVIDE }
| '%'      { MODULUS }
| '&'      { CONCATENATE }
| '='      { ASSIGN }
| "NOT"     { NOT }
| "EQ"     { EQ }
| "NEQ"     { NEQ }
| "LT"      { LT }
| "LTE"     { LEQ }
| "GT"      { GT }
| "GTE"     { GEQ }
| "AND"     { AND }
| "OR"     { OR }
| "<wfset"     { SET }
| "<wffunction"     { FUNCTION }
| "<wfargument"     { ARGUMENT }
| "</wffunction>"     { FUNCTIONENDINGTAG }
| "<wfif"     { IF }
| "<wfelse>"   { ELSE }
| "</wfif>"     { IFENDINGTAG }
| "<wfloop" { LOOP }
| "</wfloop>" { LOOPENDINGTAG }
| "name="     { PARAMETERNAME }
| "condition="     { PARAMETERCONDITION }
| "index="     { PARAMETERINDEX }
| "from="     { PARAMETERFROM }
| "to="     { PARAMETERTO }
| "<wfreturn" { RETURN }
| ">"     { TAGCLOSE }
| "/>"     { ENDINGTAG }
| ['0'-'9']+ as lxm { LITERAL(lxm) }
| ['0'-'9']+'.'['0'-'9']+ as lxm { LITERAL(lxm) }
| ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm { ID(lxm) }
| eof { EOF }
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

(* Allow comments inside of comments - I wish every language allowed this. *)
and comment inner = parse
	"<!---" { comment (inner + 1) lexbuf }
| "--->" 	{
						if (inner = 0) then
							token lexbuf
						else
							comment (inner - 1) lexbuf
					}
| _    { comment (inner) lexbuf }

and string = parse
		"'"				{ Buffer.contents strBuffer }
	| "''" { Buffer.add_string strBuffer "'"; string lexbuf }
	| _ as char { Buffer.add_char strBuffer char; string lexbuf }

(* Belive me, it was a lot of work figuring out how to make this tokenize & parse the content of wfoutput tags properly *)
and wfoutput = parse
	"</wfoutput>"		{ Buffer.contents strOutput }
	| _ as char { Buffer.add_char strOutput char; wfoutput lexbuf }

and wfoutput_scanner = parse
	"##" { OUTPUT("#") }
	|	"#" ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* "#" as str { OUTPUTVARIABLE(String.sub str 1 (String.length str - 2)) }
	| [^'#']+ as str { OUTPUT(str) }
	| eof { EOF }