%{ open Ast %}

%token SEMI LPAREN RPAREN LBRACE RBRACE COMMA QUOTE
%token PLUS MINUS TIMES DIVIDE MODULUS CONCATENATE ASSIGN
%token EQ NEQ LT LEQ GT GEQ
%token AND OR NOT
%token RETURN
%token SET FUNCTION ARGUMENT FUNCTIONENDINGTAG
%token IF ELSE IFENDINGTAG
%token FOR LOOP LOOPENDINGTAG
%token PARAMETERNAME PARAMETERCONDITION PARAMETERINDEX PARAMETERFROM PARAMETERTO
%token TAGCLOSE ENDINGTAG
%token <string> LITERAL
%token <string> ID
%token <string> STRING
%token <string> RAWOUTPUT
%token <string> OUTPUT
%token <string> OUTPUTVARIABLE
%token EOF

%nonassoc NOELSE
%nonassoc ELSE
%right ASSIGN
%left AND OR
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS
%left TIMES DIVIDE MODULUS CONCATENATE
%right NOT
%nonassoc NEGATIVE

%start program
%type <Ast.program> program

%start wfoutput_parser
%type <Ast.wfoutput_parser> wfoutput_parser

%%

program:
   /* nothing */ { [], [] }
	/* Not all statements have to be inside functions */
 | program stmt 	{ ($2 :: fst $1), snd $1 }
 | program fdecl 	{ fst $1, ($2 :: snd $1) }

fdecl:
FUNCTION PARAMETERNAME QUOTE ID QUOTE TAGCLOSE arg_list stmt_list FUNCTIONENDINGTAG
     { { fname = $4;
	 formals = $7;
	 body = List.rev $8 } }

arg_list:
    /* nothing */    { [] }
  | arg_list arg { $2 :: $1 }

arg:
   ARGUMENT PARAMETERNAME QUOTE ID QUOTE ENDINGTAG { $4 }
	

stmt_list:
    /* nothing */  { [] }
  | stmt_list stmt { $2 :: $1 }

stmt:
	SET expr ENDINGTAG { Expr($2) }
  | SET ID ASSIGN expr ENDINGTAG { Assign($2, $4) }
	| SET ID ASSIGN QUOTE expr QUOTE ENDINGTAG { Assign($2, $5) }
  | RETURN expr ENDINGTAG { Return($2) }
  | IF expr TAGCLOSE stmt_list %prec NOELSE IFENDINGTAG { If($2, Block(List.rev $4), Block([])) }
  | IF expr TAGCLOSE stmt_list ELSE stmt_list IFENDINGTAG    { If($2, Block(List.rev $4), Block(List.rev $6)) }
	| LOOP PARAMETERINDEX QUOTE ID QUOTE PARAMETERFROM QUOTE expr QUOTE PARAMETERTO QUOTE expr QUOTE TAGCLOSE stmt_list LOOPENDINGTAG { For($4, $8, $12, Block(List.rev $15)) }
  | LOOP PARAMETERCONDITION QUOTE expr QUOTE TAGCLOSE stmt_list LOOPENDINGTAG { While($4, Block(List.rev $7)) }
	| RAWOUTPUT { RawOutput($1) }


expr:
    LITERAL          { Literal($1) }
	| STRING                  { String($1) } 
	| MINUS expr %prec NEGATIVE { Negative($2) }
  | ID               { Id($1) }
	| NOT expr 					{ Negate($2) }
  | expr PLUS   expr { Binop($1, Add,   $3) }
  | expr MINUS  expr { Binop($1, Sub,   $3) }
  | expr TIMES  expr { Binop($1, Mult,  $3) }
  | expr DIVIDE expr { Binop($1, Div,   $3) }
	| expr MODULUS expr { Binop($1, Modulus,   $3) }
	| expr CONCATENATE expr { Binop($1, Concatenate,   $3) }
  | expr EQ     expr { Binop($1, Equal, $3) }
  | expr NEQ    expr { Binop($1, Neq,   $3) }
  | expr LT     expr { Binop($1, Less,  $3) }
  | expr LEQ    expr { Binop($1, Leq,   $3) }
  | expr GT     expr { Binop($1, Greater,  $3) }
  | expr GEQ    expr { Binop($1, Geq,   $3) }
	| expr AND    expr { Binop($1, And,   $3) }
	| expr OR    expr { Binop($1, Or,   $3) }
  | ID LPAREN actuals_opt RPAREN { Call($1, $3) }
  | LPAREN expr RPAREN { $2 }

actuals_opt:
    /* nothing */ { [] }
  | actuals_list  { List.rev $1 }

actuals_list:
    expr                    { [$1] }
  | actuals_list COMMA expr { $3 :: $1 }

wfoutput_parser:
		{ [] }
	| wfoutput_parser wfoutput_token { $2 :: $1 }

wfoutput_token:
		OUTPUT { Output($1) }
	| OUTPUTVARIABLE { OutputVariable($1) }