type op = Add | Sub | Mult | Div | Modulus | Concatenate | Equal | Neq | Less | Leq | Greater | Geq | And | Or 

type expr =
    Literal of string
	| String of string 
  | Id of string
	| Negative of expr
	| Negate of expr
  | Binop of expr * op * expr
  | Call of string * expr list
  | Noexpr

type stmt =
    Block of stmt list
	| Assign of string * expr
  | Expr of expr
  | Return of expr
  | If of expr * stmt * stmt
  | For of string * expr * expr * stmt
  | While of expr * stmt
	| RawOutput of string

type wfoutput = 
	| Output of string
	| OutputVariable of string

type wfoutput_parser = wfoutput list

type func_decl = {
    fname : string;
    formals : string list;
    body : stmt list;
  }

type program = stmt list * func_decl list