{open Parser}

let letter = ['a'-'z' 'A'-'Z']
let digit = ['0' - '9']

rule token = 
	parse [' ' '\t' '\r' '\n']  			{ token lexbuf }
	| "triangle" 					{ TRIANGLE }
	| "value"					{ VALUE }
	| "true" as tvalue				{ BOOL(tvalue) }
	| "false" as fvalue		 		{ BOOL(fvalue) }
	| "initialize"					{ INITIALIZATION }
	| "rules" 					{ RULES }
	| "operations"			 		{ OPERATIONS }
	| "rule"					{RULE}
	| "while"					{ WHILE }
	| "if"						{ IF }
	| '_'						{ WILDCAT }
	| "&&"						{ AND }
	| "=="						{ EQ }
	| "||"						{ OR }
	| '='					     {ASSIGN}
	| "!!"						{ NOT }
	| "sin"						{ SIN }
	| "cos"						{ COS }
	| "tan"						{ TAN }
	| "arcsin"					{ ARCSIN }
	| "arccos"					{ ARCCOS }
	| "arctan"					{ ARCTAN }
	| "sqrt"					{ SQRT }
	| 'V'						{ VERTEX }
	| 'L'						{ LINE }
	| "prints"					{ PRINTS }
	| "printv"					{ PRINTV }
	| "Ax"						{ AX }
	| "Ay"						{ AY }
	| "Bx"						{ BX }
	| "By"						{ BY }
	| "Cx"						{ CX }
	| "CY"						{ CY }
	| "sideA"					{ SIDEA }
	| "sideB" 					{ SIDEB }
	| "sideC" 					{ SIDEC }
	| '('						{ LPAREN }
	| ')'						{ RPAREN }
	| '['						{ LBRACKET }
	| ']'						{ RBRACKET }
	| '{'						{ LBRACE }
	| '}'						{ RBRACE }
	| '.'						{ DOT }
	| ':'						{ COLON }
	| ';'						{ SEMI}
	| ','						{ COMMA}
	| '+'						{ PLUS }
	| '-'						{ MINUS }
	| '/'						{ DIVIDE }
	| '*'						{ TIMES }
	| "!="						{ NEQ }
	| ">="						{ GEQ} 
	| '>'						{ GT }
        | "<="						{ LEQ} 
	| '<'						{ LT }
	| '\"'[^'\"']* '\"' as astring 			{ STRING(astring) }
	| (letter | '_') (letter | digit | '_') (letter | '_' | digit)* as id 		{ ID(id) }
	| digit+ '.' digit+  as value							{ NUM(float_of_string value) }
	| ("true" | "false") as bvalue							{ BOOL(bvalue) }
	| '@' 						{ comment lexbuf }
	| eof 						{ EOF }

and comment = 
	parse '\n' 				{ token lexbuf }
	| _					{ comment lexbuf } 





