%{ open Ast %}

%token 	INITIALIZATION  RULES  OPERATIONS EOF
%token	RULE
%token	VALUE
%token	WHILE  IF WILDCAT  PRINTS  PRINTV	
%token	TRIANGLE  VERTEX  LINE	
%token	AX AY BX BY CX CY SIDEA  SIDEB  SIDEC	 
%token	ASSIGN SIN  COS  TAN  ARCSIN  ARCCOS  ARCTAN  SQRT
%token	LPAREN  RPAREN  LBRACKET  RBRACKET  LBRACE  RBRACE
%token	SEMI  COMMA COLON DOT
%token 	TRUE  FALSE  
%token	AND  OR  NOT EQ  NEQ  GT  LT GEQ LEQ
%token	PLUS  MINUS  DIVIDE  TIMES	
%token	<string> ID	
%token	<float> NUM
%token	<string> BOOL
%token	<string> STRING 


%right	ASSIGN
%left	AND  OR  
%left	EQ  NEQ NOT
%left	LT GT GEQ LEQ
%left	PLUS  MINUS 
%left	DIVIDE  TIMES	


%start program
%type <Ast.program> program
%%


program: 
	initialization rules operations	{$1, $2, $3} 

/*INITIALIZE*/
initialization:
	INITIALIZATION COLON initial_declarator_list
					{$3}

initial_declarator_list:
	/*NOTHING*/			{ [ ] , [ ] }
	|	initial_declarator_list value_declarator
					{ ( (fst $1) @ [$2]), snd $1}
	|	initial_declarator_list triangle_declarator	
					{ fst $1, ((snd $1) @ [$2])}

value_declarator:
	VALUE ID NUM SEMI		{{vname= $2; value= $3;}}
/* type 0 for value, 1 for triangle */
triangle_declarator:
	TRIANGLE ID line_status	 vertex_status SEMI
					{ { tname = $2;	tline = $3;	tvertex = $4; } }	

vertex_status:
	/*NOTHING*/			{ { avtxx =0.0; 
					    avtxy =0.0;
					    bvtxx =0.0; 
					    bvtxy =0.0;	
					  cvtxx =0.0; 
					    cvtxy =0.0; } }
	|	VERTEX  LBRACKET  LPAREN initial_value COMMA initial_value RPAREN COMMA  LPAREN initial_value COMMA
		initial_value RPAREN COMMA LPAREN initial_value COMMA initial_value RPAREN RBRACKET
					{ { avtxx =$4; 
					    avtxy =$6;
					    bvtxx =$10; 
					    bvtxy =$12;
					    cvtxx =$16; 
					    cvtxy =$18; } }

line_status:
	/*NOTHING*/			{ { alen = 0.0;
					    blen = 0.0;
					    clen = 0.0; } }
	|	 LINE LBRACKET initial_value COMMA initial_value COMMA initial_value RBRACKET					
					{ { alen = $3;
					    blen = $5;
					    clen = $7; } }

initial_value:
		NUM			{ $1	}
	| 	WILDCAT			{  0.0 	}



/*RULES*/

rules:
	RULES COLON rule_declarator_list {  List.rev $3	}

rule_declarator_list:
	/*NOTHING*/			{ [ ]	 }
	|rule_declarator_list rule_declarator
					{ $2::$1 }
	
rule_declarator:
	ID LPAREN para_opt RPAREN LPAREN expr RPAREN LBRACE numerical_expr RBRACE SEMI
					{ { rname = $1; 
					    paras = $3;
					    cond = $6;  
					    body = $9;}}

para_opt:
	/*NOTHING*/			{ [ ]	}
	| para_lst			{ List.rev $1 }

para_lst:
		para_type ID			{ [{ptp = $1; pname = $2;}] }
	|	para_lst COMMA para_type ID	{ {ptp = $3; pname = $4;}::$1 }

para_type:
		TRIANGLE		{ "triangle" }
	|	VALUE			{ "value" }
		
expr:
	expr AND expr			{Binop($1, And, $3)    }
|	expr OR expr			{Binop($1, Or, $3)	}
| 	NOT expr				{Rev($2 )	}
|	expr EQ expr			{Binop($1, Equal, $3)	}
|	expr NEQ expr			{Binop($1, Neq, $3)	}
|	expr LT expr			{Binop($1, Less, $3)	}
|	expr GT expr			{Binop($1, Greater, $3)}
|	expr LEQ expr			{Binop($1, Leq, $3)	}
|	expr GEQ expr			{Binop($1, Geq, $3)	}
| 	LBRACKET expr RBRACKET		{  $2	}
| 	numerical_expr		    	{Nexpr($1)} 

oexpr:
	expr									{Expr($1)}
|	RULE ID LPAREN para_opt RPAREN		{Rulec($2, $4)}

numerical_expr:
	NUM										{Num($1)}
|	BOOL									{Bool($1)}
|	VALUE ID								{Val($2)}
|	TRIANGLE ID DOT element					{Tri_ele($2, $4)}
|	numerical_expr MINUS numerical_expr		{Binop2($1,Minus,$3)}
| 	numerical_expr PLUS numerical_expr		{Binop2($1,Plus,$3)}
| 	numerical_expr TIMES numerical_expr		{Binop2($1,Times,$3)}
| 	numerical_expr DIVIDE numerical_expr	{Binop2($1,Divide,$3)}
| 	SIN LPAREN numerical_expr RPAREN		{Monop(Sin, $3)	}
| 	COS LPAREN numerical_expr RPAREN		{Monop(Cos, $3)	}
| 	TAN LPAREN numerical_expr RPAREN		{Monop(Tan, $3)	}
| 	ARCSIN LPAREN numerical_expr RPAREN		{Monop(Arcs, $3)}
| 	ARCCOS LPAREN numerical_expr RPAREN		{Monop(Arcc, $3)}
| 	ARCTAN LPAREN numerical_expr RPAREN		{Monop(Arct, $3)}
|	SQRT LPAREN numerical_expr RPAREN		{Monop(Sqrt, $3)}
|   LPAREN numerical_expr RPAREN			{$2}


/*
arg_opt:
			{ [ ] }
	| arg_lst			{ List.rev $1 }

arg_lst:
		arg									{[$1] }
	|	arg_lst COMMA arg					{ $3::$1 }
arg:
	  TRIANGLE ID			{{atp = "triangle"; vid = "na"; tid = $2}}
	| VALUE ID				{{atp = "value";  vid = $2; tid = "na"}}*/


element:
	AX					{ 0 }
|	AY					{ 1 }
|	BX					{ 2 }
|	BY					{ 3 }
|	CX					{ 4 }
|	CY					{ 5 }
|	SIDEA				{ 6 }
|	SIDEB				{ 7 }
|	SIDEC				{ 8 }



operations:
	OPERATIONS COLON operation_list		{List.rev $3}

operation_list:
	 /*NOTHING*/				{ [ ]	}
	
	|	operation_list operation	{ $2 :: $1 }

operation:
	LBRACE operation_list RBRACE		{ Block(List.rev $2) }
	| PRINTS LPAREN STRING RPAREN SEMI	{ Prints($3) }
	| PRINTV LPAREN expr RPAREN SEMI	{ Printv($3) }
	| IF LPAREN expr RPAREN LBRACE operation RBRACE
						{ If($3, $6) }
	| WHILE LPAREN expr RPAREN LBRACE operation RBRACE
						    { While($3, $6) }
	| ID ASSIGN oexpr SEMI		{ Assign($1, $3) }









