import java.util.ArrayList;
import java.util.Stack;
import java.io.*;

public class interpreter {
	static String error1 = "Segmentation Fault";
	static String error2 = " (core dumped)";
	
	public static void main(String[] args) {
		// Create a new, empty stack, used as register
        Stack register = new Stack();
		// Create a new, empty arraylist, used for storing global variables 
        ArrayList<String> globalVar = new ArrayList<String>();
        // Create a new, empty arraylist, used for storing local variables
        //ArrayList<String> localVar = new ArrayList<String>();
        // Create a new, empty arraylist, used for storing converted byte code for rule
        ArrayList<String[]> rulecode = new ArrayList();
        // Create a new, empty arraylist, used for storing converted byte code for operation
        ArrayList<String[]> opcode = new ArrayList();
        
        //-----------------------------------------------------------------------
        //read the bytecode file, store corresponding data
        boolean rule = false;//flag to check whether to start reading rule from bytecode
        boolean operation = false;//flag to check whether to start reading operation from bytecode file
        
        try{
        	  // Open the bytecode file 
        	  FileInputStream fstream = new FileInputStream("src/IR.txt");
        	  // Get the object of DataInputStream
        	  DataInputStream in = new DataInputStream(fstream);
        	  BufferedReader br = new BufferedReader(new InputStreamReader(in));
        	  String strLine;
        	  //Read File Line By Line
        	  while ((strLine = br.readLine()) != null)   {
        		  if(strLine.equals("rul"))
        			  rule = true;
        		  if(strLine.equals("opt"))
        			  operation = true;
        		  if(rule == false && operation == false && !strLine.isEmpty()){//assign the global variable into arraylist:globalVar
        			  globalVar.add(strLine);
        		  }
        		  else if(rule == true && operation == false && !strLine.isEmpty() && !strLine.equals("rul")){
        			  String delims = "\\s+";
        			  String[] tokens = strLine.split(delims);
        			  rulecode.add(tokens);
        		  }
        		  else if(operation == true && !strLine.equals("opt") && !strLine.isEmpty()){//assign the operation into arraylist:code
        			  String delims = "\\s+";
        			  String[] tokens = strLine.split(delims);
        			  opcode.add(tokens);        			  
        		  }
        	  }
        	  //Close the input stream
        	  in.close();
        }catch (Exception e){//Catch exception if any
        	  System.err.println("Error: " + e.getMessage());
        }
		
        
        
        //test, print out what has stored in the rulecode and opcode
        /*System.out.println(rulecode.size());
        for(int i=0;i<rulecode.size();i++){
        	for(int j=0;j<rulecode.get(i).length;j++){
        		System.out.println(rulecode.get(i)[j]);
        	}
        	
        }
        
        for(int i=0;i<opcode.size();i++){
        	for(int j=0;j<opcode.get(i).length;j++){
        		System.out.println(opcode.get(i)[j]);
        	}
        	
        }*/
        
        //-----------------------------------------------------------------------
        //operation start
        int pc = 0; //init programming counter
        int rc = 0; //init rule counter(function counter)
        double temp = 0;//used for temporary store a num for math operation, popped from register  
        String x ="";//used for temporary store a string for math operation, first popped from register
        String y ="";//used for temporary store a string for math operation, second popped from register
        while(!opcode.get(pc)[0].equalsIgnoreCase("hlt")){
        	switch(opcode.get(pc)[0]){
        		case "rc":
        			//if(!isInt(opcode.get(pc)[1]) || Integer.parseInt(opcode.get(pc)[1])>=globalVar.size()){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			rc = Integer.parseInt(opcode.get(pc)[1]);
        			/*a huge while*/
        			while(!rulecode.get(rc)[0].equalsIgnoreCase("rtn")){
        	        	switch(rulecode.get(rc)[0]){
        	        		case "lod":
        	        			//if(!isInt(rulecode.get(rc)[1]) || Integer.parseInt(rulecode.get(rc)[1])>=globalVar.size()){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			register.push( globalVar.get((int)Double.parseDouble(rulecode.get(rc)[1])) );
        	        			break;
        	        		case "str":
        	        			//if(!isInt(rulecode.get(rc)[1]) || Integer.parseInt(rulecode.get(rc)[1])>=globalVar.size()){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			globalVar.set(Integer.parseInt(rulecode.get(rc)[1]),(String) register.pop());
        	        			break;
        	        		case "psh":
        	        			//if(!isInt(rulecode.get(rc)[1]) || Integer.parseInt(rulecode.get(rc)[1])>=rulecode.size()){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			//System.out.println(rulecode.get(Integer.parseInt(rulecode.get(rc)[1]))[0]);
        	        			//System.out.println(Integer.parseInt(rulecode.get(rc)[1]));
        	        			register.push( rulecode.get(Integer.parseInt(rulecode.get(rc)[1]))[0]);//original localval.get
        	        			//System.out.println(register.peek());
        	        			break;
        	        		case "pop"://push, into local variable
        	        			//if(!isInt(rulecode.get(rc)[1]) || Integer.parseInt(rulecode.get(rc)[1])>=rulecode.size()){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			String[] tokens = {(String) register.pop()};
        	        			//System.out.println(rulecode.get(rc)[1]);
        	        			rulecode.set(Integer.parseInt(rulecode.get(rc)[1]),tokens);//original localval.set
        	        			//System.out.println(rulecode.get(Integer.parseInt(rulecode.get(rc)[1]))[0]);
        	        			break;
        	        		case "ldf"://load float point number/or anything into register immediately
        	        			register.push(rulecode.get(rc)[1]);
        	        			//System.out.println(register.peek());
        	        			break;	
        	        		case "bra"://jump
        	        			//if(!isInt(rulecode.get(rc)[1])){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			rc += Integer.parseInt(rulecode.get(rc)[1]) - 1;//jump to relevant position 
        	        			break;
        	        		case "bne":
        	        			//if(!isInt(rulecode.get(rc)[1])){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			if(Double.parseDouble(x)!=0.0)
        	        				rc += Integer.parseInt(rulecode.get(rc)[1]) - 1;//jump to relevant position if not equal to zero
        	        			//System.out.println(rc);
        	        			break;    
        	        		case "beq":
        	        			//if(!isInt(rulecode.get(rc)[1])){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			if(Double.parseDouble(x)==0.0)
        	        				rc += Integer.parseInt(rulecode.get(rc)[1]) - 1;//jump to relevant position if equal to zero
        	        			break; 
        	        		case "and":
        	        			x = (String) register.pop();
        	        			y = (String) register.pop();
        	        			if(Double.parseDouble(x)==0.0 ||Double.parseDouble(y)==0.0)        			
        	        				register.push("0.0");
        	        			else
        	        				register.push("1.0");
        	        			break;
        	        		case "or":
        	        			x = (String) register.pop();
        	        			y = (String) register.pop();
        	        			if(Double.parseDouble(x)!=0.0 ||Double.parseDouble(y)!=0.0)        			
        	        				register.push("1.0");
        	        			else
        	        				register.push("0.0");
        	        			break;
        	        		case "eql":
        	        			x = (String) register.pop();
        	        			y = (String) register.pop();
        	        			if(Double.parseDouble(x)==Double.parseDouble(y))        			
        	        				register.push("1.0");
        	        			else
        	        				register.push("0.0");
        	        			break;
        	        		case "neq":
        	        			x = (String) register.pop();
        	        			y = (String) register.pop();
        	        			if(Double.parseDouble(x)!=Double.parseDouble(y))        			
        	        				register.push("1.0");
        	        			else
        	        				register.push("0.0");
        	        			break;
        	        		case "les":
        	        			x = (String) register.pop();
        	        			y = (String) register.pop();
        	        			if(Double.parseDouble(y)<Double.parseDouble(x))        			
        	        				register.push("1.0");
        	        			else
        	        				register.push("0.0");
        	        			break;
        	        		case "gtr":
        	        			x = (String) register.pop();
        	        			y = (String) register.pop();
        	        			if(Double.parseDouble(x)>Double.parseDouble(y))        			
        	        				register.push("1.0");
        	        			else
        	        				register.push("0.0");
        	        			break;	
        	        		case "leq":
        	    			x = (String) register.pop();
        	    			y = (String) register.pop();
        	    			if(Double.parseDouble(x)<=Double.parseDouble(y))        			
        	    				register.push("1.0");
        	    			else
        	    				register.push("0.0");
        	    			break;	
        	        		case "geq":
        	    			x = (String) register.pop();
        	    			y = (String) register.pop();
        	    			if(Double.parseDouble(x)>=Double.parseDouble(y))        			
        	    				register.push("1.0");
        	    			else
        	    				register.push("0.0");
        	    			break;	
        	        		case "not":
        	        			x = (String) register.pop();
        	        			if(!isNumeric(x)){
        	        				System.out.println(error1+error2);
        	        				return;
        	        			}
        	        			if(Double.parseDouble(x)==0.0)
        	        				x = "1.0";
        	        			else
        	        				x = "0.0";
        	        			register.push(x);
        	        			break;
        	        		case "add":
        	        			x = (String) register.pop();
        	        			if(!isNumeric(x)){
        	        				System.out.println(error1+error2);
        	        				return;
        	        			}
        	        			y = (String) register.pop();
        	        			//if(!isNumeric(y)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}        			
        	        			temp = Double.parseDouble(x) + Double.parseDouble(y);
        	        			register.push(Double.toString(temp));
        	        			break;
        	        		case "sub"://stack1 - stack2
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			y = (String) register.pop();
        	        			//if(!isNumeric(y)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}        			
        	        			temp = Double.parseDouble(y) - Double.parseDouble(x);
        	        			register.push(Double.toString(temp));
        	        			break;
        	        		case "mul":
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			y = (String) register.pop();
        	        			//if(!isNumeric(y)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}        			
        	        			temp = Double.parseDouble(x) * Double.parseDouble(y);
        	        			register.push(Double.toString(temp));
        	        			break;
        	        		case "div"://stack1 / stack2
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			y = (String) register.pop();
        	        			//if(!isNumeric(y)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}        			
        	        			temp = Double.parseDouble(y) / Double.parseDouble(x);
        	        			register.push(Double.toString(temp));
        	        			break;
        	        		case "addi":
        	        			//if(!isNumeric(rulecode.get(rc)[1])){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			
        	        			temp = Double.parseDouble(rulecode.get(rc)[1]);
        	        			temp += Double.parseDouble(x);
        	        			register.push(Double.toString(temp));
        	        			break;
        	        		case "subi":
        	        			//if(!isNumeric(rulecode.get(rc)[1])){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			
        	        			temp = Double.parseDouble(rulecode.get(rc)[1]);
        	        			temp = Double.parseDouble(x) - temp;
        	        			register.push(Double.toString(temp));
        	        			break;
        	        		case "muli":
        	        			//if(!isNumeric(rulecode.get(rc)[1])){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			
        	        			temp = Double.parseDouble(rulecode.get(rc)[1]);
        	        			temp *= Double.parseDouble(x);
        	        			register.push(Double.toString(temp));
        	        			break;
        	        		case "divi":
        	        			//if(!isNumeric(rulecode.get(rc)[1])){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			
        	        			temp = Double.parseDouble(rulecode.get(rc)[1]);
        	        			temp = Double.parseDouble(x) / temp;
        	        			register.push(Double.toString(temp));
        	        			break;	
        	        		case "sqt"://sqrt, range [0,infinite]
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			temp = Double.parseDouble(x);
        	        			//if(temp<0){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			temp = Math.sqrt(temp);
        	        			register.push(Double.toString(temp));
        	        			break;	 
        	        		case "sin":
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			
        	        			temp = Math.sin(Double.parseDouble(x));
        	        			register.push(Double.toString(temp));
        	        			break;
        	        		case "cos":
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			
        	        			temp = Math.cos(Double.parseDouble(x));
        	        			register.push(Double.toString(temp));
        	        			break;
        	        		case "tan":
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			
        	        			temp = Math.tan(Double.parseDouble(x));
        	        			register.push(Double.toString(temp));
        	        			break; 
        	        		case "acs"://arcsin, range [-1,1]
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			temp = Double.parseDouble(x);
        	        			//if(temp<-1 || temp>1){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			temp = Math.asin(temp);
        	        			register.push(Double.toString(temp));
        	        			break;     
        	        		case "acc"://arccos, range [-1,1]
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			temp = Double.parseDouble(x);
        	        			//if(temp<-1 || temp>1){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			temp = Math.acos(temp);
        	        			register.push(Double.toString(temp));
        	        			break;  
        	        		case "act":
        	        			x = (String) register.pop();
        	        			//if(!isNumeric(x)){
        	        			//	System.out.println(error1+error2);
        	        			//	return;
        	        			//}
        	        			
        	        			temp = Math.atan(Double.parseDouble(x));
        	        			register.push(Double.toString(temp));
        	        			break;          			
        	        		case "ptv":
        	        			System.out.println(register.pop());
        	        			break;
        	        		case "pts":
        	        			for(int i=1;i<rulecode.get(rc).length;i++){
        	        				System.out.print(rulecode.get(rc)[i]);
        	        				System.out.print(" ");
        	        			}
        	        			System.out.println();
        	        			break;
        	        		default:
        	        			System.out.println(rulecode.get(rc)[0]);
        	        	}
        	        	rc++;
        	        }
        			/*finish a huge while*/
        			break;
        		case "lod":
        			//if(!isInt(opcode.get(pc)[1]) || Integer.parseInt(opcode.get(pc)[1])>=globalVar.size()){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			
        			register.push( globalVar.get((int)Double.parseDouble(opcode.get(pc)[1])) );
        			break;
        		case "str":
        			//if(!isInt(opcode.get(pc)[1]) || Integer.parseInt(opcode.get(pc)[1])>=globalVar.size()){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			globalVar.set(Integer.parseInt(opcode.get(pc)[1]),(String) register.pop());
        			break;
        		case "psh":
        			//if(!isInt(opcode.get(pc)[1]) || Integer.parseInt(opcode.get(pc)[1])>=rulecode.size()){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			register.push( rulecode.get(Integer.parseInt(opcode.get(pc)[1]))[0] );
        			break;
        		case "pop"://push, into local variable
        			//if(!isInt(opcode.get(pc)[1]) || Integer.parseInt(opcode.get(pc)[1])>=rulecode.size()){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			String[] tokens = {(String) register.pop()};
        			rulecode.set(Integer.parseInt(opcode.get(pc)[1]),tokens);
        			break;
        		case "ldf"://load float point number/or anything into register immediately
        			register.push(opcode.get(pc)[1]);
        			break;
        		case "bra"://jump
        			//if(!isInt(opcode.get(pc)[1])){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			pc += Integer.parseInt(opcode.get(pc)[1]) - 1;//jump to relevant position 
        			break;
        		case "bne":
        			//if(!isInt(opcode.get(pc)[1])){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			if(Double.parseDouble(x)!=0.0)
        				pc += Integer.parseInt(opcode.get(pc)[1]) - 1;//jump to relevant position if not equal to zero
        			break;    
        		case "beq":
        			//if(!isInt(opcode.get(pc)[1])){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			if(Double.parseDouble(x)==0.0)
        				pc += Integer.parseInt(opcode.get(pc)[1]) - 1;//jump to relevant position if equal to zero
        			break;  
        		case "and":
        			x = (String) register.pop();
        			y = (String) register.pop();
        			if(Double.parseDouble(x)==0 || Double.parseDouble(y)==0)        			
        				register.push("0.0");
        			else
        				register.push("1.0");
        			break;
        		case "or":
        			x = (String) register.pop();
        			y = (String) register.pop();
        			if(Double.parseDouble(x)!=0 || Double.parseDouble(y)!=0)        			
        				register.push("1.0");
        			else
        				register.push("0.0");
        			break;
        		case "eql":
        			x = (String) register.pop();
        			y = (String) register.pop();
        			if(Double.parseDouble(x)==Double.parseDouble(y))        			
        				register.push("1.0");
        			else
        				register.push("0.0");
        			break;
        		case "neq":
        			x = (String) register.pop();
        			y = (String) register.pop();
        			if(Double.parseDouble(x)!=Double.parseDouble(y))        			
        				register.push("1.0");
        			else
        				register.push("0.0");
        			break;
        		case "les":
        			x = (String) register.pop();
        			y = (String) register.pop();
        			if(Double.parseDouble(x)<Double.parseDouble(y))        			
        				register.push("1.0");
        			else
        				register.push("0.0");
        			break;
        		case "gtr":
        			x = (String) register.pop();
        			y = (String) register.pop();
        			if(Double.parseDouble(x)>Double.parseDouble(y))        			
        				register.push("1.0");
        			else
        				register.push("0.0");
        			break;	
        		case "leq":
    			x = (String) register.pop();
    			y = (String) register.pop();
    			if(Double.parseDouble(x)<=Double.parseDouble(y))        			
    				register.push("1.0");
    			else
    				register.push("0.0");
    			break;	
        		case "geq":
    			x = (String) register.pop();
    			y = (String) register.pop();
    			if(Double.parseDouble(x)>=Double.parseDouble(y))        			
    				register.push("1.0");
    			else
    				register.push("0.0");
    			break;	
    			case "not":
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			if(Double.parseDouble(x)==0.0)
        				x = "1.0";
        			else
        				x = "0.0";
        			register.push(x);
        			break;
        		case "add":
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			y = (String) register.pop();
        			//if(!isNumeric(y)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}        			
        			temp = Double.parseDouble(x) + Double.parseDouble(y);
        			register.push(Double.toString(temp));
        			break;
        		case "sub"://stack1 - stack2
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			y = (String) register.pop();
        			//if(!isNumeric(y)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}        			
        			temp = Double.parseDouble(y) - Double.parseDouble(x);
        			register.push(Double.toString(temp));
        			break;
        		case "mul":
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			y = (String) register.pop();
        			//if(!isNumeric(y)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}        			
        			temp = Double.parseDouble(x) * Double.parseDouble(y);
        			register.push(Double.toString(temp));
        			break;
        		case "div"://stack1 / stack2
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			y = (String) register.pop();
        			//if(!isNumeric(y)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}        			
        			temp = Double.parseDouble(y) / Double.parseDouble(x);
        			register.push(Double.toString(temp));
        			break;
        		case "addi":
        			//if(!isNumeric(opcode.get(pc)[1])){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			
        			temp = Double.parseDouble(opcode.get(pc)[1]);
        			temp += Double.parseDouble(x);
        			register.push(Double.toString(temp));
        			break;
        		case "subi":
        			//if(!isNumeric(opcode.get(pc)[1])){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			
        			temp = Double.parseDouble(opcode.get(pc)[1]);
        			temp = Double.parseDouble(x) - temp;
        			register.push(Double.toString(temp));
        			break;
        		case "muli":
        			//if(!isNumeric(opcode.get(pc)[1])){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			
        			temp = Double.parseDouble(opcode.get(pc)[1]);
        			temp *= Double.parseDouble(x);
        			register.push(Double.toString(temp));
        			break;
        		case "divi":
        			//if(!isNumeric(opcode.get(pc)[1])){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			
        			temp = Double.parseDouble(opcode.get(pc)[1]);
        			temp = Double.parseDouble(x) / temp;
        			register.push(Double.toString(temp));
        			break;	
        		case "sqt"://sqrt, range [0,infinite]
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			temp = Double.parseDouble(x);
        			//if(temp<0){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			temp = Math.sqrt(temp);
        			register.push(Double.toString(temp));
        			break;	 
        		case "sin":
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			
        			temp = Math.sin(Double.parseDouble(x));
        			register.push(Double.toString(temp));
        			break;
        		case "cos":
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			
        			temp = Math.cos(Double.parseDouble(x));
        			register.push(Double.toString(temp));
        			break;
        		case "tan":
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			
        			temp = Math.tan(Double.parseDouble(x));
        			register.push(Double.toString(temp));
        			break; 
        		case "acs"://arcsin, range [-1,1]
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			temp = Double.parseDouble(x);
        			//if(temp<-1 || temp>1){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			temp = Math.asin(temp);
        			register.push(Double.toString(temp));
        			break;     
        		case "acc"://arccos, range [-1,1]
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			temp = Double.parseDouble(x);
        			//if(temp<-1 || temp>1){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			temp = Math.acos(temp);
        			register.push(Double.toString(temp));
        			break;  
        		case "act":
        			x = (String) register.pop();
        			//if(!isNumeric(x)){
        			//	System.out.println(error1+error2);
        			//	return;
        			//}
        			
        			temp = Math.atan(Double.parseDouble(x));
        			register.push(Double.toString(temp));
        			break;          			
        		case "ptv":
        			System.out.println(register.pop());
        			break;
        		case "pts":
        			for(int i=1;i<opcode.get(pc).length;i++){
        				System.out.print(opcode.get(pc)[i]);
        				System.out.print(" ");
        			}
        			System.out.println();
        			break;
        		default:
        			System.out.println(opcode.get(pc)[0]);
        	}
        	pc++;
        }
	}
	
	//helper methods
	//check whether a String is a numeric type
	public static boolean isNumeric(String str){
		return str.matches("-?\\d+(\\.\\d+)?");  //match a number with optional '-' and decimal.
	}
	public static boolean isInt(String str){
		try{  
			int d = Integer.parseInt(str);  
		}  
		catch(NumberFormatException nfe){  
		    return false;  
		}  
		return true;  
	}
}